/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import com.ontotext.platform.extended.scalars.NumericScalarsUtil;
import graphql.GraphQLContext;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;

class PatternBasedCoercing
implements Coercing<String, String> {
    private final String typeName;
    private final Pattern typePattern;

    PatternBasedCoercing(String typeName, Pattern typePattern) {
        this.typeName = typeName;
        this.typePattern = typePattern;
    }

    public String serialize(Object dataFetcherResult) {
        if (dataFetcherResult instanceof String) {
            return (String)dataFetcherResult;
        }
        throw new CoercingSerializeException(this.typeName + " value " + String.valueOf(dataFetcherResult) + " must be a string");
    }

    public String parseValue(Object input) {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Expected a 'String' but was '" + NumericScalarsUtil.typeName(input) + "'.");
        }
        return PatternBasedCoercing.parse(input.toString(), this.typePattern, this.typeName, CoercingParseValueException::new);
    }

    public String parseLiteral(Object input) {
        if (input instanceof StringValue) {
            return PatternBasedCoercing.parse(((StringValue)input).getValue(), this.typePattern, this.typeName, CoercingParseLiteralException::new);
        }
        throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + NumericScalarsUtil.typeName(input) + "'.");
    }

    public Value<?> valueToLiteral(Object input, GraphQLContext graphQlContext, Locale locale) {
        return StringValue.of((String)this.parseValue(input));
    }

    private static String parse(String value, Pattern pattern, String type, Function<String, RuntimeException> exceptionMaker) {
        if (!pattern.matcher(value).matches()) {
            throw exceptionMaker.apply("Invalid value '" + value + "' for type '" + type + "'");
        }
        return value;
    }
}

