/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import graphql.schema.CoercingParseLiteralException;
import java.math.BigDecimal;

class NumericScalarsUtil {
    private NumericScalarsUtil() {
        throw new InstantiationError("You shouldn't do that!");
    }

    static BigDecimal toDecimal(Object value) {
        if (!NumericScalarsUtil.isNumberRepresentable(value)) {
            return null;
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static boolean isNumberRepresentable(Object value) {
        return value instanceof Number || value instanceof String;
    }

    static String typeName(Object value) {
        if (value == null) {
            return "null";
        }
        return value.getClass().getSimpleName();
    }

    static <T> void verifyType(Object value, Class<T> type, String expectedType) throws CoercingParseLiteralException {
        if (!type.isInstance(value)) {
            throw new CoercingParseLiteralException(String.format("Expected AST type '%s' but was '%s'.", expectedType, NumericScalarsUtil.typeName(value)));
        }
    }
}

