/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import com.ontotext.platform.extended.scalars.NumericScalarsUtil;
import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DecimalCoercing
implements Coercing<BigDecimal, String> {
    public String serialize(Object input) {
        return this.convert(input, CoercingSerializeException::new).toString();
    }

    public BigDecimal parseValue(Object input) {
        return this.convert(input, CoercingParseValueException::new);
    }

    private BigDecimal convert(Object input, Function<String, GraphQLException> excProvider) throws GraphQLException {
        BigDecimal decimal = NumericScalarsUtil.toDecimal(input);
        if (decimal != null) {
            return decimal;
        }
        throw excProvider.apply(String.format("Expected type 'BigDecimal', but was '%s'.", NumericScalarsUtil.typeName(input)));
    }

    public BigDecimal parseLiteral(Object input) throws CoercingParseLiteralException {
        if (input instanceof StringValue) {
            String value = ((StringValue)StringValue.class.cast(input)).getValue();
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException nfe) {
                throw new CoercingParseLiteralException(String.format("Unable to turn AST input into a 'BigDecimal' : '%s'", value));
            }
        }
        if (input instanceof IntValue) {
            return new BigDecimal(((IntValue)IntValue.class.cast(input)).getValue());
        }
        if (input instanceof FloatValue) {
            return ((FloatValue)FloatValue.class.cast(input)).getValue();
        }
        throw new CoercingParseLiteralException(String.format("Expected AST type 'IntValue', 'StringValue' or 'FloatValue' but was '%s'.", NumericScalarsUtil.typeName(input)));
    }

    @NotNull
    public Value<?> valueToLiteral(@NotNull Object input, @NotNull GraphQLContext graphQlContext, @NotNull Locale locale) {
        return FloatValue.newFloatValue((BigDecimal)this.parseValue(input)).build();
    }
}

