/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.Configs;
import com.ontotext.models.Queries;
import com.ontotext.models.QueryShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.platform.GraphQlFieldArgumentBuilder;
import com.ontotext.platform.GraphQlQueryBuilderExtension;
import com.ontotext.platform.GraphQlRbac;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.GraphQlTypeUtil;
import com.ontotext.platform.SomlUndefinedQueryShapeTargetException;
import com.ontotext.soaas.common.StringManipulation;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SomlObjects2GraphQlQueryFields
implements GraphQlQueryBuilderExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void build(SomlSchema soml, GraphQLObjectType.Builder queryBuilder, GraphQlSchemaBuilderExtension.Options options) throws SomlConversionException {
        GraphQlRbac rbacBuilder = new GraphQlRbac(soml, options.isRbacEnabled());
        this.populateGraphQlSchemaWithQueryShapes(soml, queryBuilder, rbacBuilder);
    }

    private void populateGraphQlSchemaWithQueryShapes(SomlSchema somlSchema, GraphQLObjectType.Builder queryBuilder, GraphQlRbac rbacBuilder) throws SomlUndefinedQueryShapeTargetException {
        Queries allQueries = somlSchema.getQueries();
        this.generateBaseGraphQlQueries(somlSchema, queryBuilder, rbacBuilder);
        if (null != allQueries) {
            for (Map.Entry queryEntry : allQueries.entrySet()) {
                String queryKey = (String)queryEntry.getKey();
                Shape rootShape = (Shape)somlSchema.getObjects().get((Object)StringUtils.capitalize((String)queryKey));
                if (null == rootShape) {
                    throw new SomlUndefinedQueryShapeTargetException("Query: " + queryKey + " has no target object to associate with.", queryKey);
                }
                ((QueryShape)queryEntry.getValue()).setRootShape(rootShape);
                String rootId = rootShape.asGraphQl();
                queryBuilder.field(this.createFieldDefinitionBuilder(queryKey, (GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(rootId)), rootId));
            }
        }
    }

    private void generateBaseGraphQlQueries(SomlSchema somlSchema, GraphQLObjectType.Builder queryBuilder, GraphQlRbac rbacBuilder) {
        LOGGER.info("Generating base queries for {}", (Object)somlSchema.getId());
        queryBuilder.field(this.createQueryFieldDefinition((Shape)somlSchema.getObjects().get((Object)"Object"), null));
        for (Shape singleShape : somlSchema.getObjects().values()) {
            if (Boolean.TRUE.equals(singleShape.isSynthetic()) || !singleShape.getAccessMode().canRead() || GraphQlTypeUtil.getNotQueryableTypes().contains(singleShape.getId())) continue;
            queryBuilder.field(this.createQueryFieldDefinition(singleShape, rbacBuilder));
        }
    }

    private GraphQLFieldDefinition createQueryFieldDefinition(Shape shape, GraphQlRbac rbacBuilder) {
        String refName = shape.asGraphQl();
        Configs config = shape.getContainedIn().getContainedIn().getConfig();
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(config.getQueryName(StringUtils.uncapitalize((String)refName))).description("Query for " + refName).argument(GraphQlFieldArgumentBuilder.id()).argument(GraphQlFieldArgumentBuilder.order(refName)).argument(GraphQlFieldArgumentBuilder.where(refName)).argument(GraphQlFieldArgumentBuilder.limit()).argument(GraphQlFieldArgumentBuilder.offset()).argument(GraphQlFieldArgumentBuilder.lang()).argument(GraphQlFieldArgumentBuilder.includeInferred()).argument(GraphQlFieldArgumentBuilder.expandOverSameAs()).argument(GraphQlFieldArgumentBuilder.repository()).argument(GraphQlFieldArgumentBuilder.from()).argument(GraphQlFieldArgumentBuilder.errorsFormat()).type((GraphQLOutputType)GraphQlTypeUtil.newNonNullList(refName));
        if (rbacBuilder != null) {
            rbacBuilder.addQueryRoles(arg_0 -> ((GraphQLFieldDefinition.Builder)fieldBuilder).withDirective(arg_0), shape);
        }
        return fieldBuilder.build();
    }

    private GraphQLFieldDefinition.Builder createFieldDefinitionBuilder(String fieldName, GraphQLOutputType fieldType, String rootObjName) {
        fieldName = StringManipulation.toGraphQlModelName((String)fieldName);
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name(fieldName).type(fieldType);
        if (fieldType instanceof GraphQLNonNull) {
            fieldType = (GraphQLOutputType)((GraphQLNonNull)fieldType).getWrappedType();
        }
        String orderingReferenceName = "";
        if (GraphQlTypeUtil.extractRootType((GraphQLType)fieldType) instanceof GraphQLTypeReference) {
            orderingReferenceName = rootObjName;
            builder.argument(GraphQlFieldArgumentBuilder.lang());
        }
        if (fieldType instanceof GraphQLList) {
            builder.argument(GraphQlFieldArgumentBuilder.id()).argument(GraphQlFieldArgumentBuilder.where(GraphQlTypeUtil.extractRootType((GraphQLType)fieldType).getName())).argument(GraphQlFieldArgumentBuilder.order(orderingReferenceName)).argument(GraphQlFieldArgumentBuilder.limit()).argument(GraphQlFieldArgumentBuilder.offset());
        }
        return builder;
    }
}

