/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.platform.extended.scalars.DateTimeScalars;
import com.ontotext.platform.extended.scalars.DurationScalars;
import com.ontotext.platform.extended.scalars.NumericScalars;
import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GraphQlTypeUtil {
    private static final List<GraphQLScalarType> SUPPORTED_TYPES = Arrays.asList(Scalars.GraphQLID, Scalars.GraphQLString, Scalars.GraphQLBoolean, ExtendedScalars.GraphQLShort, ExtendedScalars.GraphQLByte, Scalars.GraphQLInt, NumericScalars.INTEGER, ExtendedScalars.GraphQLLong, Scalars.GraphQLFloat, NumericScalars.DECIMAL, NumericScalars.UNSIGNED_LONG, NumericScalars.UNSIGNED_INTEGER, NumericScalars.UNSIGNED_SHORT, NumericScalars.UNSIGNED_BYTE, DateTimeScalars.DATE, DateTimeScalars.TIME, DateTimeScalars.DATE_TIME, DateTimeScalars.YEAR, DateTimeScalars.YEAR_MONTH, NumericScalars.POSITIVE_INTEGER, NumericScalars.NEGATIVE_INTEGER, NumericScalars.NON_POSITIVE_INTEGER, NumericScalars.NON_NEGATIVE_INTEGER, NumericScalars.POSITIVE_FLOAT, NumericScalars.NEGATIVE_FLOAT, NumericScalars.NON_POSITIVE_FLOAT, NumericScalars.NON_NEGATIVE_FLOAT, DurationScalars.DURATION, DurationScalars.DAY_TIME_DURATION, DurationScalars.YEAR_MONTH_DURATION);
    private static final Map<String, GraphQLScalarType> SCALAR_TYPE_MAP = ImmutableMap.copyOf(SUPPORTED_TYPES.stream().collect(Collectors.toMap(GraphQLNamedSchemaElement::getName, Function.identity())));
    private static final Set<String> notQueryableTypes = GraphQlTypeUtil.createNotQueryableTypes();
    private static final Set<String> baseTypes = GraphQlTypeUtil.createBaseTypes();

    private static Set<String> createBaseTypes() {
        Set baseTypes = new SomlSchemaParser().getBaseSchema().getObjects().keySet();
        return ImmutableSet.copyOf((Collection)baseTypes);
    }

    private static Set<String> createNotQueryableTypes() {
        Set baseTypes = new SomlSchemaParser().getBaseSchema().getObjects().keySet();
        baseTypes.remove("HealthCheck");
        baseTypes.remove("Object");
        return ImmutableSet.copyOf((Collection)baseTypes);
    }

    private GraphQlTypeUtil() {
    }

    public static Set<String> getNotQueryableTypes() {
        return notQueryableTypes;
    }

    public static Set<String> getBaseTypes() {
        return baseTypes;
    }

    static Map<String, GraphQLScalarType> getScalarTypeMap() {
        return SCALAR_TYPE_MAP;
    }

    public static GraphQLType getScalarOrReference(String typeRaw) {
        GraphQLScalarType scalarType = SCALAR_TYPE_MAP.get(typeRaw);
        if (null == scalarType) {
            return new GraphQLTypeReference(typeRaw);
        }
        return scalarType;
    }

    static GraphQLArgument.Builder newArgument(String name, GraphQLInputType type) {
        return GraphQLArgument.newArgument().name(name).type(type);
    }

    static GraphQLNamedType extractRootType(GraphQLType type) {
        while (type instanceof GraphQLModifiedType) {
            type = ((GraphQLModifiedType)type).getWrappedType();
        }
        return (GraphQLNamedType)type;
    }

    public static GraphQLList newNonNullListReferenceType(String referenceName) {
        return GraphQlTypeUtil.newNonNullListType((GraphQLType)new GraphQLTypeReference(referenceName));
    }

    static GraphQLList newNonNullListType(GraphQLType type) {
        return new GraphQLList((GraphQLType)new GraphQLNonNull(type));
    }

    public static GraphQLNonNull newNonNullReference(String referenceName) {
        return new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(referenceName));
    }

    public static GraphQLNonNull newNonNullList(String referenceName) {
        return new GraphQLNonNull((GraphQLType)GraphQlTypeUtil.newList(referenceName));
    }

    public static GraphQLList newList(String referenceName) {
        return new GraphQLList((GraphQLType)new GraphQLTypeReference(referenceName));
    }
}

