/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.SchemaLangConfig;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateArgs;
import com.ontotext.platform.DirectivesBuilder;
import com.ontotext.platform.FilterMap;
import com.ontotext.platform.GraphQlFieldArgumentBuilder;
import com.ontotext.platform.GraphQlPropertyTypeCalculator;
import com.ontotext.platform.GraphQlRbac;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.GraphQlTypeUtil;
import com.ontotext.platform.SomlClassShapeInvalidReferenceException;
import com.ontotext.soaas.common.StringManipulation;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class GraphQlTypeBuilder
implements GraphQlSchemaBuilderExtension {
    private static final String ORDER_FIELDS_SUFFIX = "_OrderBy";
    private static final GraphQLTypeReference SCALAR_ORDER_BY = new GraphQLTypeReference("_OrderBy");
    private static final String FILTER_OBJECTS_SUFFIX = "_Where";
    private static final String FILTER_MULTI_SUFFIX = "_Multi";
    private static final String ID_NAME = "ID";
    private static final String LANG_STRING = "LangString";
    private static final Set<String> ignoreShapeIds = new HashSet<String>();
    private final Set<BiConsumer<GraphQLObjectType.Builder, Shape>> onObjectTypeCreate = new LinkedHashSet<BiConsumer<GraphQLObjectType.Builder, Shape>>();
    private final Set<BiConsumer<GraphQLInterfaceType.Builder, Shape>> onInterfaceTypeCreate = new LinkedHashSet<BiConsumer<GraphQLInterfaceType.Builder, Shape>>();
    private final Set<BiConsumer<GraphQLFieldDefinition.Builder, Pair<PropertyShape, String>>> onFieldCreate = new LinkedHashSet<BiConsumer<GraphQLFieldDefinition.Builder, Pair<PropertyShape, String>>>();
    private GraphQlSchemaBuilderExtension.Options options;

    @Override
    public void build(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder, GraphQlSchemaBuilderExtension.Options options) throws SomlConversionException {
        this.options = options;
        GraphQlRbac rbacBuilder = new GraphQlRbac(somlSchema, options.isRbacEnabled());
        for (Shape shape : somlSchema.getObjects().values()) {
            if (ignoreShapeIds.contains(shape.getId()) || Boolean.TRUE.equals(shape.isSynthetic()) || Shapes.RESPONSE_TYPES.contains(shape.getId()) || Shapes.AFFECTED_TYPES.contains(shape.getId()) && !options.areMutationsEnabled()) continue;
            this.populateGraphQlSchemaWithClassShape(shape, schemaBuilder, rbacBuilder);
        }
        this.createBasicEnums(schemaBuilder);
        GraphQlTypeBuilder.addDescriptionDirectiveToSchema(schemaBuilder);
        this.addNameAliasDirectiveToSchema(schemaBuilder);
        this.addConstraintDirectiveToSchema(schemaBuilder);
        this.addMetaDirectiveToSchema(somlSchema, schemaBuilder);
        this.addSomlDirectives(somlSchema, schemaBuilder);
    }

    public static void ignoreShapeId(String id) {
        ignoreShapeIds.add(id);
    }

    public void onObjectTypeCreate(BiConsumer<GraphQLObjectType.Builder, Shape> consumer) {
        this.onObjectTypeCreate.add(consumer);
    }

    public void onInterfaceTypeCreate(BiConsumer<GraphQLInterfaceType.Builder, Shape> consumer) {
        this.onInterfaceTypeCreate.add(consumer);
    }

    public void onFieldCreate(BiConsumer<GraphQLFieldDefinition.Builder, Pair<PropertyShape, String>> consumer) {
        this.onFieldCreate.add(consumer);
    }

    private void createBasicEnums(GraphQLSchema.Builder schemaBuilder) {
        GraphQLEnumType.Builder enumBuilder = new GraphQLEnumType.Builder().name(ORDER_FIELDS_SUFFIX).value("ASC").value("DESC").description("Order fields of scalar arrays.");
        schemaBuilder.additionalType((GraphQLType)enumBuilder.build());
        schemaBuilder.additionalType((GraphQLType)this.createLiteralOrderBy());
        schemaBuilder.additionalType((GraphQLType)this.createLangStringOrderBy());
        schemaBuilder.additionalType(this.createErrorsFormatEnum());
    }

    private GraphQLType createErrorsFormatEnum() {
        return new GraphQLEnumType.Builder().name("ErrorsResponseFormat").value("DEFAULT", (Object)"DEFAULT", "Application default behavior").value("FULL", (Object)"FULL", "All error information is returned").value("COMPACT", (Object)"COMPACT", "Reduced error information is returned, repeated errors returned as one").description("Change the format of the returned errors.").build();
    }

    private GraphQLInputObjectType createLiteralOrderBy() {
        GraphQLInputObjectType.Builder literalInputBuilder = GraphQLInputObjectType.newInputObject().name("Literal_OrderBy");
        literalInputBuilder.field(GraphQLInputObjectField.newInputObjectField().name("value").type((GraphQLInputType)SCALAR_ORDER_BY).defaultValue((Object)"ASC").build());
        literalInputBuilder.field(GraphQLInputObjectField.newInputObjectField().name("lang").type((GraphQLInputType)SCALAR_ORDER_BY).build());
        literalInputBuilder.field(GraphQLInputObjectField.newInputObjectField().name("type").type((GraphQLInputType)SCALAR_ORDER_BY).build());
        return literalInputBuilder.build();
    }

    private GraphQLInputObjectType createLangStringOrderBy() {
        GraphQLInputObjectType.Builder literalInputBuilder = GraphQLInputObjectType.newInputObject().name("LangString_OrderBy");
        literalInputBuilder.field(GraphQLInputObjectField.newInputObjectField().name("lang").type((GraphQLInputType)Scalars.GraphQLString).description("Lang spec that resolves to a single value").build());
        literalInputBuilder.field(GraphQLInputObjectField.newInputObjectField().name("dir").type((GraphQLInputType)SCALAR_ORDER_BY).defaultValue((Object)"ASC").description("Order of literal values").build());
        return literalInputBuilder.build();
    }

    private static void addDescriptionDirectiveToSchema(GraphQLSchema.Builder schemaBuilder) {
        GraphQLDirective.Builder descriptionDirective = DirectivesBuilder.createDescriptionDirectiveBuilder(null);
        schemaBuilder.additionalDirective(descriptionDirective.validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION, Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE, Introspection.DirectiveLocation.UNION}).build());
    }

    private void addNameAliasDirectiveToSchema(GraphQLSchema.Builder schemaBuilder) {
        schemaBuilder.additionalDirective(DirectivesBuilder.createNameAliasDirective(true));
    }

    private void addConstraintDirectiveToSchema(GraphQLSchema.Builder schemaBuilder) {
        schemaBuilder.additionalDirective(DirectivesBuilder.createConstraintsDirectiveDefinition());
    }

    private void addMetaDirectiveToSchema(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder) {
        if (this.isMetaDirectiveNeeded(somlSchema)) {
            schemaBuilder.additionalDirective(DirectivesBuilder.createMetaDirective(null));
        }
    }

    private boolean isMetaDirectiveNeeded(SomlSchema somlSchema) {
        for (PropertyShape globalProp : somlSchema.getProperties().values()) {
            if (globalProp.getMeta().isEmpty()) continue;
            return true;
        }
        for (Shape shape : somlSchema.getObjects().values()) {
            if (!shape.getMeta().isEmpty()) {
                return true;
            }
            for (PropertyShape shapeProp : shape.getProps().values()) {
                if (shapeProp.getMeta().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void populateGraphQlSchemaWithClassShape(Shape shape, GraphQLSchema.Builder schemaBuilder, GraphQlRbac rbacBuilder) throws SomlClassShapeInvalidReferenceException {
        SomlSchema somlSchema = shape.getContainedIn().getContainedIn();
        GraphQLType insertionType = shape.isAbstract() ? this.buildInterfaceType(shape, somlSchema, rbacBuilder) : (shape.isUnion() ? this.buildUnionType(shape, somlSchema, rbacBuilder) : this.buildObjectType(shape, somlSchema, rbacBuilder));
        schemaBuilder.additionalType(insertionType);
        if (Shapes.AFFECTED_TYPES.contains(shape.getId())) {
            return;
        }
        if (!shape.getId().equals("Literal") && !shape.getId().equals("Nameable")) {
            schemaBuilder.additionalType((GraphQLType)this.createOrderByInput(shape).build());
        }
        schemaBuilder.additionalType((GraphQLType)this.createSingleFilter(shape, rbacBuilder).build());
        schemaBuilder.additionalType((GraphQLType)this.createMutliFilter(shape, rbacBuilder).build());
        this.buildTemplateArgumentTypes(shape, schemaBuilder);
    }

    private GraphQLType buildUnionType(Shape singleShape, SomlSchema somlSchema, GraphQlRbac rbacBuilder) {
        GraphQLUnionType.Builder classBuilder = GraphQLUnionType.newUnionType().name(singleShape.asGraphQl()).description(singleShape.getLabel());
        if (this.areSomlDirectivesEnabled(somlSchema) && !singleShape.isSystem()) {
            classBuilder.withAppliedDirective(DirectivesBuilder.createSomlPropertyDirectiveForType(singleShape));
        }
        if (null != singleShape.getDescr()) {
            classBuilder.withDirective(DirectivesBuilder.createDescriptionDirectiveBuilder(singleShape.getDescr()));
        }
        for (Shape shape : singleShape.getUnionOfShapes()) {
            classBuilder.possibleType(new GraphQLTypeReference(shape.asGraphQl()));
        }
        classBuilder.typeResolver(env -> {
            GraphQLObjectType object = (GraphQLObjectType)env.getObject();
            return (GraphQLObjectType)env.getSchema().getType(object.getName());
        });
        rbacBuilder.addTypeLevelRoles(arg_0 -> ((GraphQLUnionType.Builder)classBuilder).withDirective(arg_0), singleShape);
        this.addMetadataDirective(singleShape, arg_0 -> ((GraphQLUnionType.Builder)classBuilder).withDirective(arg_0));
        return classBuilder.build();
    }

    private void buildTemplateArgumentTypes(Shape shape, GraphQLSchema.Builder schemaBuilder) {
        ScalarTypes types = shape.getContainedIn().getContainedIn().getTypes();
        if (shape.isAbstract()) {
            shape.getProps().values().stream().map(PropertyShape::getSparqlTemplate).filter(Objects::nonNull).filter(template -> template.getParentTemplate() == null).map(Template::getRootTemplate).distinct().filter(template -> template.streamTemplates().anyMatch(Template::hasArgs)).forEach(this.buildRootTemplateArgumentType(schemaBuilder, types));
        } else if (shape.getInherits() == null) {
            shape.getProps().values().stream().map(PropertyShape::getSparqlTemplate).filter(Objects::nonNull).distinct().filter(Template::hasArgs).forEach(this.buildTemplateArgumentType(schemaBuilder, types));
        } else {
            shape.getProps().values().stream().map(PropertyShape::getSparqlTemplate).filter(Objects::nonNull).filter(template -> template.getParentTemplate() == null).distinct().filter(Template::hasArgs).forEach(this.buildTemplateArgumentType(schemaBuilder, types));
        }
    }

    private Consumer<Template> buildRootTemplateArgumentType(GraphQLSchema.Builder schemaBuilder, ScalarTypes types) {
        return template -> {
            Map allKeys = template.streamTemplates().map(Template::getKeys).reduce(new LinkedHashMap(), (current, newEntry) -> {
                current.putAll(newEntry);
                return current;
            });
            this.buildTemplateArgumentType(schemaBuilder, types, (Template)template, allKeys, (Deque<String>)new LinkedList<String>());
        };
    }

    private Consumer<Template> buildTemplateArgumentType(GraphQLSchema.Builder schemaBuilder, ScalarTypes types) {
        return template -> this.buildTemplateArgumentType(schemaBuilder, types, (Template)template, template.getKeys(), (Deque<String>)new LinkedList<String>());
    }

    private void buildTemplateArgumentType(GraphQLSchema.Builder schemaBuilder, ScalarTypes types, Template template, Map<String, TemplateArgs> templateKeys, Deque<String> keyPath) {
        String templateName = GraphQlTypeBuilder.buildTemplateName(template, keyPath.toArray(new String[0]));
        GraphQLInputObjectType.Builder inputBuilder = GraphQLInputObjectType.newInputObject().name(templateName);
        for (Map.Entry<String, TemplateArgs> entry : templateKeys.entrySet()) {
            String key = entry.getKey();
            TemplateArgs mapping = entry.getValue();
            if (mapping.isEmpty()) {
                GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(key).type(GraphQlTypeBuilder.getTemplateArgumentInputType(types, mapping, null, mapping.isOptional()));
                if (mapping.getDefaultValue() != null) {
                    builder.defaultValueProgrammatic((Object)mapping.getDefaultValue());
                }
                inputBuilder.field(builder);
                continue;
            }
            keyPath.add(key);
            String referenceName = GraphQlTypeBuilder.buildTemplateName(template, keyPath.toArray(new String[0]));
            GraphQLInputType type = GraphQlTypeBuilder.getTemplateArgumentInputType(types, mapping, referenceName, mapping.isOptional());
            inputBuilder.field(GraphQLInputObjectField.newInputObjectField().name(key).type(type));
            this.buildTemplateArgumentType(schemaBuilder, types, template, mapping.getArgsMap(), keyPath);
            keyPath.removeFirst();
        }
        schemaBuilder.additionalType((GraphQLType)inputBuilder.build());
    }

    private static GraphQLInputType getTemplateArgumentInputType(ScalarTypes types, TemplateArgs mapping, String name, boolean isOptional) {
        boolean isCollection = mapping.isCollection();
        String targetType = name;
        if (targetType == null) {
            if ("condition".equals(mapping.getType())) {
                return Scalars.GraphQLBoolean;
            }
            ScalarType scalarType = (ScalarType)types.get((Object)mapping.getType());
            if (scalarType == null) {
                scalarType = (ScalarType)types.get((Object)"string");
            }
            targetType = scalarType.getGraphql();
        }
        return (GraphQLInputType)GraphQlPropertyTypeCalculator.computeInputGraphQlType(targetType, !isOptional, isCollection, !isOptional);
    }

    private GraphQLInputObjectType.Builder createOrderByInput(Shape shape) {
        String escapedObjectName = shape.asGraphQl();
        String orderingName = escapedObjectName + ORDER_FIELDS_SUFFIX;
        GraphQLInputObjectType.Builder orderByInput = GraphQLInputObjectType.newInputObject().name(orderingName).description(escapedObjectName + " ordering fields").field(GraphQLInputObjectField.newInputObjectField().name("_typename").type((GraphQLInputType)SCALAR_ORDER_BY));
        this.buildOrderByInputs(shape, orderByInput);
        return orderByInput;
    }

    private GraphQLInputObjectType.Builder createSingleFilter(Shape shape, GraphQlRbac rbacBuilder) throws SomlClassShapeInvalidReferenceException {
        GraphQLInputObjectType.Builder filterBuilder = this.createBaseFilterInput(shape, rbacBuilder);
        shape.getConcreteSubTypes().stream().filter(subType -> subType.isSynthetic() == false && !subType.isUnion()).filter(subType -> !GraphQlTypeUtil.getBaseTypes().contains(subType.getId())).map(subType -> this.createTypeField((Shape)subType, false, rbacBuilder)).forEach(arg_0 -> ((GraphQLInputObjectType.Builder)filterBuilder).field(arg_0));
        return filterBuilder;
    }

    private GraphQLInputObjectType.Builder createMutliFilter(Shape shape, GraphQlRbac rbacEnabled) throws SomlClassShapeInvalidReferenceException {
        GraphQLInputObjectType.Builder filterBuilder = this.createBaseFilterInput(shape, rbacEnabled);
        String objectName = shape.asGraphQl();
        String description = objectName + " comparisons for multi-value fields";
        String filterName = objectName + "_Where_Multi";
        filterBuilder.name(filterName).description(description);
        for (Map.Entry<String, String> entry : FilterMap.getObjectAllFiltersMap().entrySet()) {
            this.generateTypeFilteringIoFieldBuilder(objectName, filterName, filterBuilder, entry, null);
        }
        for (Map.Entry<String, String> entry : FilterMap.getObjectNotFilterMap().entrySet()) {
            this.generateTypeFilteringIoFieldBuilder(objectName, filterName, filterBuilder, entry, null);
        }
        for (Map.Entry<String, String> entry : FilterMap.getCommonFiltersMap().entrySet()) {
            this.generateTypeFilteringIoFieldBuilder(objectName, filterName, filterBuilder, entry, null);
        }
        shape.getConcreteSubTypes().stream().filter(subType -> subType.isSynthetic() == false && !subType.isUnion()).filter(subType -> !GraphQlTypeUtil.getBaseTypes().contains(subType.getId())).map(subType -> this.createTypeField((Shape)subType, true, rbacEnabled)).forEach(arg_0 -> ((GraphQLInputObjectType.Builder)filterBuilder).field(arg_0));
        return filterBuilder;
    }

    private GraphQLInputObjectType.Builder createBaseFilterInput(Shape shape, GraphQlRbac rbacBuilder) throws SomlClassShapeInvalidReferenceException {
        String escapedObjectName = shape.asGraphQl();
        String filterName = escapedObjectName + FILTER_OBJECTS_SUFFIX;
        String description = escapedObjectName + " comparisons for single-value fields";
        GraphQLInputObjectType.Builder filteringBuilder = GraphQLInputObjectType.newInputObject().name(filterName).description(description);
        for (Map.Entry<String, String> entry : FilterMap.getObjectSingleFieldMap().entrySet()) {
            this.generateTypeFilteringIoFieldBuilder(escapedObjectName, filterName, filteringBuilder, entry, null);
        }
        this.buildPropertyFilterInputs(shape, filteringBuilder, rbacBuilder);
        Consumer<GraphQLInputObjectField.Builder> typeReadBuilder = rbacBuilder.createTypeReadBuilder(shape.getId());
        for (Map.Entry<String, String> entry : FilterMap.getIdFilterMap().entrySet()) {
            this.generateTypeFilteringIoFieldBuilder(escapedObjectName, ID_NAME, filteringBuilder, entry, typeReadBuilder);
        }
        return filteringBuilder;
    }

    private GraphQLInputObjectField.Builder createTypeField(Shape childShape, boolean isMulti, GraphQlRbac rbacBuilder) {
        String filterSuffix = isMulti ? FILTER_MULTI_SUFFIX : "";
        String normalizedChildId = childShape.asGraphQl();
        String referenceName = normalizedChildId + FILTER_OBJECTS_SUFFIX + filterSuffix;
        GraphQLInputObjectField.Builder newField = GraphQLInputObjectField.newInputObjectField().name("_if" + normalizedChildId).type((GraphQLInputType)new GraphQLTypeReference(referenceName));
        rbacBuilder.addEditRoles(arg_0 -> ((GraphQLInputObjectField.Builder)newField).withDirective(arg_0), childShape);
        return newField;
    }

    private void generateTypeFilteringIoFieldBuilder(String objectName, String filterName, GraphQLInputObjectType.Builder filteringIoBuilder, Map.Entry<String, String> entry, Consumer<GraphQLInputObjectField.Builder> onNewTypeProperty) {
        GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField();
        Object inputType = FilterMap.getCommonFiltersMap().containsKey(entry.getKey()) || FilterMap.getIdFilterMap().containsKey(entry.getKey()) ? GraphQlTypeUtil.newNonNullListReferenceType(filterName) : new GraphQLTypeReference(filterName);
        fieldBuilder.name(entry.getKey()).description(String.format(entry.getValue(), objectName)).type((GraphQLInputType)inputType);
        if (onNewTypeProperty != null) {
            onNewTypeProperty.accept(fieldBuilder);
        }
        filteringIoBuilder.field(fieldBuilder);
    }

    private GraphQLType buildInterfaceType(Shape singleShape, SomlSchema somlSchema, GraphQlRbac rbacBuilder) throws SomlClassShapeInvalidReferenceException {
        String classKey = singleShape.getId();
        GraphQLInterfaceType.Builder classBuilder = GraphQLInterfaceType.newInterface().name(singleShape.asGraphQl()).description(singleShape.getLabel());
        if (null != singleShape.getDescr()) {
            classBuilder.withDirective(DirectivesBuilder.createDescriptionDirectiveBuilder(singleShape.getDescr()));
        }
        if (this.areSomlDirectivesEnabled(somlSchema) && !singleShape.isSystem()) {
            classBuilder.withAppliedDirective(DirectivesBuilder.createSomlPropertyDirectiveForType(singleShape));
        }
        ArrayList shapeHierarchy = new ArrayList(somlSchema.getObjects().getHierarchy(classKey));
        for (Shape shape : shapeHierarchy) {
            if (!this.options.isFederationEnabled() && !shape.getId().equals(classKey)) {
                GraphQLTypeReference reference = new GraphQLTypeReference(shape.asGraphQl());
                classBuilder.withInterface(reference);
            }
            this.processShapeProperties(singleShape, somlSchema, rbacBuilder, classKey, arg_0 -> ((GraphQLInterfaceType.Builder)classBuilder).field(arg_0), shape);
        }
        TypeResolver interfaceResolver = env -> {
            GraphQLObjectType object = (GraphQLObjectType)env.getObject();
            return (GraphQLObjectType)env.getSchema().getType(object.getName());
        };
        classBuilder.typeResolver(interfaceResolver);
        rbacBuilder.addTypeLevelRoles(arg_0 -> ((GraphQLInterfaceType.Builder)classBuilder).withDirective(arg_0), singleShape);
        this.addMetadataDirective(singleShape, arg_0 -> ((GraphQLInterfaceType.Builder)classBuilder).withDirective(arg_0));
        this.onInterfaceTypeCreate.forEach(cons -> cons.accept(classBuilder, singleShape));
        return classBuilder.build();
    }

    private boolean areSomlDirectivesEnabled(SomlSchema somlSchema) {
        return somlSchema.getConfig().isExposeSomlInGraphQl().filter(Boolean::booleanValue).isPresent();
    }

    private void addMetadataDirective(Shape singleShape, Consumer<GraphQLDirective> directiveConsumer) {
        if (!singleShape.getMeta().isEmpty()) {
            directiveConsumer.accept(DirectivesBuilder.createMetaDirective(singleShape.getMeta()));
        }
    }

    private void addSomlDirectives(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder) {
        if (this.areSomlDirectivesEnabled(somlSchema)) {
            schemaBuilder.additionalDirective(DirectivesBuilder.createSomlTypeDirective().build());
            schemaBuilder.additionalDirective(DirectivesBuilder.createSomlPropertyDirective().build());
            schemaBuilder.additionalType((GraphQLType)DirectivesBuilder.createPrefixInput().build());
            schemaBuilder.additionalDirective(DirectivesBuilder.createPrefixesDirective().build());
            schemaBuilder.additionalType((GraphQLType)DirectivesBuilder.createConfigInput().build());
            schemaBuilder.additionalDirective(DirectivesBuilder.createConfigDirective().build());
            schemaBuilder.additionalDirective(DirectivesBuilder.createSomlInfoDirective().build());
            schemaBuilder.additionalType((GraphQLType)DirectivesBuilder.createRbacRoleInput().build());
            schemaBuilder.additionalType((GraphQLType)DirectivesBuilder.createRbacRoleActionInput().build());
            schemaBuilder.additionalDirective(DirectivesBuilder.createRbacDirective().build());
            schemaBuilder.withSchemaAppliedDirective(DirectivesBuilder.createSomlInfoDirective(somlSchema));
            schemaBuilder.withSchemaAppliedDirective(DirectivesBuilder.createPrefixesDirective(somlSchema));
            schemaBuilder.withSchemaAppliedDirective(DirectivesBuilder.createConfigDirective(somlSchema));
            schemaBuilder.withSchemaAppliedDirective(DirectivesBuilder.createRbacDirective(somlSchema));
        }
    }

    private PropertyShape resolveUsingAll(Shape shape, PropertyShape property) {
        PropertyShape propertyShape = (PropertyShape)shape.getAllProperties().get((Object)property.getName());
        if (propertyShape == null) {
            throw new InvalidSchemaException("Could not resolve property" + property.getName() + " in " + shape.getId());
        }
        return propertyShape;
    }

    private void buildOrderByInputs(Shape singleShape, GraphQLInputObjectType.Builder orderTypeBuilder) {
        String classKey = singleShape.getId();
        Shapes types = singleShape.getContainedIn();
        ArrayList shapeHierarchy = new ArrayList(types.getHierarchy(classKey));
        for (Shape shape : shapeHierarchy) {
            for (PropertyShape propertyShape : shape.getProps().values()) {
                if (propertyShape.getSparqlTemplate() != null && propertyShape.getSparqlTemplate().hasArgs() || !propertyShape.isAllowedForOrdering()) continue;
                PropertyShape resolved = this.resolveUsingAll(singleShape, propertyShape);
                this.buildOrderingIo(orderTypeBuilder, resolved, shape.getName());
            }
        }
        Collection referencedTypes = singleShape.isUnion() ? singleShape.getUnionOfShapes() : singleShape.getSubTypes();
        for (Shape shape : referencedTypes) {
            if (shape.isSystem() || shape.isIgnoredType()) continue;
            String normalizedChildId = shape.asGraphQl();
            String referenceName = normalizedChildId + ORDER_FIELDS_SUFFIX;
            orderTypeBuilder.field(GraphQLInputObjectField.newInputObjectField().name("_if" + normalizedChildId).type((GraphQLInputType)new GraphQLTypeReference(referenceName)).build());
        }
    }

    private void buildPropertyFilterInputs(Shape singleShape, GraphQLInputObjectType.Builder filterBuilder, GraphQlRbac rbacBuilder) throws SomlClassShapeInvalidReferenceException {
        String classKey = singleShape.getId();
        SomlSchema somlSchema = singleShape.getContainedIn().getContainedIn();
        ArrayList shapeHierarchy = new ArrayList(somlSchema.getObjects().getHierarchy(classKey));
        for (Shape shape : shapeHierarchy) {
            for (PropertyShape propertyShape : shape.getProps().values()) {
                PropertyShape resolved = this.resolveUsingAll(singleShape, propertyShape);
                if (propertyShape.getSparqlTemplate() != null && propertyShape.getSparqlTemplate().hasArgs() || !propertyShape.isAllowedForFiltering()) continue;
                Consumer<GraphQLInputObjectField.Builder> propertyReadBuilder = rbacBuilder.createPropertyReadBuilder(singleShape.getId(), resolved.getName());
                GraphQLFieldDefinition newField = this.generateShapeProperty(somlSchema, resolved, classKey, null, rbacBuilder);
                this.buildFilteringIo(filterBuilder, newField, propertyReadBuilder, shape);
            }
        }
    }

    private GraphQLType buildObjectType(Shape singleShape, SomlSchema somlSchema, GraphQlRbac rbacBuilder) throws SomlClassShapeInvalidReferenceException {
        String classKey = singleShape.getId();
        GraphQLObjectType.Builder classBuilder = GraphQLObjectType.newObject().name(singleShape.asGraphQl()).description(singleShape.getLabel());
        if (this.areSomlDirectivesEnabled(somlSchema) && !singleShape.isSystem()) {
            classBuilder.withAppliedDirective(DirectivesBuilder.createSomlPropertyDirectiveForType(singleShape));
        }
        if (null != singleShape.getDescr()) {
            classBuilder.withDirective(DirectivesBuilder.createDescriptionDirectiveBuilder(singleShape.getDescr()));
        }
        ArrayList shapeHierarchy = new ArrayList(somlSchema.getObjects().getHierarchy(classKey));
        for (Shape shape : shapeHierarchy) {
            if (!shape.getId().equals(classKey)) {
                classBuilder.withInterface(new GraphQLTypeReference(shape.asGraphQl()));
            }
            this.processShapeProperties(singleShape, somlSchema, rbacBuilder, classKey, arg_0 -> ((GraphQLObjectType.Builder)classBuilder).field(arg_0), shape);
        }
        rbacBuilder.addTypeLevelRoles(arg_0 -> ((GraphQLObjectType.Builder)classBuilder).withDirective(arg_0), singleShape);
        this.addMetadataDirective(singleShape, arg_0 -> ((GraphQLObjectType.Builder)classBuilder).withDirective(arg_0));
        this.onObjectTypeCreate.forEach(cons -> cons.accept(classBuilder, singleShape));
        return classBuilder.build();
    }

    private void processShapeProperties(Shape singleShape, SomlSchema somlSchema, GraphQlRbac rbacBuilder, String classKey, Consumer<GraphQLFieldDefinition> classBuilder, Shape shape) throws SomlClassShapeInvalidReferenceException {
        for (PropertyShape propertyShape : shape.getProps().values()) {
            PropertyShape resolved = this.resolveUsingAll(singleShape, propertyShape);
            GraphQLFieldDefinition newField = this.generateShapeProperty(somlSchema, resolved, classKey, singleShape.getName(), rbacBuilder);
            classBuilder.accept(newField);
        }
    }

    private void buildFilteringIo(GraphQLInputObjectType.Builder filterBuilder, GraphQLFieldDefinition newField, Consumer<GraphQLInputObjectField.Builder> onNewProperty, Shape shape) {
        GraphQLOutputType typeInstance = newField.getType();
        Object typeName = this.getNameOrNull((GraphQLType)typeInstance);
        boolean hasList = false;
        while (null == typeName) {
            if (typeInstance instanceof GraphQLList) {
                hasList = true;
            }
            typeInstance = GraphQLTypeUtil.unwrapOne((GraphQLType)typeInstance);
            typeName = this.getNameOrNull((GraphQLType)typeInstance);
        }
        if (!"Literal".equals(shape.getId()) || !newField.getName().equals("lang")) {
            typeName = (String)typeName + FILTER_OBJECTS_SUFFIX;
            if (hasList) {
                typeName = (String)typeName + FILTER_MULTI_SUFFIX;
            }
        }
        GraphQLInputObjectField.Builder inputBuilder = GraphQLInputObjectField.newInputObjectField().name(newField.getName()).description(String.format("%s comparisons", newField.getName())).type((GraphQLInputType)new GraphQLTypeReference((String)typeName));
        onNewProperty.accept(inputBuilder);
        filterBuilder.field(inputBuilder.build());
    }

    private String getNameOrNull(GraphQLType typeInstance) {
        return typeInstance instanceof GraphQLNamedType ? ((GraphQLNamedType)typeInstance).getName() : null;
    }

    private void buildOrderingIo(GraphQLInputObjectType.Builder ioBuilder, PropertyShape propertyShape, String rootNameReference) {
        String fieldName = propertyShape.asGraphQl();
        if (!propertyShape.isMultivalued() && !fieldName.equals(StringManipulation.toGraphQlModelName((String)rootNameReference)) || propertyShape.isScalarType() && propertyShape.getScalarType().isLangStringSupported()) {
            String orderReference = "";
            if (!propertyShape.isScalarType()) {
                orderReference = propertyShape.getRangeShape().asGraphQl();
            } else if (propertyShape.getScalarType().isLangStringSupported() && propertyShape.isMultivalued()) {
                orderReference = LANG_STRING;
            }
            ioBuilder.field(GraphQLInputObjectField.newInputObjectField().name(fieldName).type((GraphQLInputType)new GraphQLTypeReference(String.format("%s%s", orderReference, ORDER_FIELDS_SUFFIX))).build());
        }
    }

    private GraphQLFieldDefinition generateShapeProperty(SomlSchema somlSchema, PropertyShape propertyShape, String shapeName, String nameAlias, GraphQlRbac rbacBuilder) throws SomlClassShapeInvalidReferenceException {
        String typeRaw = propertyShape.isScalarType() ? propertyShape.getScalarType().getGraphql() : propertyShape.getRangeShape().asGraphQl();
        GraphQLOutputType type = this.calculateType(typeRaw, propertyShape, shapeName);
        this.checkReferenceValidity(somlSchema, shapeName, (GraphQLType)type);
        GraphQLFieldDefinition.Builder fieldDefinitionBuilder = this.createFieldDefinitionBuilder(propertyShape, type, typeRaw, somlSchema);
        rbacBuilder.addAllPropertyRoles(shapeName, propertyShape.getName(), fieldDefinitionBuilder);
        if (propertyShape.getName().equals(nameAlias)) {
            fieldDefinitionBuilder.withDirective(DirectivesBuilder.createNameAliasDirective(false));
        }
        fieldDefinitionBuilder.withAppliedDirective(DirectivesBuilder.createConstraintsDirective(propertyShape));
        if (!propertyShape.getMeta().isEmpty()) {
            fieldDefinitionBuilder.withDirective(DirectivesBuilder.createMetaDirective(propertyShape.getMeta()));
        }
        this.onFieldCreate.forEach(consumer -> consumer.accept(fieldDefinitionBuilder, Pair.of((Object)propertyShape, (Object)shapeName)));
        return fieldDefinitionBuilder.build();
    }

    private GraphQLOutputType calculateType(String type, PropertyShape property, String shapeName) {
        boolean isNonNullable = property.isNonNullable() != false || Shapes.AFFECTED_TYPES.contains(shapeName);
        return GraphQlPropertyTypeCalculator.computeOutputGraphQlType(type, isNonNullable, property.isMultivalued(), property.isNonNullableElements());
    }

    private GraphQLFieldDefinition.Builder createFieldDefinitionBuilder(PropertyShape propertyShape, GraphQLOutputType fieldType, String rawObjType, SomlSchema somlSchema) {
        String label = propertyShape.getLabel();
        String fieldName = propertyShape.asGraphQl();
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name(fieldName).description(label).type(fieldType);
        if (this.areSomlDirectivesEnabled(somlSchema) && !propertyShape.getContainedIn().getContainedIn().isSystem()) {
            builder.withAppliedDirective(DirectivesBuilder.createSomlPropertyDirectiveForProperty(propertyShape));
        }
        if (propertyShape.getDescr() != null) {
            builder.withDirective(DirectivesBuilder.createDescriptionDirectiveBuilder(propertyShape.getDescr()));
        }
        GraphQlTypeBuilder.addLiteralFilters(propertyShape, builder);
        this.addNameableArguments(propertyShape, builder);
        this.addTemplateArguments(propertyShape, builder);
        if (fieldType instanceof GraphQLNonNull) {
            fieldType = (GraphQLOutputType)((GraphQLNonNull)fieldType).getWrappedType();
        }
        if (fieldType instanceof GraphQLList) {
            this.createMultiValuedFieldDefinitionBuilder(propertyShape, fieldType, rawObjType, builder);
        } else if (propertyShape.isCountProperty() && this.isCollectionCountingEnabled(somlSchema)) {
            this.addCountFilter(propertyShape, builder);
            propertyShape.resolveCountedProperty().ifPresent(counted -> this.addTemplateArguments((PropertyShape)counted, builder));
        }
        return builder;
    }

    private boolean isCollectionCountingEnabled(SomlSchema somlSchema) {
        return somlSchema.getConfig().isCollectionCountingEnabled().filter(Predicate.isEqual(Boolean.TRUE)).isPresent();
    }

    private void addCountFilter(PropertyShape propertyShape, GraphQLFieldDefinition.Builder builder) {
        Optional countedProperty = propertyShape.resolveCountedProperty();
        if (countedProperty.isEmpty()) {
            return;
        }
        PropertyShape referenceProp = (PropertyShape)countedProperty.get();
        String typeRaw = referenceProp.isScalarType() ? referenceProp.getScalarType().getGraphql() : referenceProp.getRangeShape().asGraphQl();
        String filteringReferenceName = Boolean.TRUE.equals(referenceProp.hasCovariant()) && !referenceProp.isScalarType() ? referenceProp.getContainedIn().getContainedIn().getInheritsAsList().stream().findFirst().orElse(typeRaw) : typeRaw;
        builder.argument(GraphQlFieldArgumentBuilder.where(filteringReferenceName));
    }

    private void addTemplateArguments(PropertyShape propertyShape, GraphQLFieldDefinition.Builder builder) {
        if (propertyShape.getSparqlTemplate() != null && propertyShape.getSparqlTemplate().getRootTemplate().streamTemplates().anyMatch(Template::hasArgs)) {
            ScalarTypes types = propertyShape.getContainedIn().getContainedIn().getContainedIn().getContainedIn().getTypes();
            GraphQLArgument.Builder argsBuilder = GraphQlTypeBuilder.buildTemplateArgument(propertyShape.getSparqlTemplate().getRootTemplate(), types);
            builder.argument(argsBuilder);
        }
    }

    private static GraphQLArgument.Builder buildTemplateArgument(Template sparqlTemplate, ScalarTypes types) {
        String name = GraphQlTypeBuilder.buildTemplateName(sparqlTemplate, new String[0]);
        return GraphQlTypeUtil.newArgument("args", GraphQlTypeBuilder.getTemplateArgumentInputType(types, TemplateArgs.ARGS, name, sparqlTemplate.optionalArgs()));
    }

    private static String buildTemplateName(Template sparqlTemplate, String ... path) {
        return sparqlTemplate.getRootTemplate().getName().replace('.', '_') + Arrays.stream(path).collect(Collectors.joining("_", "_", "")) + "_Template_Input";
    }

    private void addNameableArguments(PropertyShape propertyShape, GraphQLFieldDefinition.Builder builder) {
        if ("name".equals(propertyShape.getName())) {
            Shape containedIn = propertyShape.getContainedIn().getContainedIn();
            Optional<String> defaultNamePattern = containedIn.getContainedIn().getContainedIn().getConfig().getLang().map(SchemaLangConfig::getDefaultNameFetch);
            GraphQLArgument.Builder argument = GraphQlTypeUtil.newArgument("lang", (GraphQLInputType)Scalars.GraphQLString);
            defaultNamePattern.ifPresent(arg_0 -> ((GraphQLArgument.Builder)argument).defaultValue(arg_0));
            builder.argument(argument);
            if (containedIn.getNameTemplate() != null && containedIn.getNameTemplate().hasArgs()) {
                ScalarTypes types = containedIn.getContainedIn().getContainedIn().getTypes();
                builder.argument(GraphQlTypeBuilder.buildTemplateArgument(containedIn.getNameTemplate(), types));
            }
        }
    }

    private void createMultiValuedFieldDefinitionBuilder(PropertyShape propertyShape, GraphQLOutputType fieldType, String rawObjType, GraphQLFieldDefinition.Builder builder) {
        String orderingReferenceName = "";
        Boolean useParent = propertyShape.hasCovariant();
        GraphQLNamedType rootType = GraphQlTypeUtil.extractRootType((GraphQLType)fieldType);
        String parentName = null;
        if (Boolean.TRUE.equals(useParent)) {
            parentName = propertyShape.getContainedIn().getContainedIn().getSuperTypes().flatMap(parent -> parent.getProperty(propertyShape.getName()).filter(PropertyShape::isObjectType).filter(prop -> !Objects.equals(prop.getRange(), rawObjType)).map(PropertyShape::getRange).stream()).findFirst().orElse(rawObjType);
        }
        if (rootType instanceof GraphQLTypeReference) {
            orderingReferenceName = Boolean.TRUE.equals(useParent) && !propertyShape.isScalarType() ? parentName : rawObjType;
        }
        String filteringReferenceName = Boolean.TRUE.equals(useParent) && !propertyShape.isScalarType() ? parentName : rootType.getName();
        if (!(rootType instanceof GraphQLScalarType && !rootType.getName().equals(Scalars.GraphQLID.getName()) || rootType.getName().equals("Literal"))) {
            builder.argument(GraphQlFieldArgumentBuilder.id());
        }
        builder.argument(this.getOrder(propertyShape, orderingReferenceName)).argument(GraphQlFieldArgumentBuilder.limit()).argument(GraphQlFieldArgumentBuilder.offset());
        if (!propertyShape.isLiteral()) {
            builder.argument(GraphQlFieldArgumentBuilder.where(filteringReferenceName));
        }
    }

    private GraphQLArgument.Builder getOrder(PropertyShape property, String orderingReference) {
        if (property.isScalarType() && (property.getScalarType().isLangStringSupported() || property.getScalarType().isEnum())) {
            return GraphQlFieldArgumentBuilder.order((GraphQLInputType)SCALAR_ORDER_BY);
        }
        return GraphQlFieldArgumentBuilder.order(orderingReference);
    }

    private static void addLiteralFilters(PropertyShape propertyShape, GraphQLFieldDefinition.Builder builder) {
        if (propertyShape.isLiteral() && propertyShape.getScalarType().isLangStringSupported()) {
            GraphQLTypeReference stringWhere = new GraphQLTypeReference("String_Where");
            builder.argument(GraphQlTypeUtil.newArgument("value", (GraphQLInputType)stringWhere)).argument(GraphQlTypeUtil.newArgument("lang", (GraphQLInputType)Scalars.GraphQLString));
        }
        if (!propertyShape.isScalarType()) {
            builder.argument(GraphQlTypeUtil.newArgument("lang", (GraphQLInputType)Scalars.GraphQLString));
        }
    }

    private void checkReferenceValidity(SomlSchema somlSchema, String refererName, GraphQLType type) throws SomlClassShapeInvalidReferenceException {
        if (type instanceof GraphQLTypeReference && this.isNotShape(somlSchema, (GraphQLTypeReference)type) && this.isNotEnum(somlSchema, (GraphQLTypeReference)type)) {
            String typeName = ((GraphQLTypeReference)type).getName();
            throw new SomlClassShapeInvalidReferenceException(String.format("The object %s refers to the class %s which is not defined within the schema.", refererName, typeName), refererName, typeName);
        }
    }

    private boolean isNotEnum(SomlSchema somlSchema, GraphQLTypeReference type) {
        return somlSchema.getTypes().values().stream().filter(ScalarType::isEnum).map(ScalarType::getGraphql).noneMatch(Predicate.isEqual(type.getName()));
    }

    private boolean isNotShape(SomlSchema somlSchema, GraphQLTypeReference type) {
        Prefixes prefixes = somlSchema.getPrefixes();
        return !somlSchema.getObjects().containsKey((Object)prefixes.nameToShortIri(type.getName()));
    }
}

