/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.platform.GraphQlTypeUtil;
import com.ontotext.platform.extended.scalars.NumericScalars;
import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;

public class GraphQlFieldArgumentBuilder {
    private static final String ID_NAME = "ID";
    private static final String WHERE = "where";
    private static final String FILTER_OBJECTS_SUFFIX = "_Where";
    private static final String FILTER_MULTI_SUFFIX = "_Multi";
    private static final String ORDER_FIELDS_SUFFIX = "_OrderBy";
    private static final String ORDER_BY = "orderBy";
    private static final String LIMIT = "limit";
    private static final String OFFSET = "offset";
    public static final String MIN_COUNT = "minCount";
    public static final String MAX_COUNT = "maxCount";
    public static final String MAX_LENGTH_FIELD = "maxLength";
    public static final String MIN_LENGTH_FIELD = "minLength";
    public static final String MAX_INCLUSIVE_FIELD = "maxInclusive";
    public static final String MIN_INCLUSIVE_FIELD = "minInclusive";
    public static final String MAX_EXCLUSIVE_FIELD = "maxExclusive";
    public static final String MIN_EXCLUSIVE_FIELD = "minExclusive";
    public static final String VALUES_IN = "valuesIn";
    public static final String VALUES_LIST_EXCLUSIVE = "valuesListExclusive";
    public static final String ERROR_FORMAT = "errorsFormat";
    public static final String ERROR_FORMAT_TYPE = "ErrorsResponseFormat";
    private static final String META_VALUE = "_";

    private GraphQlFieldArgumentBuilder() {
    }

    public static GraphQLArgument.Builder id() {
        return GraphQlTypeUtil.newArgument(ID_NAME, (GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLID));
    }

    public static GraphQLArgument.Builder where(String typeName) {
        String filterName = typeName + "_Where_Multi";
        GraphQLTypeReference filterType = new GraphQLTypeReference(filterName);
        return GraphQlTypeUtil.newArgument(WHERE, (GraphQLInputType)filterType);
    }

    public static GraphQLArgument.Builder order(String typeName) {
        String orderName = typeName + ORDER_FIELDS_SUFFIX;
        GraphQLTypeReference orderType = new GraphQLTypeReference(orderName);
        return GraphQlFieldArgumentBuilder.order((GraphQLInputType)orderType);
    }

    public static GraphQLArgument.Builder order(GraphQLInputType orderType) {
        return GraphQlTypeUtil.newArgument(ORDER_BY, orderType);
    }

    public static GraphQLArgument.Builder limit() {
        return GraphQlTypeUtil.newArgument(LIMIT, (GraphQLInputType)NumericScalars.POSITIVE_INTEGER);
    }

    public static GraphQLArgument.Builder offset() {
        return GraphQlTypeUtil.newArgument(OFFSET, (GraphQLInputType)NumericScalars.NON_NEGATIVE_INTEGER);
    }

    public static GraphQLArgument.Builder lang() {
        return GraphQlTypeUtil.newArgument("lang", (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder includeInferred() {
        return GraphQlTypeUtil.newArgument("includeInferred", (GraphQLInputType)Scalars.GraphQLBoolean).description("Include inferred data in results");
    }

    public static GraphQLArgument.Builder expandOverSameAs() {
        return GraphQlTypeUtil.newArgument("expandOwlSameAs", (GraphQLInputType)Scalars.GraphQLBoolean).description("Expand results over owl:sameAs");
    }

    public static GraphQLArgument.Builder repository() {
        return GraphQlTypeUtil.newArgument("repository", (GraphQLInputType)Scalars.GraphQLString).description("Overrides the default repository");
    }

    public static GraphQLArgument.Builder from() {
        return GraphQlTypeUtil.newArgument("from", (GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLString));
    }

    public static GraphQLArgument.Builder fromNamed() {
        return GraphQlTypeUtil.newArgument("fromNamed", (GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLString));
    }

    public static GraphQLArgument.Builder using() {
        return GraphQlTypeUtil.newArgument("using", (GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLString));
    }

    public static GraphQLArgument.Builder usingNamed() {
        return GraphQlTypeUtil.newArgument("usingNamed", (GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLString));
    }

    public static GraphQLArgument.Builder with() {
        return GraphQlTypeUtil.newArgument("with", (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder minCount() {
        return GraphQlTypeUtil.newArgument(MIN_COUNT, (GraphQLInputType)Scalars.GraphQLInt);
    }

    public static GraphQLArgument.Builder maxCount() {
        return GraphQlTypeUtil.newArgument(MAX_COUNT, (GraphQLInputType)Scalars.GraphQLInt);
    }

    public static GraphQLArgument.Builder maxLength() {
        return GraphQlTypeUtil.newArgument(MAX_LENGTH_FIELD, (GraphQLInputType)Scalars.GraphQLInt);
    }

    public static GraphQLArgument.Builder minLength() {
        return GraphQlTypeUtil.newArgument(MIN_LENGTH_FIELD, (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder maxInclusive() {
        return GraphQlTypeUtil.newArgument(MAX_INCLUSIVE_FIELD, (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder minInclusive() {
        return GraphQlTypeUtil.newArgument(MIN_INCLUSIVE_FIELD, (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder maxExclusive() {
        return GraphQlTypeUtil.newArgument(MAX_EXCLUSIVE_FIELD, (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder minExclusive() {
        return GraphQlTypeUtil.newArgument(MIN_EXCLUSIVE_FIELD, (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder valuesIn() {
        return GraphQlTypeUtil.newArgument(VALUES_IN, (GraphQLInputType)Scalars.GraphQLString);
    }

    public static GraphQLArgument.Builder errorsFormat() {
        return GraphQlTypeUtil.newArgument(ERROR_FORMAT, (GraphQLInputType)new GraphQLTypeReference(ERROR_FORMAT_TYPE)).defaultValueProgrammatic((Object)"DEFAULT");
    }

    public static GraphQLArgument.Builder valuesListExclusive() {
        return GraphQlTypeUtil.newArgument(VALUES_LIST_EXCLUSIVE, (GraphQLInputType)Scalars.GraphQLBoolean);
    }

    public static GraphQLArgument.Builder metaValue() {
        return GraphQlTypeUtil.newArgument(META_VALUE, (GraphQLInputType)ExtendedScalars.Json);
    }
}

