/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.resultset.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.answering.connection.impl.Evaluator;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInvalidInputQueryException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.query.ConstructQuery;
import it.unibz.inf.ontop.query.DescribeQuery;
import it.unibz.inf.ontop.query.SelectQuery;
import it.unibz.inf.ontop.query.resultset.GraphResultSet;
import it.unibz.inf.ontop.query.resultset.OntopBinding;
import it.unibz.inf.ontop.query.resultset.OntopBindingSet;
import it.unibz.inf.ontop.query.resultset.OntopCloseableIterator;
import it.unibz.inf.ontop.query.resultset.TupleResultSet;
import it.unibz.inf.ontop.query.resultset.impl.OntopConnectionCloseable;
import it.unibz.inf.ontop.query.resultset.impl.RDFFactCloseableIterator;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;

public class DefaultDescribeGraphResultSet
implements GraphResultSet {
    private final ResultSetIterator iterator;

    public DefaultDescribeGraphResultSet(DescribeQuery describeQuery, QueryLogger queryLogger, QueryLogger.Factory queryLoggerFactory, QueryContext queryContext, Evaluator<TupleResultSet, SelectQuery> selectQueryEvaluator, Evaluator<GraphResultSet, ConstructQuery> constructQueryEvaluator, OntopConnectionCloseable statementClosingCB) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        ImmutableSet<IRI> resourcesToDescribe = DefaultDescribeGraphResultSet.extractDescribeResources(describeQuery, queryLogger, queryLoggerFactory, queryContext, selectQueryEvaluator);
        this.iterator = new ResultSetIterator((ImmutableCollection<ConstructQuery>)describeQuery.computeConstructQueries(resourcesToDescribe), queryLogger, queryLoggerFactory, queryContext, constructQueryEvaluator, statementClosingCB);
    }

    private static ImmutableSet<IRI> extractDescribeResources(DescribeQuery inputQuery, QueryLogger queryLogger, QueryLogger.Factory queryLoggerFactory, QueryContext queryContext, Evaluator<TupleResultSet, SelectQuery> selectQueryEvaluator) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        ImmutableSet immutableSet;
        block10: {
            QueryLogger selectQueryLogger = queryLoggerFactory.create(ImmutableMap.of());
            TupleResultSet resultSet = selectQueryEvaluator.evaluate(inputQuery.getSelectQuery(), queryContext, selectQueryLogger);
            try {
                queryLogger.declareResultSetUnblockedAndSerialize();
                ImmutableSet.Builder iriSetBuilder = ImmutableSet.builder();
                while (resultSet.hasNext()) {
                    OntopBindingSet bindingSet = (OntopBindingSet)resultSet.next();
                    for (OntopBinding binding : bindingSet.getBindings()) {
                        RDFConstant value = binding.getValue();
                        if (!(value instanceof IRIConstant)) continue;
                        iriSetBuilder.add((Object)((IRIConstant)value).getIRI());
                    }
                }
                immutableSet = iriSetBuilder.build();
                if (resultSet == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OntopInvalidInputQueryException e) {
                    throw new OntopReformulationException((Exception)((Object)e));
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    public boolean hasNext() throws OntopConnectionException, OntopQueryAnsweringException {
        return this.iterator.hasNext();
    }

    public RDFFact next() throws OntopQueryAnsweringException, OntopConnectionException {
        return this.iterator.next();
    }

    public OntopCloseableIterator<RDFFact, OntopConnectionException> iterator() {
        return this.iterator;
    }

    public void close() throws OntopConnectionException {
        this.iterator.close();
    }

    protected static class ResultSetIterator
    extends RDFFactCloseableIterator {
        private final UnmodifiableIterator<ConstructQuery> constructQueryIterator;
        private final OntopConnectionCloseable statementClosingCB;
        private final QueryLogger queryLogger;
        private final QueryLogger.Factory queryLoggerFactory;
        private final QueryContext queryContext;
        private final Evaluator<GraphResultSet, ConstructQuery> constructQueryEvaluator;
        private long rowCount;
        private @Nullable OntopCloseableIterator<RDFFact, OntopConnectionException> currentGraphResultSetIterator;

        public ResultSetIterator(ImmutableCollection<ConstructQuery> constructQueries, QueryLogger queryLogger, QueryLogger.Factory queryLoggerFactory, QueryContext queryContext, Evaluator<GraphResultSet, ConstructQuery> constructQueryEvaluator, OntopConnectionCloseable statementClosingCB) {
            this.constructQueryIterator = constructQueries.iterator();
            this.queryContext = queryContext;
            this.statementClosingCB = statementClosingCB;
            this.currentGraphResultSetIterator = null;
            this.queryLogger = queryLogger;
            this.queryLoggerFactory = queryLoggerFactory;
            this.constructQueryEvaluator = constructQueryEvaluator;
            this.rowCount = 0L;
        }

        public boolean hasNext() throws OntopConnectionException, OntopResultConversionException {
            while (true) {
                if (this.currentGraphResultSetIterator == null) {
                    if (this.constructQueryIterator.hasNext()) {
                        QueryLogger constructQueryLogger = this.queryLoggerFactory.create(ImmutableMap.of());
                        try {
                            GraphResultSet graphResultSet = this.constructQueryEvaluator.evaluate((ConstructQuery)this.constructQueryIterator.next(), this.queryContext, constructQueryLogger);
                            this.currentGraphResultSetIterator = graphResultSet.iterator();
                        }
                        catch (OntopQueryEvaluationException e) {
                            throw new LateQueryEvaluationExceptionWhenDescribing(e);
                        }
                        catch (OntopReformulationException e) {
                            throw new LateQueryReformulationExceptionWhenDescribing(e);
                        }
                    } else {
                        this.queryLogger.declareLastResultRetrievedAndSerialize(this.rowCount);
                        this.handleClose();
                        return false;
                    }
                }
                if (this.currentGraphResultSetIterator.hasNext()) {
                    ++this.rowCount;
                    return true;
                }
                this.currentGraphResultSetIterator.close();
                this.currentGraphResultSetIterator = null;
            }
        }

        public RDFFact next() throws OntopConnectionException {
            if (this.currentGraphResultSetIterator == null) {
                throw new IllegalStateException("Make sure to call hasNext() before calling next()");
            }
            return this.currentGraphResultSetIterator.next();
        }

        protected void handleClose() throws OntopConnectionException {
            if (this.currentGraphResultSetIterator != null) {
                this.currentGraphResultSetIterator.close();
            }
            this.statementClosingCB.close();
        }

        private static class LateQueryReformulationExceptionWhenDescribing
        extends OntopConnectionException {
            private LateQueryReformulationExceptionWhenDescribing(OntopReformulationException e) {
                super((Exception)e);
            }
        }

        private static class LateQueryEvaluationExceptionWhenDescribing
        extends OntopConnectionException {
            private LateQueryEvaluationExceptionWhenDescribing(OntopQueryEvaluationException e) {
                super((Exception)((Object)e));
            }
        }
    }
}

