/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.materialization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.answering.OntopQueryEngine;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.resultset.MaterializedGraphResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInvalidInputQueryException;
import it.unibz.inf.ontop.exception.OntopInvalidKGQueryException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.exception.OntopQueryEngineException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.materialization.impl.VocabularyEntry;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.query.KGQueryFactory;
import it.unibz.inf.ontop.query.SelectQuery;
import it.unibz.inf.ontop.query.resultset.OntopBindingSet;
import it.unibz.inf.ontop.query.resultset.OntopCloseableIterator;
import it.unibz.inf.ontop.query.resultset.TupleResultSet;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMaterializedGraphResultSet
implements MaterializedGraphResultSet {
    private final TermFactory termFactory;
    private final ImmutableMap<IRI, VocabularyEntry> vocabulary;
    private final KGQueryFactory kgQueryFactory;
    private final boolean canBeIncomplete;
    private final OntopQueryEngine queryEngine;
    private final UnmodifiableIterator<VocabularyEntry> vocabularyIterator;
    private int counter;
    private @Nullable OntopConnection ontopConnection;
    private @Nullable OntopStatement tmpStatement;
    private @Nullable TupleResultSet tmpContextResultSet;
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultMaterializedGraphResultSet.class);
    private final List<IRI> possiblyIncompleteClassesAndProperties;
    private VocabularyEntry lastSeenPredicate;
    private IRIConstant lastSeenPredicateIRI;
    private final IRIConstant rdfTypeIRI;

    DefaultMaterializedGraphResultSet(ImmutableMap<IRI, VocabularyEntry> vocabulary, MaterializationParams params, OntopQueryEngine queryEngine, KGQueryFactory kgQueryFactory, TermFactory termFactory, RDF rdfFactory) {
        this.termFactory = termFactory;
        this.vocabulary = vocabulary;
        this.vocabularyIterator = vocabulary.values().iterator();
        this.queryEngine = queryEngine;
        this.canBeIncomplete = params.canMaterializationBeIncomplete();
        this.kgQueryFactory = kgQueryFactory;
        this.possiblyIncompleteClassesAndProperties = new ArrayList<IRI>();
        this.counter = 0;
        this.rdfTypeIRI = termFactory.getConstantIRI(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE.getIRIString());
        this.ontopConnection = null;
        this.tmpStatement = null;
        this.tmpContextResultSet = null;
    }

    @Override
    public ImmutableSet<IRI> getSelectedVocabulary() {
        return this.vocabulary.keySet();
    }

    public boolean hasNext() throws OntopQueryAnsweringException, OntopConnectionException {
        if (this.ontopConnection == null) {
            this.ontopConnection = this.queryEngine.getConnection();
        }
        if (this.tmpContextResultSet != null && this.tmpContextResultSet.hasNext()) {
            return true;
        }
        while (this.vocabularyIterator.hasNext()) {
            if (this.tmpContextResultSet != null) {
                try {
                    this.tmpContextResultSet.close();
                }
                catch (OntopConnectionException e) {
                    this.LOGGER.warn("Non-critical exception while closing the graph result set: " + e);
                }
            }
            if (this.tmpStatement != null) {
                try {
                    this.tmpStatement.close();
                }
                catch (OntopConnectionException e) {
                    this.LOGGER.warn("Non-critical exception while closing the statement: " + e);
                }
            }
            VocabularyEntry predicate = (VocabularyEntry)this.vocabularyIterator.next();
            try {
                SelectQuery query = this.kgQueryFactory.createSelectQuery(predicate.getSelectQuery());
                this.tmpStatement = this.ontopConnection.createStatement();
                this.tmpContextResultSet = (TupleResultSet)this.tmpStatement.execute(query);
                if (!this.tmpContextResultSet.hasNext()) continue;
                this.lastSeenPredicate = predicate;
                this.lastSeenPredicateIRI = this.termFactory.getConstantIRI(this.lastSeenPredicate.getIRIString());
                return true;
            }
            catch (OntopConnectionException | OntopQueryAnsweringException e) {
                if (this.canBeIncomplete) {
                    this.LOGGER.warn("Possibly incomplete class/property " + predicate + " (materialization problem).\nDetails: " + (OntopQueryEngineException)e);
                    this.possiblyIncompleteClassesAndProperties.add(predicate.name);
                    continue;
                }
                this.LOGGER.error("Problem materializing the class/property " + predicate);
                throw e;
            }
            catch (OntopInvalidKGQueryException e) {
                throw new OntopInvalidInputQueryException(e.getMessage());
            }
        }
        return false;
    }

    private RDFFact toAssertion(OntopBindingSet tuple) throws OntopResultConversionException {
        ObjectConstant s = (ObjectConstant)tuple.getConstant("s");
        IRIConstant p = this.lastSeenPredicate.isClass() ? this.rdfTypeIRI : this.lastSeenPredicateIRI;
        IRIConstant o = this.lastSeenPredicate.isClass() ? this.lastSeenPredicateIRI : tuple.getConstant("o");
        ObjectConstant g = (ObjectConstant)tuple.getConstant("g");
        return g == null ? RDFFact.createTripleFact((ObjectConstant)s, (IRIConstant)p, (RDFConstant)o) : RDFFact.createQuadFact((ObjectConstant)s, (IRIConstant)p, (RDFConstant)o, (ObjectConstant)g);
    }

    public RDFFact next() throws OntopQueryAnsweringException {
        ++this.counter;
        try {
            OntopBindingSet resultTuple = (OntopBindingSet)this.tmpContextResultSet.next();
            return this.toAssertion(resultTuple);
        }
        catch (OntopConnectionException e) {
            try {
                this.tmpContextResultSet.close();
            }
            catch (OntopConnectionException ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
            return null;
        }
    }

    public OntopCloseableIterator<RDFFact, OntopConnectionException> iterator() {
        throw new UnsupportedOperationException("iterator");
    }

    public void close() throws OntopConnectionException {
        if (this.tmpStatement != null) {
            this.tmpStatement.close();
        }
        if (this.ontopConnection != null) {
            this.ontopConnection.close();
        }
    }

    @Override
    public long getTripleCountSoFar() {
        return this.counter;
    }

    @Override
    public ImmutableList<IRI> getPossiblyIncompleteRDFPropertiesAndClassesSoFar() {
        return ImmutableList.copyOf(this.possiblyIncompleteClassesAndProperties);
    }
}

