/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.answering.OntopQueryEngine;
import it.unibz.inf.ontop.answering.connection.DBConnector;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.injection.OntopSystemFactory;
import it.unibz.inf.ontop.injection.ReformulationFactory;
import it.unibz.inf.ontop.spec.OBDASpecification;

public class OntopQueryEngineImpl
implements OntopQueryEngine {
    private final DBConnector dbConnector;
    private final QueryReformulator queryReformulator;

    @AssistedInject
    private OntopQueryEngineImpl(@Assisted OBDASpecification obdaSpecification, ReformulationFactory translationFactory, OntopSystemFactory systemFactory) {
        this.queryReformulator = translationFactory.create(obdaSpecification);
        this.dbConnector = systemFactory.create(this.queryReformulator);
    }

    @Override
    public boolean connect() throws OntopConnectionException {
        return this.dbConnector.connect();
    }

    @Override
    public void close() throws OntopConnectionException {
        this.dbConnector.close();
    }

    @Override
    public OntopConnection getConnection() throws OntopConnectionException {
        return this.dbConnector.getConnection();
    }

    @Override
    public QueryReformulator getQueryReformulator() {
        return this.queryReformulator;
    }
}

