/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.pending_tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PendingTask
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PendingTask> {
    private final boolean executing;
    private final int insertOrder;
    @Nonnull
    private final String priority;
    @Nonnull
    private final String source;
    @Nullable
    private final Time timeInQueue;
    private final long timeInQueueMillis;
    public static final JsonpDeserializer<PendingTask> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PendingTask::setupPendingTaskDeserializer);

    private PendingTask(Builder builder) {
        this.executing = ApiTypeHelper.requireNonNull(builder.executing, this, "executing");
        this.insertOrder = ApiTypeHelper.requireNonNull(builder.insertOrder, this, "insertOrder");
        this.priority = ApiTypeHelper.requireNonNull(builder.priority, this, "priority");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.timeInQueue = builder.timeInQueue;
        this.timeInQueueMillis = ApiTypeHelper.requireNonNull(builder.timeInQueueMillis, this, "timeInQueueMillis");
    }

    public static PendingTask of(Function<Builder, ObjectBuilder<PendingTask>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean executing() {
        return this.executing;
    }

    public final int insertOrder() {
        return this.insertOrder;
    }

    @Nonnull
    public final String priority() {
        return this.priority;
    }

    @Nonnull
    public final String source() {
        return this.source;
    }

    @Nullable
    public final Time timeInQueue() {
        return this.timeInQueue;
    }

    public final long timeInQueueMillis() {
        return this.timeInQueueMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("executing");
        generator.write(this.executing);
        generator.writeKey("insert_order");
        generator.write(this.insertOrder);
        generator.writeKey("priority");
        generator.write(this.priority);
        generator.writeKey("source");
        generator.write(this.source);
        if (this.timeInQueue != null) {
            generator.writeKey("time_in_queue");
            this.timeInQueue.serialize(generator, mapper);
        }
        generator.writeKey("time_in_queue_millis");
        generator.write(this.timeInQueueMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPendingTaskDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::executing, JsonpDeserializer.booleanDeserializer(), "executing");
        op.add(Builder::insertOrder, JsonpDeserializer.integerDeserializer(), "insert_order");
        op.add(Builder::priority, JsonpDeserializer.stringDeserializer(), "priority");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
        op.add(Builder::timeInQueue, Time._DESERIALIZER, "time_in_queue");
        op.add(Builder::timeInQueueMillis, JsonpDeserializer.longDeserializer(), "time_in_queue_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.executing);
        result = 31 * result + Integer.hashCode(this.insertOrder);
        result = 31 * result + this.priority.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + Objects.hashCode(this.timeInQueue);
        result = 31 * result + Long.hashCode(this.timeInQueueMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PendingTask other = (PendingTask)o;
        return this.executing == other.executing && this.insertOrder == other.insertOrder && this.priority.equals(other.priority) && this.source.equals(other.source) && Objects.equals(this.timeInQueue, other.timeInQueue) && this.timeInQueueMillis == other.timeInQueueMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PendingTask> {
        private Boolean executing;
        private Integer insertOrder;
        private String priority;
        private String source;
        @Nullable
        private Time timeInQueue;
        private Long timeInQueueMillis;

        public Builder() {
        }

        private Builder(PendingTask o) {
            this.executing = o.executing;
            this.insertOrder = o.insertOrder;
            this.priority = o.priority;
            this.source = o.source;
            this.timeInQueue = o.timeInQueue;
            this.timeInQueueMillis = o.timeInQueueMillis;
        }

        private Builder(Builder o) {
            this.executing = o.executing;
            this.insertOrder = o.insertOrder;
            this.priority = o.priority;
            this.source = o.source;
            this.timeInQueue = o.timeInQueue;
            this.timeInQueueMillis = o.timeInQueueMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder executing(boolean value) {
            this.executing = value;
            return this;
        }

        @Nonnull
        public final Builder insertOrder(int value) {
            this.insertOrder = value;
            return this;
        }

        @Nonnull
        public final Builder priority(String value) {
            this.priority = value;
            return this;
        }

        @Nonnull
        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        @Nonnull
        public final Builder timeInQueue(@Nullable Time value) {
            this.timeInQueue = value;
            return this;
        }

        @Nonnull
        public final Builder timeInQueue(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeInQueue(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder timeInQueueMillis(long value) {
            this.timeInQueueMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public PendingTask build() {
            this._checkSingleUse();
            return new PendingTask(this);
        }
    }
}

