/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.stats.swagger;

import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.List;
import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.ServerBaseUrlCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.properties.SwaggerUiOAuthProperties;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.SecurityService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.webmvc.core.configuration.SpringDocWebMvcConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages={"com.ontotext.forest"})
@Import(value={SpringDocConfigProperties.class, SpringDocConfiguration.class, SpringDocWebMvcConfiguration.class, SwaggerUiConfigProperties.class, SwaggerUiOAuthProperties.class, JacksonAutoConfiguration.class})
@PropertySource(value={"classpath:META-INF/swagger.properties"})
public class GraphDBWorkbenchSwaggerBootstrap {
    public static final String X_FORWARDED_PREFIX = "x-forwarded-prefix";

    @Bean
    public OpenAPI api() {
        return new OpenAPI(SpecVersion.V31).info(new Info().title("GraphDB API").description("").contact(new Contact().name("Ontotext AD").url("http://ontotext.com")).version(SpecVersion.V31.name()).license(null));
    }

    @Bean
    public OpenApiCustomizer globalResponseMessages() {
        return openApi -> openApi.getPaths().values().forEach(pathItem -> pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
            if (httpMethod == PathItem.HttpMethod.GET) {
                ApiResponses responses = operation.getResponses();
                if (responses == null) {
                    responses = new ApiResponses();
                    operation.setResponses(responses);
                }
                ApiResponse errorResponse = new ApiResponse().description("500 message").content(new Content().addMediaType("text/plain", new MediaType().schema(new Schema().type("string").example((Object)"string"))));
                responses.addApiResponse("500", errorResponse);
            }
        }));
    }

    @Bean
    OpenAPIService openAPIBuilder(Optional<OpenAPI> openAPI, SecurityService securityParser, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomisers, Optional<List<ServerBaseUrlCustomizer>> serverBaseUrlCustomisers, Optional<JavadocProvider> javadocProvider) {
        OpenApiBuilderCustomizer customizer = service -> {
            service.getMappingsMap().clear();
            service.addMappings(service.getContext().getBeansWithAnnotation(Tag.class));
        };
        if (openApiBuilderCustomisers.isEmpty()) {
            openApiBuilderCustomisers = Optional.of(List.of(customizer));
        } else {
            openApiBuilderCustomisers.get().add(customizer);
        }
        return new OpenAPIService(openAPI, securityParser, springDocConfigProperties, propertyResolverUtils, openApiBuilderCustomisers, serverBaseUrlCustomisers, javadocProvider);
    }

    @Bean
    public SpringDocConfigProperties springDocConfigProperties() {
        return new SpringDocConfigProperties();
    }
}

