/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.stats.swagger;

import com.ontotext.graphdb.Config;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GraphDBOpenApiWebMvcResource
extends OpenApiResource {
    public GraphDBOpenApiWebMvcResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @Autowired
    public GraphDBOpenApiWebMvcResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/rest/api/workbench"}, produces={"application/json"})
    public OpenAPI graphdbOpenapiJson(HttpServletRequest request, @Value(value="/rest/api/workbench") String apiDocsUrl, Locale locale) {
        this.calculateServerUrl(request, apiDocsUrl, locale);
        OpenAPI openAPI = this.getOpenApi(locale);
        List tags = openAPI.getTags();
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            tags.sort(Comparator.comparing(Tag::getName));
        }
        return openAPI;
    }

    protected String getServerUrl(HttpServletRequest request, String apiDocsUrl) {
        String xForwardedPrefix = request.getHeader("x-forwarded-prefix");
        if (StringUtils.isNotEmpty((CharSequence)xForwardedPrefix)) {
            return xForwardedPrefix;
        }
        URI externalUrl = Config.lookupVirtualHost((String)request.getHeader("Referer"));
        if (externalUrl != null) {
            return request.getContextPath().isEmpty() ? "/" : request.getContextPath();
        }
        String requestUrl = this.decode(request.getRequestURL().toString());
        Optional springWebProviderOptional = this.springDocProviders.getSpringWebProvider();
        String prefix = "";
        if (springWebProviderOptional.isPresent()) {
            prefix = ((SpringWebProvider)springWebProviderOptional.get()).findPathPrefix(this.springDocConfigProperties);
        }
        return requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length() - prefix.length());
    }
}

