/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.stats.admin;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.properties.AskablePropertyPlaceholderConfigurer;
import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.proxy.SkipParametersHttpServletRequest;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.forest.core.util.RequestUtils;
import com.ontotext.forest.stats.admin.InfoBean;
import com.ontotext.forest.stats.admin.PropertyWithSource;
import com.ontotext.graphdb.Config;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Hidden
@RequestMapping(value={"/rest/info"})
@Controller
public class AdminInfoController {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SemanticDataManagement dataManagement;
    @Autowired
    private SemanticLocationManagement locationManagement;
    @Autowired
    private ProxyToRemoteSesame proxyToRemoteSesame;
    private TreeSet<PropertyWithSource> staticProperties;

    @PostConstruct
    public void init() {
        this.staticProperties = new TreeSet<PropertyWithSource>(){

            @Override
            public boolean add(PropertyWithSource o) {
                String key = o.getKey();
                if (!key.startsWith("graphdb.") || key.startsWith("graphdb.s4.") || key.equals("graphdb.product_type") || key.equals("graphdb.workbench.default.auth") || key.equals("graphdb.workbench.ontorefine")) {
                    return false;
                }
                return super.add(o);
            }
        };
        this.staticProperties.add(AdminInfoController.getConfigProperty("graphdb.home", Config::getHome));
        this.staticProperties.add(AdminInfoController.getConfigProperty("graphdb.home.conf", Config::getConfDirectory));
        this.staticProperties.add(AdminInfoController.getConfigProperty("graphdb.home.data", Config::getDataDirectory));
        this.staticProperties.add(AdminInfoController.getConfigProperty("graphdb.home.work", Config::getWorkDirectory));
        this.staticProperties.add(AdminInfoController.getConfigProperty("graphdb.home.logs", Config::getLogsDirectory));
        System.getProperties().entrySet().forEach(e -> this.staticProperties.add(new PropertyWithSource((String)e.getKey(), (String)e.getValue(), "explicit")));
        Config.getProperties().entrySet().forEach(e -> this.staticProperties.add(new PropertyWithSource((String)e.getKey(), (String)e.getValue(), "explicit")));
        Collection propertyProviders = this.applicationContext.getBeansOfType(AskablePropertyPlaceholderConfigurer.class).values();
        for (AskablePropertyPlaceholderConfigurer propertyProvider : propertyProviders) {
            Map p = propertyProvider.getProperties();
            for (Map.Entry property : p.entrySet()) {
                String key = (String)property.getKey();
                this.staticProperties.add(AdminInfoController.getConfigProperty(key, () -> propertyProvider.getProperty(key).toString()));
            }
        }
    }

    @RequestMapping(value={"/data"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public InfoBean systemInformationData() {
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        return new InfoBean(RequestUtils.getRequest().getLocalName(), RuntimemxBean.getInputArguments(), this.getProperties());
    }

    @RequestMapping(value={"/properties"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<List<PropertyWithSource>> userPropertiesData() {
        ArrayList<PropertyWithSource> filteredProperties = new ArrayList<PropertyWithSource>();
        for (PropertyWithSource property : this.getProperties()) {
            switch (property.getKey()) {
                case "graphdb.workbench.maxUploadSize": 
                case "graphdb.workbench.importDirectory": {
                    filteredProperties.add(new PropertyWithSource(property.getKey(), property.getValue(), ""));
                }
            }
        }
        return new ResponseEntity(filteredProperties, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/rpc-address"})
    public ResponseEntity<?> getRPCAddress(@RequestParam(required=false) @Nullable String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SemanticLocation semanticLocation = this.getExplicitOrCurrentLocation(location);
        if (semanticLocation.isLocal()) {
            return new ResponseEntity((Object)Config.getRPCAddress(), (HttpStatusCode)HttpStatus.OK);
        }
        this.proxyToRemoteSesame.proxyRequest((HttpServletRequest)new SkipParametersHttpServletRequest(request, Collections.singleton("location")), response, semanticLocation);
        return null;
    }

    @GetMapping(value={"/external-url"})
    public ResponseEntity<?> getHttpAddress(@RequestParam(required=false) @Nullable String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SemanticLocation semanticLocation = this.getExplicitOrCurrentLocation(location);
        if (semanticLocation.isLocal()) {
            return new ResponseEntity((Object)Config.getExternalUrl(null), (HttpStatusCode)HttpStatus.OK);
        }
        this.proxyToRemoteSesame.proxyRequest((HttpServletRequest)new SkipParametersHttpServletRequest(request, Collections.singleton("location")), response, semanticLocation);
        return null;
    }

    private TreeSet<PropertyWithSource> getProperties() {
        return this.staticProperties;
    }

    private static PropertyWithSource getConfigProperty(String propertyName, Callable<String> actualValueCallback) {
        String propertySource = "explicit";
        String propertyValue = Config.getProperty((String)propertyName);
        if (actualValueCallback != null) {
            try {
                String actualValue = actualValueCallback.call();
                if (actualValue != null && !actualValue.equals(propertyValue)) {
                    propertySource = "default";
                    propertyValue = actualValue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (propertyValue == null) {
            propertySource = "no value";
        }
        return new PropertyWithSource(propertyName, propertyValue, propertySource);
    }

    private SemanticLocation getExplicitOrCurrentLocation(String location) throws GraphDBWorkbenchException {
        if (StringUtils.isEmpty((CharSequence)location)) {
            return this.dataManagement.getCurrentLocationOrThrow();
        }
        SemanticLocationAuth semanticLocationAuth = this.locationManagement.getExistingLocationOrThrow(location);
        if (!(semanticLocationAuth instanceof SemanticLocation)) {
            return null;
        }
        return (SemanticLocation)semanticLocationAuth;
    }
}

