/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.resultset.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.query.resultset.OntopBinding;
import it.unibz.inf.ontop.query.resultset.impl.AbstractTupleResultSet;
import it.unibz.inf.ontop.query.resultset.impl.OntopBindingImpl;
import it.unibz.inf.ontop.query.resultset.impl.OntopConnectionCloseable;
import it.unibz.inf.ontop.query.resultset.impl.SQLOntopBindingSet;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class JDBCTupleResultSet
extends AbstractTupleResultSet {
    private final ImmutableMap<Integer, Variable> indexedSqlSignature;
    private final ImmutableMap<Variable, DBTermType> sqlTypeMap;
    private final Substitution<ImmutableTerm> sparqlVar2Term;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    public JDBCTupleResultSet(ResultSet rs, ImmutableSortedSet<Variable> sqlSignature, ImmutableMap<Variable, DBTermType> sqlTypeMap, ConstructionNode constructionNode, DistinctVariableOnlyDataAtom answerAtom, QueryLogger queryLogger, @Nullable OntopConnectionCloseable statementClosingCB, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(rs, (ImmutableList<Variable>)answerAtom.getArguments(), queryLogger, statementClosingCB);
        ImmutableMap.Builder indexedSqlSignatureBuilder = ImmutableMap.builder();
        int index = 1;
        for (Variable v : sqlSignature) {
            indexedSqlSignatureBuilder.put((Object)index, (Object)v);
            ++index;
        }
        this.indexedSqlSignature = indexedSqlSignatureBuilder.build();
        this.sqlTypeMap = sqlTypeMap;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.sparqlVar2Term = constructionNode.getSubstitution();
    }

    @Override
    protected SQLOntopBindingSet readCurrentRow() throws OntopConnectionException, OntopResultConversionException {
        Substitution substitution;
        try {
            substitution = this.substitutionFactory.getSubstitutionThrowsExceptions((Collection)this.indexedSqlSignature.entrySet(), Map.Entry::getValue, e -> this.convertToConstant(this.rs.getString((Integer)e.getKey()), (DBTermType)this.sqlTypeMap.get(e.getValue())));
        }
        catch (SQLException e2) {
            throw this.buildConnectionException(e2);
        }
        try {
            return new SQLOntopBindingSet(this.computeBindingMap((Substitution<Constant>)substitution));
        }
        catch (Exception e3) {
            throw new OntopResultConversionException(e3);
        }
    }

    private Constant convertToConstant(@Nullable String jdbcValue, DBTermType termType) {
        if (jdbcValue == null) {
            return this.termFactory.getNullConstant();
        }
        return this.termFactory.getDBConstant(jdbcValue, termType);
    }

    private OntopBinding[] computeBindingMap(Substitution<Constant> sqlVar2Constant) {
        return (OntopBinding[])this.signature.stream().map(v -> this.getBinding((Variable)v, sqlVar2Constant)).filter(Optional::isPresent).map(Optional::get).toArray(OntopBinding[]::new);
    }

    private Optional<OntopBinding> getBinding(Variable v, Substitution<Constant> sqlVar2Constant) {
        ImmutableTerm term = this.sparqlVar2Term.apply(v);
        ImmutableTerm constantTerm = sqlVar2Constant.applyToTerm(term);
        Optional<RDFConstant> constant = this.evaluate(constantTerm);
        return constant.map(rdfConstant -> new OntopBindingImpl(v, rdfConstant));
    }

    private Optional<RDFConstant> evaluate(ImmutableTerm term) {
        ImmutableTerm simplifiedTerm = term.simplify();
        if (simplifiedTerm instanceof RDFConstant) {
            return Optional.of((RDFConstant)simplifiedTerm);
        }
        if (simplifiedTerm.isNull()) {
            return Optional.empty();
        }
        if (simplifiedTerm instanceof DBConstant) {
            throw new SQLOntopBindingSet.InvalidConstantTypeInResultException(simplifiedTerm + " is a DB constant. But a binding cannot have a DB constant as value");
        }
        if (simplifiedTerm instanceof Constant) {
            throw new SQLOntopBindingSet.InvalidConstantTypeInResultException("Unexpected constant type for " + simplifiedTerm);
        }
        throw new SQLOntopBindingSet.InvalidTermAsResultException(simplifiedTerm);
    }
}

