/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.dbschema.tools.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.JDBCMetadataProviderFactory;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.spec.dbschema.tools.DBMetadataExtractorAndSerializer;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;

public class RDBMetadataExtractorAndSerializerImpl
implements DBMetadataExtractorAndSerializer {
    private final OntopSQLCredentialSettings settings;
    private final JDBCMetadataProviderFactory metadataProviderFactory;

    @Inject
    private RDBMetadataExtractorAndSerializerImpl(OntopSQLCredentialSettings settings, JDBCMetadataProviderFactory metadataProviderFactory) {
        this.settings = settings;
        this.metadataProviderFactory = metadataProviderFactory;
    }

    public String extractAndSerialize(Function<NamedRelationDefinition, RelationID> fkRelationIDExtractor) throws MetadataExtractionException {
        String string;
        block9: {
            Connection localConnection = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)this.settings);
            try {
                DBMetadataProvider metadataProvider = this.metadataProviderFactory.getMetadataProvider(localConnection);
                ImmutableMetadata metadata = ImmutableMetadata.extractImmutableMetadata((MetadataProvider)metadataProvider);
                ObjectMapper mapper = new ObjectMapper();
                JsonMetadata jsonMetadata = new JsonMetadata(metadata, fkRelationIDExtractor);
                string = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonMetadata);
                if (localConnection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (localConnection != null) {
                        try {
                            localConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new MetadataExtractionException("Connection problem while extracting the metadata.\n" + e);
                }
                catch (JsonProcessingException e) {
                    throw new MetadataExtractionException("problem with JSON processing.\n" + e);
                }
            }
            localConnection.close();
        }
        return string;
    }
}

