/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql;

import com.ontotext.forest.graphql.GraphDBGraphQLRequestContext;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.graphql.GraphQLConfigurations;
import com.ontotext.graphdb.sesame.sos.SOSSplitQuery;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.trree.RepositoryMonitorTrackRecord;
import com.ontotext.trree.RepositoryMonitorTrackRecordHelper;
import com.ontotext.trree.RepositoryMonitorTrackRecordImpl;
import com.ontotext.trree.monitorRepository.MonitorRepositoryConnection;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;

public class GraphQLRepositoryConnection
extends RepositoryConnectionWrapper {
    private final GraphQLConfigurations configurations = new GraphQLConfigurations();

    public GraphQLRepositoryConnection(Repository repository, RepositoryConnection delegate) {
        super(repository, delegate);
    }

    public TupleQuery prepareTupleQuery(String query) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(QueryLanguage.SPARQL, query, null);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareTupleQuery(ql, query, null);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException, RepositoryException {
        SOSSplitQuery splitQuery = SOSSplitQuery.parse((String)queryString, (int)this.getTupleLimit());
        if (splitQuery.getRootQuery().hasSubSteps()) {
            this.registerTrackRecord(splitQuery);
            int numOfThreads = Config.getPropertyAsInt((String)"graphdb.sos.cluster.numOfThreads", (int)1);
            splitQuery.setParserOp(query -> this.getDelegate().prepareTupleQuery(ql, query, baseURI));
            splitQuery.build(numOfThreads);
            return splitQuery;
        }
        return super.prepareTupleQuery(ql, queryString, baseURI);
    }

    private Integer getTupleLimit() {
        Integer tupleLimit = SparqlEndpointRequestContext.getSubQueryResultLimit();
        if (tupleLimit == null) {
            tupleLimit = this.configurations.getMaxTupleResults();
        }
        return tupleLimit;
    }

    private void registerTrackRecord(SOSSplitQuery splitQuery) {
        RepositoryConnection delegate = this.getDelegate();
        if (delegate instanceof MonitorRepositoryConnection) {
            MonitorRepositoryConnection monitorConnection = (MonitorRepositoryConnection)delegate;
            RepositoryMonitorTrackRecordHelper trackRecordHelper = monitorConnection.getSailConnectionImpl().getTrackRecordHelper();
            RepositoryMonitorTrackRecordImpl trackRecord = trackRecordHelper.getTrackRecord();
            trackRecord.setType(RepositoryMonitorTrackRecord.Type.GRAPHQL);
            trackRecordHelper.registerTrackRecordQuery(() -> {
                splitQuery.setAborted(true);
                trackRecordHelper.closeTrackRecord(trackRecord);
                this.close();
            });
            trackRecordHelper.registerTrackRecordSparqlString(GraphDBGraphQLRequestContext.getGraphqlRequest());
            splitQuery.setRepositoryMonitorTrackRecordHelper(trackRecordHelper);
            splitQuery.setTrackRecord(trackRecord);
        }
    }
}

