/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ontotext.metamodel.storage.SomlIdManager;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Represents a GraphQL endpoint with metadata.")
public class GraphQLEndpoint {
    @Schema(example="swapi")
    private String id;
    @Schema(example="true", type="boolean")
    private boolean active;
    @JsonProperty(value="default")
    @Schema(name="default", example="false", type="boolean")
    private boolean isDefault;
    @Schema(example="Star Wars API")
    private String label;
    @Schema(example="GraphQL API for Star Wars data")
    private String description;
    @Schema(example="2025-03-15T10:30:00Z")
    private String lastModified;
    @Schema(example="1000", type="integer")
    private int objectsCount;
    @Schema(example="250", type="integer")
    private int propertiesCount;
    @Schema(example="2", type="integer")
    private int warnings;
    @Schema(example="2", type="integer")
    private int errors;
    @Schema(example="upload")
    private String endpointCreationType;

    public GraphQLEndpoint() {
    }

    public GraphQLEndpoint(String somlId) {
        this.id = SomlIdManager.INSTANCE.somlIdToReference(somlId);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = SomlIdManager.INSTANCE.somlIdToReference(id);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public int getObjectsCount() {
        return this.objectsCount;
    }

    public void setObjectsCount(int objectsCount) {
        this.objectsCount = objectsCount;
    }

    public int getPropertiesCount() {
        return this.propertiesCount;
    }

    public void setPropertiesCount(int propertiesCount) {
        this.propertiesCount = propertiesCount;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getEndpointCreationType() {
        return this.endpointCreationType;
    }

    public void setEndpointCreationType(String endpointCreationType) {
        this.endpointCreationType = endpointCreationType;
    }
}

