/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller;

import com.ontotext.forest.core.error.ErrorMessage;
import com.ontotext.forest.graphql.controller.responses.ResponseMapper;
import com.ontotext.models.ValidatingException;
import com.ontotext.soaas.common.exceptions.PlatformRuntimeException;
import com.ontotext.soaas.common.exceptions.ShaclBindException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Order(value=-2147483648)
@ControllerAdvice
public class ExceptionHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @ExceptionHandler
    public ResponseEntity<Object> handlePlatformRuntimeException(PlatformRuntimeException ex) {
        return new ResponseEntity((Object)new ErrorMessage(ex.getReason()), (HttpStatusCode)HttpStatus.valueOf((int)ex.getHttpStatus()));
    }

    @ExceptionHandler
    public ResponseEntity<Object> handleValidatingException(ValidatingException ex) {
        List messages = ex.getValidationReport().getMessages();
        ErrorMessage responses = new ArrayList(messages.size());
        List errors = ex.getErrorMessages(ResponseMapper.toErrorResponse());
        responses.addAll(errors);
        responses.addAll(ex.getWarningMessages(ResponseMapper.toWarningResponse()));
        HttpStatus responseStatus = HttpStatus.BAD_REQUEST;
        if (errors.isEmpty()) {
            responseStatus = HttpStatus.CREATED;
        }
        return new ResponseEntity((Object)(responseStatus == HttpStatus.CREATED ? responses : new ErrorMessage(ex.getMessage())), (HttpStatusCode)responseStatus);
    }

    @ExceptionHandler
    public ResponseEntity<Object> handleShaclBindException(ShaclBindException ex) {
        return new ResponseEntity((Object)new ErrorMessage(ex.getMessage()), (HttpStatusCode)HttpStatus.valueOf((int)ex.getHttpStatus()));
    }

    @ExceptionHandler
    public ResponseEntity<Object> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException matme) {
        Object value = matme.getValue();
        Class requiredType = matme.getRequiredType();
        String error = String.format("Invalid value '%s' of type '%s' for parameter '%s'. Expected type is '%s'.", value, value != null ? value.getClass().getSimpleName() : null, matme.getName(), requiredType != null ? requiredType.getSimpleName() : null);
        return new ResponseEntity((Object)new ErrorMessage(error), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

