/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.cluster;

import com.ontotext.graphdb.raft.grpc.AbstractRpcClient;
import com.ontotext.graphdb.raft.grpc.Data;
import com.ontotext.graphdb.raft.grpc.GraphQLEvaluatorServiceGrpc;
import com.ontotext.graphdb.raft.grpc.GraphQLQuery;
import com.ontotext.graphdb.raft.grpc.ReportingIterator;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.grpc.TrackRecordData;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import java.io.Closeable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class RpcGraphQLQueryClient
extends AbstractRpcClient {
    protected final AtomicInteger queryCount;
    protected final AtomicLong totalQueries;
    protected final RpcNodeClient raftClient;
    protected volatile GraphQLEvaluatorServiceGrpc.GraphQLEvaluatorServiceBlockingStub stub;

    public RpcGraphQLQueryClient(RpcNodeClient raftClient) {
        super(raftClient.getAddress(), raftClient.getMessageSizeBytes());
        this.raftClient = raftClient;
        this.queryCount = new AtomicInteger(0);
        this.totalQueries = new AtomicLong(0L);
    }

    public void initStubs() {
        this.stub = GraphQLEvaluatorServiceGrpc.newBlockingStub((Channel)this.mainChannel);
    }

    public int getQueryCount() {
        return this.queryCount.get();
    }

    public long getTotalQueryCount() {
        return this.totalQueries.get();
    }

    public long getLastLogIndex() {
        return this.raftClient.getMatchIndex();
    }

    public RpcNodeClient.Status fetchStatus() {
        return this.raftClient.getStatus();
    }

    public Iterator<Data> evaluateGraphQL(GraphQLQuery query) {
        return this.evaluateQuery(query, request -> {
            ClientCall call = this.mainChannel.newCall(GraphQLEvaluatorServiceGrpc.getEvaluateMethod(), this.stub.getCallOptions());
            return new ReportingIterator(ClientCalls.blockingServerStreamingCall((ClientCall)call, (Object)request), (arg_0, arg_1) -> ((ClientCall)call).cancel(arg_0, arg_1));
        });
    }

    private Iterator<Data> evaluateQuery(GraphQLQuery query, Function<GraphQLQuery, ReportingIterator<Data>> queryFunction) {
        IteratorImpl<Data> iterator = null;
        try {
            this.totalQueries.incrementAndGet();
            this.queryCount.incrementAndGet();
            iterator = this.wrapIterator(queryFunction.apply(query));
            return iterator;
        }
        catch (Throwable t) {
            if (iterator == null) {
                this.queryCount.decrementAndGet();
            } else {
                iterator.close();
            }
            throw t;
        }
    }

    @NotNull
    private IteratorImpl<Data> wrapIterator(ReportingIterator<Data> iterator) {
        AtomicInteger localQueryCount = this.queryCount;
        return new IteratorImpl<Data>(iterator, localQueryCount::decrementAndGet);
    }

    public boolean abortQuery(TrackRecordData trackRecordData) {
        return this.stub.abortQuery(trackRecordData).getResult();
    }

    private static class IteratorImpl<T>
    implements Iterator<T>,
    Closeable {
        private final ReportingIterator<T> delegate;
        private final Runnable onComplete;
        private volatile boolean complete = false;
        private boolean hasMoreData = true;
        private RuntimeException lastException;

        IteratorImpl(ReportingIterator<T> delegate, Runnable onComplete) {
            this.delegate = delegate;
            this.onComplete = onComplete;
        }

        @Override
        public boolean hasNext() {
            try {
                this.hasMoreData = this.delegate.hasNext();
                return this.hasMoreData;
            }
            catch (RuntimeException re) {
                this.lastException = re;
                this.close();
                throw re;
            }
        }

        @Override
        public T next() {
            try {
                return (T)this.delegate.next();
            }
            catch (RuntimeException re) {
                this.lastException = re;
                this.close();
                throw re;
            }
        }

        @Override
        public void close() {
            if (!this.complete) {
                if (this.lastException != null) {
                    this.delegate.reportError(null, (Throwable)this.lastException);
                } else if (this.hasMoreData) {
                    this.delegate.reportError("Client cannot accept more data", (Throwable)new StatusRuntimeException(Status.CANCELLED));
                }
                this.complete = true;
                this.onComplete.run();
            }
        }
    }
}

