/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.cluster;

import com.github.jsonldjava.utils.JsonUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.GraphDBByteString;
import com.ontotext.forest.core.monitor.common.MonitoringMBeanUtils;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.graphql.GraphQLService;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.grpc.BooleanData;
import com.ontotext.graphdb.raft.grpc.Data;
import com.ontotext.graphdb.raft.grpc.GraphQLEvaluatorServiceGrpc;
import com.ontotext.graphdb.raft.grpc.GraphQLQuery;
import com.ontotext.graphdb.raft.grpc.TrackRecordData;
import com.ontotext.graphdb.raft.util.RpcOutputStream;
import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.soaas.common.exceptions.PlatformQueryExecutionException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import com.ontotext.soaas.query.service.QueryService;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class GraphQLQueryEvaluatorService
extends GraphQLEvaluatorServiceGrpc.GraphQLEvaluatorServiceImplBase
implements ApplicationListener<PropertyChangedEvent> {
    private static final Logger LOGGER = Loggers.graphqlLogger();
    private static final int MESSAGE_SIZE = Config.getPropertyAsInt((String)"graphdb.raft.rpc.message.size", (int)ClusterGroup.MESSAGE_SIZE_KB_DEFAULT) * 1024;
    private final GraphQLService graphqlService;
    private boolean serverInitialized;

    @Autowired
    public GraphQLQueryEvaluatorService(GraphQLService graphqlService) {
        this.graphqlService = graphqlService;
    }

    public void evaluate(GraphQLQuery request, StreamObserver<Data> responseObserver) {
        Object graphQLResponse;
        QueryService queryService;
        if (!this.serverInitialized) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Server not initialized and cannot accept query requests, yet").withCause((Throwable)new RepositoryException())));
            return;
        }
        GraphQlQueryRequest queryRequest = this.buildRequest(request, responseObserver);
        if (queryRequest == null) {
            return;
        }
        String schemaId = StringUtils.trimToNull((String)request.getSchema());
        String repository = request.getRepository();
        GraphQLQueryEvaluatorService.logRequest(repository, schemaId, queryRequest);
        Timer timer = Timer.start();
        try {
            queryService = this.graphqlService.getServiceManager().getQueryService(repository, schemaId);
        }
        catch (RuntimeException re) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Could not evaluate query due to: " + re.getMessage()).withCause((Throwable)re)));
            this.graphqlService.incrementFailedQueryStatistics(repository, false);
            return;
        }
        this.setTrackAlias(request);
        boolean isSuccessful = true;
        try {
            graphQLResponse = queryService.evaluateQuery(queryRequest, this.readResponseFormat(request));
        }
        catch (PlatformQueryExecutionException pqee) {
            graphQLResponse = pqee.getResponse();
            this.graphqlService.incrementFailedQueryStatistics(repository, false);
            isSuccessful = false;
        }
        catch (RuntimeException re) {
            this.graphqlService.incrementFailedQueryStatistics(repository, false);
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Could not evaluate query due to: " + re.getMessage()).withCause((Throwable)re)));
            return;
        }
        try (RpcOutputStream stream = new RpcOutputStream(responseObserver, MESSAGE_SIZE, this.createMessageBuilder());
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            if (graphQLResponse instanceof String) {
                String str = (String)graphQLResponse;
                writer.write(str);
            } else {
                JsonUtils.write((Writer)writer, (Object)graphQLResponse);
            }
        }
        catch (IOException ioe) {
            this.graphqlService.incrementFailedQueryStatistics(repository, false);
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNKNOWN.withDescription("Could not write GraphQL response to caller due to: " + ioe.getMessage()).withCause((Throwable)ioe)));
            return;
        }
        if (isSuccessful) {
            this.graphqlService.incrementSuccessfulQueryStatistics(repository, false);
        }
        GraphQLQueryEvaluatorService.logRequestEnd(repository, schemaId, timer);
        responseObserver.onCompleted();
    }

    private static void logRequest(String repository, String schemaId, GraphQlQueryRequest queryRequest) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(GraphQLQueryEvaluatorService.buildLongMsg(repository, schemaId, Objects.toString(queryRequest)));
        } else {
            LOGGER.info(GraphQLQueryEvaluatorService.buildLongMsg(repository, schemaId, "with operationName: " + queryRequest.getOperationName().orElse("<none>")));
        }
    }

    private static String buildLongMsg(String repo, String schema, String request) {
        if (schema != null) {
            return String.format("[%s/%s] Incoming remote query: %s", repo, schema, request);
        }
        return String.format("[%s] Incoming remote query: %s", repo, request);
    }

    private static void logRequestEnd(String repository, String schemaId, Timer timer) {
        if (schemaId != null) {
            LOGGER.debug("[{}/{}] Query processed in: {} ms.", new Object[]{repository, schemaId, timer.getDuration()});
        } else {
            LOGGER.debug("[{}] Query processed in: {} ms.", (Object)repository, (Object)timer.getDuration());
        }
    }

    public void abortQuery(TrackRecordData data, StreamObserver<BooleanData> responseObserver) {
        try {
            LOGGER.warn("[{}] Aborting query: {}", (Object)data.getRepoId(), (Object)data.getTrackAlias());
            boolean result = (Boolean)MonitoringMBeanUtils.invokeMethodWithMBean((String)data.getRepoId(), (String)"requestStopByAlias", (String)data.getTrackAlias());
            BooleanData booleanBuilder = BooleanData.newBuilder().setResult(result).build();
            responseObserver.onNext((Object)booleanBuilder);
            responseObserver.onCompleted();
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNKNOWN.withCause((Throwable)e)));
        }
    }

    private String readResponseFormat(GraphQLQuery request) {
        return Objects.requireNonNullElse(StringUtils.trimToNull((String)request.getMime()), "application/json");
    }

    @Nullable
    private GraphQlQueryRequest buildRequest(GraphQLQuery request, StreamObserver<Data> responseObserver) {
        try {
            return GraphQlQueryRequest.from((String)request.getQuery(), (Object)StringUtils.trimToNull((String)request.getVariables()), (String)StringUtils.trimToNull((String)request.getOperationName()));
        }
        catch (BadRequestException bre) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription("Invalid GraphQL request: " + bre.getMessage())));
            return null;
        }
    }

    @NotNull
    private Function<byte[], Data> createMessageBuilder() {
        return byteData -> Data.newBuilder().setData((ByteString)new GraphDBByteString(byteData)).build();
    }

    private void setTrackAlias(GraphQLQuery query) {
        if (StringUtils.isNotEmpty((CharSequence)query.getTrackAlias())) {
            GraphDBHTTPContext.setTrackAlias((String)query.getTrackAlias());
        }
    }

    public void onApplicationEvent(PropertyChangedEvent event) {
        if ("semantic.locations.initialized".equals(event.getKey())) {
            this.serverInitialized = true;
        }
    }
}

