/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql;

import com.ontotext.graphdb.graphql.GraphQLModelNotifiable;
import com.ontotext.metamodel.storage.rdf4j.Constants;
import com.ontotext.trree.sdk.ClearInterpreter;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatelessPlugin;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.UpdateInterpreter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class GraphQLPlugin
extends PluginBase
implements ClearInterpreter,
StatelessPlugin,
UpdateInterpreter,
StatementListener {
    public static final String PLUGIN_NAME = "GraphQL";
    private Set<GraphQLModelNotifiable> notifiables = new LinkedHashSet<GraphQLModelNotifiable>();
    private static final IRI SCHEMA_CONTENT = Constants.CONTENT;
    private static final IRI DEFAULT_SCHEMA = Constants.BOUND_SCHEMA;
    private long schemaContent;
    private long defaultSchema;
    private long schemaId;
    private long active;

    public String getName() {
        return PLUGIN_NAME;
    }

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        super.initialize(reason, pluginConnection);
        this.schemaContent = pluginConnection.getEntities().put((Value)SCHEMA_CONTENT, Entities.Scope.DEFAULT);
        this.defaultSchema = pluginConnection.getEntities().put((Value)DEFAULT_SCHEMA, Entities.Scope.DEFAULT);
        this.schemaId = pluginConnection.getEntities().put((Value)Constants.SCHEMA_ID, Entities.Scope.DEFAULT);
        this.active = pluginConnection.getEntities().put((Value)Constants.ACTIVE, Entities.Scope.DEFAULT);
    }

    public void beforeClear(long context, PluginConnection pluginConnection) {
    }

    public void afterClear(long context, PluginConnection pluginConnection) {
        if (context == 0L) {
            this.notifiables.forEach(GraphQLModelNotifiable::clearAll);
        } else {
            String contextString = pluginConnection.getEntities().get(context).stringValue();
            this.notifiables.forEach(notifiable -> notifiable.clear(contextString));
        }
    }

    public void registerForModelUpdates(GraphQLModelNotifiable notifiable) {
        this.notifiables.add(notifiable);
    }

    public void unregisterForModelUpdates(GraphQLModelNotifiable notifiable) {
        this.notifiables.remove(notifiable);
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.defaultSchema, this.active};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (isAddition) {
            return false;
        }
        if (predicate == this.defaultSchema) {
            this.notifiables.forEach(GraphQLModelNotifiable::defaultSchemaRemoved);
        }
        return false;
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        if (predicate == this.schemaContent) {
            String schemaBody = pluginConnection.getEntities().get(object).stringValue();
            this.notifiables.forEach(notifiable -> notifiable.schemaChanged(schemaBody, true));
        }
        if (predicate == this.active) {
            this.notifySchemaActivationChange(subject, object, pluginConnection);
        }
        return false;
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        if (predicate == this.schemaContent) {
            String schemaBody = pluginConnection.getEntities().get(object).stringValue();
            this.notifiables.forEach(notifiable -> notifiable.schemaChanged(schemaBody, false));
        }
        return false;
    }

    public void shutdown(ShutdownReason reason) {
        this.notifiables.forEach(GraphQLModelNotifiable::shutdown);
        this.notifiables.clear();
    }

    private void notifySchemaActivationChange(long subject, long object, PluginConnection pluginConnection) {
        StatementIterator schemaIdIterator = pluginConnection.getStatements().get(subject, this.schemaId, 0L);
        ArrayList<String> somlIds = new ArrayList<String>();
        while (schemaIdIterator.next()) {
            somlIds.add(pluginConnection.getEntities().get(schemaIdIterator.object).stringValue());
        }
        assert (somlIds.size() == 1);
        String somlId = (String)somlIds.getFirst();
        boolean isSchemaActive = Boolean.parseBoolean(pluginConnection.getEntities().get(object).stringValue());
        if (isSchemaActive) {
            this.notifiables.forEach(notifiable -> notifiable.endpointActivated(somlId));
        } else {
            this.notifiables.forEach(notifiable -> notifiable.endpointDeactivated(somlId));
        }
    }
}

