/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.ChildTransformer;
import it.unibz.inf.ontop.iq.transform.impl.CompositeIQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.iq.transformer.ExplicitEqualityTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ArgumentSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ExplicitEqualityTransformerImpl
implements ExplicitEqualityTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final AtomFactory atomFactory;
    private final TermFactory termFactory;
    private final VariableGenerator variableGenerator;
    private final SubstitutionFactory substitutionFactory;
    private final CompositeIQTreeTransformer compositeTransformer;

    @AssistedInject
    public ExplicitEqualityTransformerImpl(@Assisted VariableGenerator variableGenerator, IntermediateQueryFactory iqFactory, AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
        this.termFactory = termFactory;
        this.variableGenerator = variableGenerator;
        this.substitutionFactory = substitutionFactory;
        ImmutableList preTransformers = ImmutableList.of((Object)((Object)new LocalExplicitEqualityEnforcer()));
        ImmutableList postTransformers = ImmutableList.of((Object)((Object)new CnLifter()), (Object)((Object)new FilterChildNormalizer(iqFactory)));
        this.compositeTransformer = new CompositeIQTreeTransformer(preTransformers, postTransformers, iqFactory);
    }

    public IQTree transform(IQTree tree) {
        return this.compositeTransformer.transform(tree);
    }

    private static class ExplicitEqualityTransformerInternalException
    extends OntopInternalBugException {
        ExplicitEqualityTransformerInternalException(String message) {
            super(message);
        }
    }

    class CnLifter
    extends DefaultNonRecursiveIQTreeTransformer {
        CnLifter() {
        }

        public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
            return tree;
        }

        public IQTree transformSlice(IQTree tree, SliceNode rootNode, IQTree child) {
            return tree;
        }

        public IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            ImmutableList<ConstructionNode> idleCns = this.getIdleCns(Stream.of(child));
            return idleCns.isEmpty() ? tree : this.getProjection((ImmutableSet<Variable>)tree.getVariables(), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree(rootNode, this.trimIdleCn(child)));
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList<ConstructionNode> idleCns = this.getIdleCns(children.stream());
            return idleCns.isEmpty() ? tree : this.getProjection((ImmutableSet<Variable>)tree.getVariables(), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, (ImmutableList)children.stream().map(this::trimIdleCn).collect(ImmutableCollectors.toList())));
        }

        protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            ImmutableList<ConstructionNode> idleCns = this.getIdleCns(Stream.of(leftChild, rightChild));
            return idleCns.isEmpty() ? tree : this.getProjection((ImmutableSet<Variable>)tree.getVariables(), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, this.trimIdleCn(leftChild), this.trimIdleCn(rightChild)));
        }

        private ImmutableList<ConstructionNode> getIdleCns(Stream<IQTree> trees) {
            return (ImmutableList)trees.map(this::getIdleCn).flatMap(Optional::stream).collect(ImmutableCollectors.toList());
        }

        private Optional<ConstructionNode> getIdleCn(IQTree tree) {
            return Optional.of(tree.getRootNode()).filter(r -> r instanceof ConstructionNode).map(r -> (ConstructionNode)r).filter(cn -> cn.getSubstitution().isEmpty());
        }

        private IQTree trimIdleCn(IQTree tree) {
            return this.getIdleCn(tree).isPresent() ? ((UnaryIQTree)tree).getChild() : tree;
        }

        private IQTree getProjection(ImmutableSet<Variable> signature, IQTree tree) {
            QueryNode root = tree.getRootNode();
            if (root instanceof ConstructionNode) {
                return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(signature, ((ConstructionNode)root).getSubstitution()), ((UnaryIQTree)tree).getChild());
            }
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(signature), tree);
        }
    }

    class FilterChildNormalizer
    extends DefaultNonRecursiveIQTreeTransformer {
        private final ChildTransformer childTransformer;

        public FilterChildNormalizer(IntermediateQueryFactory iqFactory) {
            this.childTransformer = new ChildTransformer(iqFactory, (IQTreeTransformer)this);
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            Optional<ImmutableExpression> leftChildChildExpression = this.getOptionalChildExpression(leftChild);
            Optional<ImmutableExpression> rightChildExpression = this.getOptionalChildExpression(rightChild);
            if (leftChildChildExpression.isPresent() || rightChildExpression.isPresent()) {
                Optional joinCondition = rootNode.getOptionalFilterCondition();
                Stream<ImmutableExpression> additionalConditions = rightChildExpression.stream();
                BinaryNonCommutativeIQTree leftJoinTree = ExplicitEqualityTransformerImpl.this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)(rightChildExpression.isPresent() ? ExplicitEqualityTransformerImpl.this.iqFactory.createLeftJoinNode(ExplicitEqualityTransformerImpl.this.termFactory.getConjunction(joinCondition, additionalConditions)) : rootNode), this.trimRootFilter(leftChild), this.trimRootFilter(rightChild));
                return leftChildChildExpression.isPresent() ? ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode(leftChildChildExpression.get()), (IQTree)leftJoinTree) : leftJoinTree;
            }
            return tree;
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList filterChildExpressions = (ImmutableList)children.stream().flatMap(c -> this.getOptionalChildExpression((IQTree)c).stream()).collect(ImmutableCollectors.toList());
            if (filterChildExpressions.isEmpty()) {
                return tree;
            }
            Optional joinCondition = rootNode.getOptionalFilterCondition();
            return ExplicitEqualityTransformerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createInnerJoinNode(ExplicitEqualityTransformerImpl.this.termFactory.getConjunction(joinCondition, filterChildExpressions.stream())), (ImmutableList)children.stream().map(this::trimRootFilter).collect(ImmutableCollectors.toList()));
        }

        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            Optional<ImmutableExpression> filterChildExpressions = this.getOptionalChildExpression(child);
            if (filterChildExpressions.isEmpty()) {
                return tree;
            }
            Optional<ImmutableExpression> joinCondition = Optional.of(rootNode.getFilterCondition());
            Stream<ImmutableExpression> additionalConditions = filterChildExpressions.stream();
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode((ImmutableExpression)ExplicitEqualityTransformerImpl.this.termFactory.getConjunction(joinCondition, additionalConditions).get()), this.trimRootFilter(child));
        }

        private Optional<ImmutableExpression> getOptionalChildExpression(IQTree child) {
            return Optional.of(child).map(IQTree::getRootNode).filter(n -> n instanceof FilterNode).map(n -> (FilterNode)n).map(FilterNode::getFilterCondition);
        }

        private IQTree trimRootFilter(IQTree tree) {
            return tree.getRootNode() instanceof FilterNode ? ((UnaryIQTree)tree).getChild() : tree;
        }

        protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            return this.childTransformer.transform(tree);
        }

        protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            return this.childTransformer.transform(tree);
        }

        protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            return this.childTransformer.transform(tree);
        }
    }

    class LocalExplicitEqualityEnforcer
    extends DefaultNonRecursiveIQTreeTransformer {
        LocalExplicitEqualityEnforcer() {
        }

        public IQTree transformIntensionalData(IntensionalDataNode dn) {
            return this.transformIntensionalDataNode(dn);
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dn) {
            return this.transformExtensionalDataNode(dn);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList<InjectiveSubstitution<Variable>> substitutions = this.computeSubstitutions(children);
            if (substitutions.stream().allMatch(Substitution::isEmpty)) {
                return tree;
            }
            ImmutableList<IQTree> updatedChildren = this.updateJoinChildren(substitutions, children);
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(tree.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createInnerJoinNode(Optional.of(this.updateJoinCondition(rootNode.getOptionalFilterCondition(), substitutions))), updatedChildren));
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            ImmutableList children = ImmutableList.of((Object)leftChild, (Object)rightChild);
            ImmutableList<InjectiveSubstitution<Variable>> substitutions = this.computeSubstitutions((ImmutableList<IQTree>)children);
            if (substitutions.stream().allMatch(Substitution::isEmpty)) {
                return tree;
            }
            ImmutableList<IQTree> updatedChildren = this.updateJoinChildren(substitutions, (ImmutableList<IQTree>)children);
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(tree.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createLeftJoinNode(Optional.of(this.updateJoinCondition(rootNode.getOptionalFilterCondition(), substitutions))), (IQTree)updatedChildren.get(0), (IQTree)updatedChildren.get(1)));
        }

        private ImmutableList<InjectiveSubstitution<Variable>> computeSubstitutions(ImmutableList<IQTree> children) {
            if (children.size() < 2) {
                throw new ExplicitEqualityTransformerInternalException("At least 2 children are expected");
            }
            ImmutableSet repeatedVariables = (ImmutableSet)((ImmutableMultiset)children.stream().flatMap(t -> t.getVariables().stream()).collect(ImmutableCollectors.toMultiset())).entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet());
            return (ImmutableList)children.stream().map(t -> (InjectiveSubstitution)Sets.intersection((Set)t.getVariables(), (Set)repeatedVariables).stream().filter(v -> !this.isFirstOcc((Variable)v, children, (IQTree)t)).collect(ExplicitEqualityTransformerImpl.this.substitutionFactory.toFreshRenamingSubstitution(ExplicitEqualityTransformerImpl.this.variableGenerator))).collect(ImmutableCollectors.toList());
        }

        private ImmutableList<IQTree> updateJoinChildren(ImmutableList<InjectiveSubstitution<Variable>> substitutions, ImmutableList<IQTree> children) {
            UnmodifiableIterator it = children.iterator();
            return (ImmutableList)substitutions.stream().map(arg_0 -> this.lambda$updateJoinChildren$4((Iterator)it, arg_0)).collect(ImmutableCollectors.toList());
        }

        private boolean isFirstOcc(Variable variable, ImmutableList<IQTree> children, IQTree tree) {
            return children.stream().filter(t -> t.getVariables().contains((Object)variable)).findFirst().orElseThrow(() -> new MinorOntopInternalBugException("Should be present")) == tree;
        }

        private ImmutableExpression updateJoinCondition(Optional<ImmutableExpression> optionalFilterCondition, ImmutableList<InjectiveSubstitution<Variable>> substitutions) {
            Stream varEqualities = substitutions.stream().map(Substitution::builder).flatMap(b -> b.toStream((x$0, x$1) -> ExplicitEqualityTransformerImpl.this.termFactory.getStrictEquality(x$0, x$1, new ImmutableTerm[0])));
            return (ImmutableExpression)ExplicitEqualityTransformerImpl.this.termFactory.getConjunction(optionalFilterCondition, varEqualities).get();
        }

        private IQTree transformIntensionalDataNode(IntensionalDataNode dn) {
            DataAtom projectionAtom = dn.getProjectionAtom();
            ArgumentSubstitution<VariableOrGroundTerm> replacementVars = this.getArgumentReplacement((ImmutableList<? extends VariableOrGroundTerm>)projectionAtom.getArguments());
            if (replacementVars.isEmpty()) {
                return dn;
            }
            FilterNode filter = ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode(replacementVars.getConjunction(ExplicitEqualityTransformerImpl.this.termFactory, projectionAtom.getArguments()));
            DataAtom atom = ExplicitEqualityTransformerImpl.this.atomFactory.getDataAtom(projectionAtom.getPredicate(), replacementVars.replaceTerms(projectionAtom.getArguments()));
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(dn.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filter, (IQTree)dn.newAtom(atom)));
        }

        private IQTree transformExtensionalDataNode(ExtensionalDataNode dn) {
            ImmutableMap initialArgumentMap = dn.getArgumentMap();
            ArgumentSubstitution<VariableOrGroundTerm> replacementVars = this.getArgumentReplacement((ImmutableMap<Integer, ? extends VariableOrGroundTerm>)initialArgumentMap);
            if (replacementVars.isEmpty()) {
                return dn;
            }
            FilterNode filter = ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode(replacementVars.getConjunction(ExplicitEqualityTransformerImpl.this.termFactory, initialArgumentMap));
            ImmutableMap newArgumentMap = replacementVars.replaceTerms(initialArgumentMap);
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(dn.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filter, (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createExtensionalDataNode(dn.getRelationDefinition(), newArgumentMap)));
        }

        private ArgumentSubstitution<VariableOrGroundTerm> getArgumentReplacement(ImmutableList<? extends VariableOrGroundTerm> argumentList) {
            HashSet vars = new HashSet();
            ImmutableMap m = (ImmutableMap)IntStream.range(0, argumentList.size()).mapToObj(i -> this.getReplacement((VariableOrGroundTerm)argumentList.get(i), vars).stream().map(v -> Maps.immutableEntry((Object)i, (Object)v))).flatMap(e -> e).collect(ImmutableCollectors.toMap());
            return new ArgumentSubstitution(m, Optional::ofNullable);
        }

        private ArgumentSubstitution<VariableOrGroundTerm> getArgumentReplacement(ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap) {
            HashSet vars = new HashSet();
            ImmutableMap m = (ImmutableMap)argumentMap.entrySet().stream().flatMap(e -> this.getReplacement((VariableOrGroundTerm)e.getValue(), vars).stream().map(v -> Maps.immutableEntry((Object)((Integer)e.getKey()), (Object)v))).collect(ImmutableCollectors.toMap());
            return new ArgumentSubstitution(m, Optional::ofNullable);
        }

        private Optional<Variable> getReplacement(VariableOrGroundTerm term, Set<Variable> vars) {
            if (term instanceof GroundTerm) {
                return Optional.of(ExplicitEqualityTransformerImpl.this.variableGenerator.generateNewVariable());
            }
            Variable var = (Variable)term;
            if (vars.contains(var)) {
                return Optional.of(ExplicitEqualityTransformerImpl.this.variableGenerator.generateNewVariableFromVar(var));
            }
            vars.add(var);
            return Optional.empty();
        }

        private /* synthetic */ IQTree lambda$updateJoinChildren$4(Iterator it, InjectiveSubstitution s) {
            return ((IQTree)it.next()).applyDescendingSubstitutionWithoutOptimizing((Substitution)s, ExplicitEqualityTransformerImpl.this.variableGenerator);
        }
    }
}

