/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.AbstractJoinTransferLJTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;

@Singleton
public class CardinalitySensitiveJoinTransferLJOptimizer
implements LeftJoinIQOptimizer {
    private final RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor;
    private final RightProvenanceNormalizer rightProvenanceNormalizer;
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;

    @Inject
    protected CardinalitySensitiveJoinTransferLJOptimizer(RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreSingletons coreSingletons) {
        this.requiredDataNodeExtractor = requiredDataNodeExtractor;
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.variableNullabilityTools = variableNullabilityTools;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        Transformer transformer = new Transformer(() -> ((IQTree)initialTree).getVariableNullability(), query.getVariableGenerator(), this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.coreSingletons, this.variableNullabilityTools);
        IQTree newTree = initialTree.acceptTransformer((IQTreeVisitingTransformer)transformer);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected static class Transformer
    extends AbstractJoinTransferLJTransformer {
        private final TermFactory termFactory;

        protected Transformer(Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, CoreSingletons coreSingletons, JoinOrFilterVariableNullabilityTools variableNullabilityTools) {
            super(variableNullabilitySupplier, variableGenerator, requiredDataNodeExtractor, rightProvenanceNormalizer, variableNullabilityTools, coreSingletons);
            this.termFactory = coreSingletons.getTermFactory();
        }

        @Override
        protected Optional<AbstractJoinTransferLJTransformer.SelectedNode> selectForTransfer(ExtensionalDataNode rightDataNode, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> leftMultimap) {
            RelationDefinition rightRelation = rightDataNode.getRelationDefinition();
            ImmutableMap rightArgumentMap = rightDataNode.getArgumentMap();
            ImmutableList uniqueConstraints = rightRelation.getUniqueConstraints();
            if (!uniqueConstraints.isEmpty()) {
                ImmutableSet sameRelationLeftNodes = (ImmutableSet)Optional.ofNullable(leftMultimap.get((Object)rightRelation)).stream().flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
                Optional<ImmutableList> matchingIndexes = uniqueConstraints.stream().map(uc -> this.matchUniqueConstraint((UniqueConstraint)uc, (ImmutableSet<ExtensionalDataNode>)sameRelationLeftNodes, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap)).filter(Optional::isPresent).map(Optional::get).findAny();
                if (matchingIndexes.isPresent()) {
                    return Optional.of(new AbstractJoinTransferLJTransformer.SelectedNode((ImmutableList<Integer>)matchingIndexes.get(), rightDataNode));
                }
            }
            return leftMultimap.keys().stream().flatMap(leftRelation -> leftRelation.getForeignKeys().stream().filter(fk -> fk.getReferencedRelation().equals(rightRelation)).map(fk -> this.matchForeignKey((ForeignKeyConstraint)fk, (ImmutableCollection<ExtensionalDataNode>)leftMultimap.get(leftRelation), (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap)).filter(Optional::isPresent).map(Optional::get)).findAny().map(indexes -> new AbstractJoinTransferLJTransformer.SelectedNode((ImmutableList<Integer>)indexes, rightDataNode));
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            Supplier<VariableNullability> childVariableNullabilitySupplier = this.computeChildVariableNullabilityFromConstructionParent(tree, rootNode, child);
            return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, t -> this.transformBySearchingWithNewVariableNullabilitySupplier((IQTree)t, childVariableNullabilitySupplier));
        }

        @Override
        protected IQTree transformBySearchingFromScratch(IQTree tree) {
            return this.transformBySearchingWithNewVariableNullabilitySupplier(tree, () -> ((IQTree)tree).getVariableNullability());
        }

        protected IQTree transformBySearchingWithNewVariableNullabilitySupplier(IQTree tree, Supplier<VariableNullability> variableNullabilitySupplier) {
            Transformer newTransformer = new Transformer(variableNullabilitySupplier, this.variableGenerator, this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.coreSingletons, this.variableNullabilityTools);
            return tree.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        }

        @Override
        protected IQTree preTransformLJRightChild(IQTree rightChild, Optional<ImmutableExpression> ljCondition, ImmutableSet<Variable> leftVariables) {
            Supplier<VariableNullability> variableNullabilitySupplier = () -> this.computeRightChildVariableNullability(rightChild, ljCondition);
            Transformer newTransformer = new Transformer(variableNullabilitySupplier, this.variableGenerator, this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.coreSingletons, this.variableNullabilityTools);
            return rightChild.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        }
    }
}

