/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.LookForDistinctOrLimit1TransformerImpl;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.AbstractJoinTransferLJTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Singleton
public class CardinalityInsensitiveJoinTransferLJOptimizer
implements LeftJoinIQOptimizer {
    private final RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor;
    private final RightProvenanceNormalizer rightProvenanceNormalizer;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected CardinalityInsensitiveJoinTransferLJOptimizer(RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreSingletons coreSingletons) {
        this.requiredDataNodeExtractor = requiredDataNodeExtractor;
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.variableNullabilityTools = variableNullabilityTools;
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        LookForDistinctOrLimit1TransformerImpl transformer;
        IQTree initialTree = query.getTree();
        IQTree newTree = initialTree.acceptTransformer((IQTreeVisitingTransformer)(transformer = new LookForDistinctOrLimit1TransformerImpl((childTree, parentTransformer) -> new CardinalityInsensitiveTransformer(parentTransformer, () -> ((IQTree)childTree).getVariableNullability(), query.getVariableGenerator(), this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.variableNullabilityTools, this.coreSingletons), this.coreSingletons)));
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected static class CardinalityInsensitiveTransformer
    extends AbstractJoinTransferLJTransformer {
        private final IQTreeTransformer lookForDistinctTransformer;

        protected CardinalityInsensitiveTransformer(IQTreeTransformer lookForDistinctTransformer, Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreSingletons coreSingletons) {
            super(variableNullabilitySupplier, variableGenerator, requiredDataNodeExtractor, rightProvenanceNormalizer, variableNullabilityTools, coreSingletons);
            this.lookForDistinctTransformer = lookForDistinctTransformer;
        }

        @Override
        protected Optional<AbstractJoinTransferLJTransformer.SelectedNode> selectForTransfer(ExtensionalDataNode rightDataNode, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> leftMultimap) {
            Optional<ImmutableList> matchingIndexes;
            RelationDefinition rightRelation = rightDataNode.getRelationDefinition();
            ImmutableMap rightArgumentMap = rightDataNode.getArgumentMap();
            ImmutableSet sameRelationLeftNodes = (ImmutableSet)Optional.ofNullable(leftMultimap.get((Object)rightRelation)).stream().flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
            if (sameRelationLeftNodes.isEmpty()) {
                return Optional.empty();
            }
            ImmutableList functionalDependencies = rightRelation.getOtherFunctionalDependencies();
            if (!functionalDependencies.isEmpty() && (matchingIndexes = functionalDependencies.stream().map(fd -> this.matchFunctionalDependency((FunctionalDependency)fd, (ImmutableSet<ExtensionalDataNode>)sameRelationLeftNodes, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap)).filter(Optional::isPresent).map(Optional::get).findAny()).isPresent()) {
                return Optional.of(new AbstractJoinTransferLJTransformer.SelectedNode((ImmutableList<Integer>)matchingIndexes.get(), rightDataNode));
            }
            return this.matchIndexes((ImmutableSet<ExtensionalDataNode>)sameRelationLeftNodes, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap, (ImmutableList<Integer>)ImmutableList.copyOf((Collection)rightArgumentMap.keySet())).map(idx -> new AbstractJoinTransferLJTransformer.SelectedNode((ImmutableList<Integer>)idx, rightDataNode));
        }

        @Override
        protected boolean preventRecursiveOptimizationOnRightChild() {
            return true;
        }

        @Override
        protected IQTree transformBySearchingFromScratch(IQTree tree) {
            return this.lookForDistinctTransformer.transform(tree);
        }

        protected IQTree transformBySearchingFromScratchFromDistinctTree(IQTree tree) {
            return this.transformBySearchingFromScratchFromDistinctTree(tree, () -> ((IQTree)tree).getVariableNullability());
        }

        protected IQTree transformBySearchingFromScratchFromDistinctTree(IQTree tree, Supplier<VariableNullability> variableNullabilitySupplier) {
            CardinalityInsensitiveTransformer newTransformer = new CardinalityInsensitiveTransformer(this.lookForDistinctTransformer, variableNullabilitySupplier, this.variableGenerator, this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.variableNullabilityTools, this.coreSingletons);
            return tree.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        }

        @Override
        protected IQTree preTransformLJRightChild(IQTree rightChild, Optional<ImmutableExpression> ljCondition, ImmutableSet<Variable> leftVariables) {
            Stream<ImmutableExpression> isNotNullFromImplicitEqualities = Sets.intersection(leftVariables, (Set)rightChild.getVariables()).stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0));
            Optional condition = this.termFactory.getConjunction(Stream.concat(ljCondition.stream(), isNotNullFromImplicitEqualities));
            return this.transformBySearchingFromScratchFromDistinctTree(rightChild, () -> condition.map(c -> this.variableNullabilityTools.updateWithFilter(c, rightChild.getVariableNullability().getNullableGroups(), rightChild.getVariables())).orElseGet(() -> ((IQTree)rightChild).getVariableNullability()));
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            Supplier<VariableNullability> childVariableNullabilitySupplier = this.computeChildVariableNullabilityFromConstructionParent(tree, rootNode, child);
            return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, t -> this.transformBySearchingFromScratchFromDistinctTree((IQTree)t, childVariableNullabilitySupplier));
        }

        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
            return this.transformNaryCommutativeNode(tree, (NaryOperatorNode)rootNode, children, this::transformBySearchingFromScratchFromDistinctTree);
        }
    }
}

