/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.TermTypeTermLifter;
import it.unibz.inf.ontop.iq.transformer.TermTypeTermLiftTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

@Singleton
public class TermTypeTermLifterImpl
implements TermTypeTermLifter {
    private final OptimizerFactory transformerFactory;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    @Inject
    private TermTypeTermLifterImpl(OptimizerFactory transformerFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        this.transformerFactory = transformerFactory;
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        TermTypeTermLiftTransformer transformer = this.transformerFactory.createRDFTermTypeConstantTransformer(query.getVariableGenerator());
        IQTree transformedTree = transformer.transform(query.getTree());
        IQTree newTree = this.makeRDFTermTypeFunctionSymbolsSimplifiable(transformedTree);
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    private IQTree makeRDFTermTypeFunctionSymbolsSimplifiable(IQTree tree) {
        return Optional.of(tree.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(ConstructionNode::getSubstitution).map(s -> s.transform(this::makeRDFTermTypeFunctionSymbolsSimplifiable)).map(s -> this.iqFactory.createConstructionNode(tree.getVariables(), s)).map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, ((UnaryIQTree)tree).getChild())).orElse(tree);
    }

    private ImmutableTerm makeRDFTermTypeFunctionSymbolsSimplifiable(ImmutableTerm immutableTerm) {
        if (immutableTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)immutableTerm;
            ImmutableList newTerms = (ImmutableList)functionalTerm.getTerms().stream().map(this::makeRDFTermTypeFunctionSymbolsSimplifiable).collect(ImmutableCollectors.toList());
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            FunctionSymbol newFunctionSymbol = functionSymbol instanceof RDFTermTypeFunctionSymbol ? ((RDFTermTypeFunctionSymbol)functionSymbol).getSimplifiableVariant() : functionSymbol;
            return this.termFactory.getImmutableFunctionalTerm(newFunctionSymbol, newTerms);
        }
        return immutableTerm;
    }
}

