/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.OrderBySimplifier;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transformer.impl.RDFTypeDependentSimplifyingTransformer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class OrderBySimplifierImpl
implements OrderBySimplifier {
    private final OptimizationSingletons optimizationSingletons;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected OrderBySimplifierImpl(OptimizationSingletons optimizationSingletons, IntermediateQueryFactory iqFactory) {
        this.optimizationSingletons = optimizationSingletons;
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTreeTransformer transformer = this.createTransformer(query.getVariableGenerator());
        IQTree newTree = transformer.transform(query.getTree());
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected IQTreeTransformer createTransformer(VariableGenerator variableGenerator) {
        return new OrderBySimplifyingTransformer(variableGenerator, this.optimizationSingletons);
    }

    protected static class ComparatorSimplification {
        protected final OrderByNode.OrderComparator newComparator;
        protected final Optional<DefinitionPushDownRequest> request;

        protected ComparatorSimplification(OrderByNode.OrderComparator newComparator, DefinitionPushDownRequest request) {
            this.newComparator = newComparator;
            this.request = Optional.of(request);
        }

        protected ComparatorSimplification(OrderByNode.OrderComparator newComparator) {
            this.newComparator = newComparator;
            this.request = Optional.empty();
        }
    }

    protected static class OrderBySimplifyingTransformer
    extends RDFTypeDependentSimplifyingTransformer {
        protected final VariableGenerator variableGenerator;
        protected final TermFactory termFactory;
        protected final TypeFactory typeFactory;
        protected final ImmutableSet<RDFDatatype> nonLexicallyOrderedDatatypes;

        protected OrderBySimplifyingTransformer(VariableGenerator variableGenerator, OptimizationSingletons optimizationSingletons) {
            super(optimizationSingletons);
            this.variableGenerator = variableGenerator;
            CoreSingletons coreSingletons = optimizationSingletons.getCoreSingletons();
            this.termFactory = coreSingletons.getTermFactory();
            this.typeFactory = coreSingletons.getTypeFactory();
            this.nonLexicallyOrderedDatatypes = ImmutableSet.of((Object)this.typeFactory.getAbstractOntopNumericDatatype(), (Object)this.typeFactory.getXsdBooleanDatatype(), (Object)this.typeFactory.getXsdDatetimeDatatype());
        }

        public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
            ImmutableList simplifications = (ImmutableList)rootNode.getComparators().stream().flatMap(c -> this.simplifyComparator((OrderByNode.OrderComparator)c, child)).collect(ImmutableCollectors.toList());
            ImmutableList newConditions = (ImmutableList)simplifications.stream().map(s -> s.newComparator).collect(ImmutableCollectors.toList());
            Stream<DefinitionPushDownRequest> definitionsToPushDown = simplifications.stream().map(s -> s.request).filter(Optional::isPresent).map(Optional::get);
            if (newConditions.isEmpty()) {
                return child;
            }
            OrderByNode newNode = this.iqFactory.createOrderByNode(newConditions);
            IQTree pushDownChildTree = this.pushDownDefinitions(child, definitionsToPushDown);
            UnaryIQTree orderByTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newNode, pushDownChildTree.acceptTransformer((IQTreeVisitingTransformer)this));
            ImmutableSet childVariables = child.getVariables();
            return pushDownChildTree.getVariables().equals((Object)childVariables) ? orderByTree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(childVariables), (IQTree)orderByTree);
        }

        protected Stream<ComparatorSimplification> simplifyComparator(OrderByNode.OrderComparator comparator, IQTree child) {
            ImmutableTerm term = comparator.getTerm().simplify();
            if (term instanceof Constant) {
                return Stream.empty();
            }
            if (term instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term).getFunctionSymbol() instanceof RDFTermFunctionSymbol) {
                ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
                boolean isAscending = comparator.isAscending();
                return this.simplifyRDFTerm(functionalTerm.getTerm(0), this.unwrapIfElseNull(functionalTerm.getTerm(1)), child, isAscending);
            }
            return Stream.of(new ComparatorSimplification(comparator));
        }

        protected Stream<ComparatorSimplification> simplifyRDFTerm(ImmutableTerm lexicalTerm, ImmutableTerm rdfTypeTerm, IQTree childTree, boolean isAscending) {
            Optional<ImmutableSet<RDFTermType>> possibleTypes = this.extractPossibleTypes(rdfTypeTerm, childTree);
            if (possibleTypes.isPresent() && possibleTypes.get().size() == 1) {
                RDFTermType possibleType = (RDFTermType)possibleTypes.get().iterator().next();
                return lexicalTerm.isGround() ? Stream.empty() : Stream.of(this.computeDBTerm(lexicalTerm, possibleType, childTree)).flatMap(Optional::stream).map(t -> this.iqFactory.createOrderComparator(t, isAscending)).map(ComparatorSimplification::new);
            }
            return possibleTypes.map(types -> this.computeSimplifications(lexicalTerm, rdfTypeTerm, (ImmutableSet<RDFTermType>)types, childTree, isAscending)).orElseGet(() -> Stream.of(new ComparatorSimplification(this.iqFactory.createOrderComparator((NonGroundTerm)this.termFactory.getRDFFunctionalTerm(lexicalTerm, rdfTypeTerm), isAscending))));
        }

        protected Optional<NonGroundTerm> computeDBTerm(ImmutableTerm lexicalTerm, RDFTermType rdfType, IQTree childTree) {
            ImmutableTerm orderTerm = this.termFactory.getConversionFromRDFLexical2DB(lexicalTerm, rdfType).simplify(childTree.getVariableNullability());
            return orderTerm.isGround() ? Optional.empty() : Optional.of((NonGroundTerm)orderTerm);
        }

        private Stream<ComparatorSimplification> computeSimplifications(ImmutableTerm lexicalTerm, ImmutableTerm rdfTypeTerm, ImmutableSet<RDFTermType> possibleTypes, IQTree childTree, boolean isAscending) {
            Function<RDFTermType, Optional> fct = t -> this.computeSimplification(lexicalTerm, rdfTypeTerm, possibleTypes, (RDFTermType)t, childTree, isAscending);
            return Stream.of(fct.apply((RDFTermType)this.typeFactory.getXsdDatetimeDatatype()), fct.apply((RDFTermType)this.typeFactory.getXsdBooleanDatatype()), this.computeSimplification(lexicalTerm, rdfTypeTerm, possibleTypes, (RDFTermType)this.typeFactory.getAbstractOntopNumericDatatype(), (RDFTermType)this.typeFactory.getXsdDoubleDatatype(), childTree, isAscending), this.computeOtherLiteralSimplification(lexicalTerm, rdfTypeTerm, possibleTypes, childTree, isAscending), fct.apply((RDFTermType)this.typeFactory.getIRITermType()), fct.apply((RDFTermType)this.typeFactory.getBlankNodeType())).filter(Optional::isPresent).map(Optional::get);
        }

        private Optional<ComparatorSimplification> computeSimplification(ImmutableTerm lexicalTerm, ImmutableTerm rdfTypeTerm, ImmutableSet<RDFTermType> possibleTypes, RDFTermType type, IQTree childTree, boolean isAscending) {
            return this.computeSimplification(lexicalTerm, rdfTypeTerm, possibleTypes, type, type, childTree, isAscending);
        }

        private Optional<ComparatorSimplification> computeSimplification(ImmutableTerm lexicalTerm, ImmutableTerm rdfTypeTerm, ImmutableSet<RDFTermType> possibleTypes, RDFTermType type, RDFTermType referenceCastType, IQTree childTree, boolean isAscending) {
            return possibleTypes.stream().filter(t -> t.isA((TermType)type)).findAny().flatMap(t -> this.computeSimplificationForSelectedType(lexicalTerm, referenceCastType, childTree, isAscending, this.termFactory.getIsAExpression(rdfTypeTerm, type)));
        }

        private Optional<ComparatorSimplification> computeSimplificationForSelectedType(ImmutableTerm lexicalTerm, RDFTermType referenceCastType, IQTree childTree, boolean isAscending, ImmutableExpression condition) {
            Variable v = this.variableGenerator.generateNewVariable();
            return this.computeDBTerm(lexicalTerm, referenceCastType, childTree).map(t -> DefinitionPushDownRequest.create((Variable)v, (ImmutableTerm)t, (ImmutableExpression)condition)).map(r -> new ComparatorSimplification(this.iqFactory.createOrderComparator((NonGroundTerm)v, isAscending), (DefinitionPushDownRequest)r));
        }

        private Optional<ComparatorSimplification> computeOtherLiteralSimplification(ImmutableTerm lexicalTerm, ImmutableTerm rdfTypeTerm, ImmutableSet<RDFTermType> possibleTypes, IQTree childTree, boolean isAscending) {
            RDFDatatype rdfsLiteral = this.typeFactory.getAbstractRDFSLiteral();
            return possibleTypes.stream().filter(t -> t.isA((TermType)rdfsLiteral)).filter(t -> this.nonLexicallyOrderedDatatypes.stream().noneMatch(arg_0 -> ((RDFTermType)t).isA(arg_0))).findAny().flatMap(t -> this.termFactory.getConjunction(Stream.concat(Stream.of(this.termFactory.getIsAExpression(rdfTypeTerm, (RDFTermType)rdfsLiteral)), this.nonLexicallyOrderedDatatypes.stream().map(st -> this.termFactory.getIsAExpression(rdfTypeTerm, (RDFTermType)st)).map(e -> e.negate(this.termFactory))))).flatMap(c -> this.computeSimplificationForSelectedType(lexicalTerm, (RDFTermType)this.typeFactory.getXsdStringDatatype(), childTree, isAscending, (ImmutableExpression)c));
        }
    }
}

