/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.optimizer.FilterLifter;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class FilterLifterImpl
implements FilterLifter {
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    @Inject
    private FilterLifterImpl(IntermediateQueryFactory iqFactory, TermFactory termFactory) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        TreeTransformer treeTransformer = new TreeTransformer(this.iqFactory);
        return this.iqFactory.createIQ(query.getProjectionAtom(), query.getTree().acceptTransformer((IQTreeVisitingTransformer)treeTransformer));
    }

    private Optional<FilterNode> getOptionalRootFilter(IQTree tree) {
        return Optional.of(tree.getRootNode()).filter(n -> n instanceof FilterNode).map(n -> (FilterNode)n);
    }

    private IQTree discardOptionalRootFilter(IQTree tree) {
        return tree.getRootNode() instanceof FilterNode ? (IQTree)tree.getChildren().get(0) : tree;
    }

    private Optional<ImmutableExpression> getChildrenExpression(ImmutableList<IQTree> children) {
        return this.termFactory.getConjunction(children.stream().map(t -> this.getOptionalRootFilter((IQTree)t)).flatMap(Optional::stream).map(FilterNode::getFilterCondition));
    }

    private ImmutableList<IQTree> discardOptionalRootFilterForList(ImmutableList<IQTree> children) {
        return (ImmutableList)children.stream().map(t -> this.discardOptionalRootFilter((IQTree)t)).collect(ImmutableCollectors.toList());
    }

    private class TreeTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        TreeTransformer(IntermediateQueryFactory iqFactory) {
            super(iqFactory);
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode cn, IQTree child) {
            child = child.acceptTransformer((IQTreeVisitingTransformer)this);
            if (tree.getRootNode().equals(cn)) {
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)cn, child);
            }
            Optional<FilterNode> rootFilter = FilterLifterImpl.this.getOptionalRootFilter(child);
            if (rootFilter.isPresent()) {
                FilterNode filter = rootFilter.get();
                ImmutableSet projectedVars = Sets.union((Set)filter.getFilterCondition().getVariables(), (Set)cn.getVariables()).immutableCopy();
                ConstructionNode updatedCn = this.iqFactory.createConstructionNode(projectedVars, cn.getSubstitution());
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filter, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)updatedCn, FilterLifterImpl.this.discardOptionalRootFilter(child)));
            }
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)cn, child);
        }

        public IQTree transformFilter(IQTree tree, FilterNode filter, IQTree child) {
            Optional<FilterNode> rootFilter = FilterLifterImpl.this.getOptionalRootFilter(child = child.acceptTransformer((IQTreeVisitingTransformer)this));
            if (rootFilter.isPresent()) {
                filter = this.iqFactory.createFilterNode(FilterLifterImpl.this.termFactory.getConjunction(filter.getFilterCondition(), new ImmutableExpression[]{rootFilter.get().getFilterCondition()}));
            }
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filter, FilterLifterImpl.this.discardOptionalRootFilter(child));
        }

        public IQTree transformFlatten(IQTree tree, FlattenNode fn, IQTree child) {
            Optional<FilterNode> rootFilter = FilterLifterImpl.this.getOptionalRootFilter(child = child.acceptTransformer((IQTreeVisitingTransformer)this));
            if (rootFilter.isPresent()) {
                FilterNode filter = rootFilter.get();
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filter, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)fn, FilterLifterImpl.this.discardOptionalRootFilter(child)));
            }
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)fn, child);
        }

        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
            Optional<ImmutableExpression> childrenExpression = FilterLifterImpl.this.getChildrenExpression(children = (ImmutableList<IQTree>)children.stream().map(c -> c.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList()));
            if (childrenExpression.isPresent()) {
                children = FilterLifterImpl.this.discardOptionalRootFilterForList(children);
            }
            NaryIQTree unionSubtree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(((IQTree)children.get(0)).getVariables()), children);
            return childrenExpression.map(e -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(e), (IQTree)unionSubtree)).orElse((IQTree)unionSubtree);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode joinNode, ImmutableList<IQTree> children) {
            children = (ImmutableList<IQTree>)children.stream().map(c -> c.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            Optional<ImmutableExpression> childrenExpression = FilterLifterImpl.this.getChildrenExpression(children);
            Optional explicitJoinCondition = joinNode.getOptionalFilterCondition();
            if (childrenExpression.isPresent()) {
                children = FilterLifterImpl.this.discardOptionalRootFilterForList(children);
            }
            NaryIQTree joinSubtree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), children);
            ImmutableList conjuncts = (ImmutableList)Stream.of(childrenExpression, explicitJoinCondition).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
            return conjuncts.isEmpty() ? joinSubtree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(FilterLifterImpl.this.termFactory.getConjunction(conjuncts)), (IQTree)joinSubtree);
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            leftChild = leftChild.acceptTransformer((IQTreeVisitingTransformer)this);
            rightChild = rightChild.acceptTransformer((IQTreeVisitingTransformer)this);
            Optional<FilterNode> optionalLeftFilter = FilterLifterImpl.this.getOptionalRootFilter(leftChild);
            Optional<FilterNode> optionalRightFilter = FilterLifterImpl.this.getOptionalRootFilter(rightChild);
            rightChild = FilterLifterImpl.this.discardOptionalRootFilter(rightChild);
            leftChild = FilterLifterImpl.this.discardOptionalRootFilter(leftChild);
            LeftJoinNode updatedLJ = optionalRightFilter.map(f -> FilterLifterImpl.this.termFactory.getConjunction(rootNode.getOptionalFilterCondition(), Stream.of(f.getFilterCondition()))).map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createLeftJoinNode(arg_0)).orElse(rootNode);
            BinaryNonCommutativeIQTree lJSubtree = this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)updatedLJ, leftChild, rightChild);
            return optionalLeftFilter.map(f -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)f, (IQTree)lJSubtree)).orElse((IQTree)lJSubtree);
        }
    }
}

