/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.optimizer.BooleanExpressionPushDownOptimizer;
import it.unibz.inf.ontop.iq.optimizer.FilterLifter;
import it.unibz.inf.ontop.iq.optimizer.FlattenLifter;
import it.unibz.inf.ontop.iq.optimizer.IQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.BasicFlattenLifter;

public class CompositeFlattenLifter
implements FlattenLifter {
    private final ImmutableList<IQOptimizer> optimizers;

    @Inject
    private CompositeFlattenLifter(FilterLifter filterLifter, BasicFlattenLifter flattenLifter, BooleanExpressionPushDownOptimizer pushDownOptimizer) {
        this.optimizers = ImmutableList.of((Object)filterLifter, (Object)flattenLifter, (Object)pushDownOptimizer);
    }

    @Override
    public IQ optimize(IQ query) {
        return this.optimizers.stream().reduce(query, (q, o) -> o.optimize((IQ)q), (q1, q2) -> {
            throw new MinorOntopInternalBugException("parallel query optimization not applicable");
        });
    }
}

