/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.AggregationSimplifier;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transformer.impl.RDFTypeDependentSimplifyingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import javax.inject.Inject;

public class AggregationSimplifierImpl
implements AggregationSimplifier {
    private final IntermediateQueryFactory iqFactory;
    private final OptimizationSingletons optimizationSingletons;
    private final IQTreeTools iqTreeTools;

    @Inject
    private AggregationSimplifierImpl(IntermediateQueryFactory iqFactory, OptimizationSingletons optimizationSingletons, IQTreeTools iqTreeTools) {
        this.iqFactory = iqFactory;
        this.optimizationSingletons = optimizationSingletons;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public IQ optimize(IQ query) {
        VariableGenerator variableGenerator = query.getVariableGenerator();
        IQTreeTransformer transformer = this.createTransformer(variableGenerator);
        IQTree newTree = transformer.transform(query.getTree()).normalizeForOptimization(variableGenerator);
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected IQTreeTransformer createTransformer(VariableGenerator variableGenerator) {
        return new AggregationSimplifyingTransformer(variableGenerator, this.optimizationSingletons, this.iqTreeTools);
    }

    protected static class AggregationSimplifyingTransformer
    extends RDFTypeDependentSimplifyingTransformer {
        private final VariableGenerator variableGenerator;
        private final TermFactory termFactory;
        private final IQTreeTools iqTreeTools;

        protected AggregationSimplifyingTransformer(VariableGenerator variableGenerator, OptimizationSingletons optimizationSingletons, IQTreeTools iqTreeTools) {
            super(optimizationSingletons);
            this.variableGenerator = variableGenerator;
            CoreSingletons coreSingletons = optimizationSingletons.getCoreSingletons();
            this.termFactory = coreSingletons.getTermFactory();
            this.iqTreeTools = iqTreeTools;
        }

        public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
            IQTree normalizedChild = child.acceptTransformer((IQTreeVisitingTransformer)this).normalizeForOptimization(this.variableGenerator);
            QueryNode newChildRoot = normalizedChild.getRootNode();
            if (newChildRoot instanceof ConstructionNode && !child.getRootNode().equals(newChildRoot)) {
                return this.transform(this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, normalizedChild).normalizeForOptimization(this.variableGenerator));
            }
            Substitution initialSubstitution = rootNode.getSubstitution();
            boolean hasGroupBy = !rootNode.getGroupingVariables().isEmpty();
            ImmutableMap simplificationMap = initialSubstitution.builder().toMapIgnoreOptional((v, t) -> this.simplifyAggregationFunctionalTerm((ImmutableFunctionalTerm)t, normalizedChild, hasGroupBy));
            Substitution newAggregationSubstitution = initialSubstitution.builder().flatTransform(arg_0 -> ((ImmutableMap)simplificationMap).get(arg_0), d -> d.getDecomposition().getSubstitution()).build();
            AggregationNode newNode = this.iqFactory.createAggregationNode(rootNode.getGroupingVariables(), newAggregationSubstitution);
            IQTree pushDownChildTree = this.pushDownDefinitions(normalizedChild, simplificationMap.values().stream().flatMap(s -> s.getPushDownRequests().stream()));
            UnaryIQTree newAggregationTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newNode, pushDownChildTree);
            Substitution parentSubstitution = initialSubstitution.builder().transformOrRemove(arg_0 -> ((ImmutableMap)simplificationMap).get(arg_0), d -> d.getDecomposition().getLiftableTerm()).build();
            return this.iqTreeTools.createConstructionNodeTreeIfNontrivial((IQTree)newAggregationTree, parentSubstitution, () -> ((AggregationNode)rootNode).getVariables());
        }

        protected Optional<SPARQLAggregationFunctionSymbol.AggregationSimplification> simplifyAggregationFunctionalTerm(ImmutableFunctionalTerm aggregationFunctionalTerm, IQTree child, boolean hasGroupBy) {
            FunctionSymbol functionSymbol = aggregationFunctionalTerm.getFunctionSymbol();
            if (functionSymbol instanceof SPARQLAggregationFunctionSymbol) {
                SPARQLAggregationFunctionSymbol aggregationFunctionSymbol = (SPARQLAggregationFunctionSymbol)functionSymbol;
                ImmutableList subTerms = aggregationFunctionalTerm.getTerms();
                if (subTerms.stream().allMatch(t -> this.isRDFFunctionalTerm((ImmutableTerm)t) || t instanceof RDFConstant)) {
                    ImmutableList extractedRDFTypes = (ImmutableList)aggregationFunctionalTerm.getTerms().stream().map(this::extractRDFTermTypeTerm).map(this::unwrapIfElseNull).map(t -> this.extractPossibleTypes((ImmutableTerm)t, child)).collect(ImmutableCollectors.toList());
                    if (extractedRDFTypes.stream().anyMatch(t -> !t.isPresent())) {
                        return Optional.empty();
                    }
                    ImmutableList possibleRDFTypes = (ImmutableList)extractedRDFTypes.stream().map(Optional::get).collect(ImmutableCollectors.toList());
                    return aggregationFunctionSymbol.decomposeIntoDBAggregation(subTerms, possibleRDFTypes, hasGroupBy, child.getVariableNullability(), this.variableGenerator, this.termFactory);
                }
            }
            return Optional.empty();
        }

        protected boolean isRDFFunctionalTerm(ImmutableTerm term) {
            return term instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term).getFunctionSymbol() instanceof RDFTermFunctionSymbol;
        }

        protected ImmutableTerm extractRDFTermTypeTerm(ImmutableTerm rdfTerm) {
            if (this.isRDFFunctionalTerm(rdfTerm)) {
                return ((ImmutableFunctionalTerm)rdfTerm).getTerm(1);
            }
            if (rdfTerm instanceof RDFConstant) {
                return this.termFactory.getRDFTermTypeConstant(((RDFConstant)rdfTerm).getType());
            }
            if (rdfTerm.isNull()) {
                return this.termFactory.getNullConstant();
            }
            throw new IllegalArgumentException("Was expecting a isRDFFunctionalTerm or an RDFConstant or NULL");
        }
    }
}

