/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractBelowDistinctTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractBelowDistinctInnerJoinTransformer
extends AbstractBelowDistinctTransformer {
    protected final IntermediateQueryFactory iqFactory;
    protected final TermFactory termFactory;

    protected AbstractBelowDistinctInnerJoinTransformer(IQTreeTransformer lookForDistinctTransformer, CoreSingletons coreSingletons) {
        super(lookForDistinctTransformer, coreSingletons);
        this.iqFactory = coreSingletons.getIQFactory();
        this.termFactory = coreSingletons.getTermFactory();
    }

    @Override
    protected Optional<IQTree> furtherSimplifyInnerJoinChildren(Optional<ImmutableExpression> optionalFilterCondition, ImmutableList<IQTree> partiallySimplifiedChildren) {
        ArrayList currentChildren = Lists.newArrayList(partiallySimplifiedChildren);
        IntStream.range(0, partiallySimplifiedChildren.size()).boxed().filter(i -> this.isDetectedAsRedundant((IQTree)currentChildren.get((int)i), IntStream.range(0, partiallySimplifiedChildren.size()).filter(j -> j != i).mapToObj(currentChildren::get))).forEach(i -> currentChildren.set((int)i, this.iqFactory.createTrueNode()));
        ImmutableSet variablesToFilterNulls = (ImmutableSet)IntStream.range(0, partiallySimplifiedChildren.size()).filter(i -> ((IQTree)currentChildren.get(i)).getRootNode() instanceof TrueNode).mapToObj(i -> ((IQTree)partiallySimplifiedChildren.get(i)).getVariables()).flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
        Optional expression = this.termFactory.getConjunction(optionalFilterCondition, variablesToFilterNulls.stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)));
        InnerJoinNode innerJoinNode = expression.map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createInnerJoinNode(arg_0)).orElseGet(() -> ((IntermediateQueryFactory)this.iqFactory).createInnerJoinNode());
        return Optional.of(this.iqFactory.createNaryIQTree((NaryOperatorNode)innerJoinNode, ImmutableList.copyOf((Collection)currentChildren)));
    }

    protected abstract boolean isDetectedAsRedundant(IQTree var1, Stream<IQTree> var2);

    protected boolean isDetectedAsRedundant(ExtensionalDataNode dataNode, ExtensionalDataNode otherDataNode) {
        if (!dataNode.getRelationDefinition().equals(otherDataNode.getRelationDefinition())) {
            return false;
        }
        ImmutableMap argumentMap = dataNode.getArgumentMap();
        ImmutableMap otherArgumentMap = otherDataNode.getArgumentMap();
        ImmutableSet firstIndexes = argumentMap.keySet();
        ImmutableSet otherIndexes = otherArgumentMap.keySet();
        Sets.SetView allIndexes = Sets.union((Set)firstIndexes, (Set)otherIndexes);
        Sets.SetView commonIndexes = Sets.intersection((Set)firstIndexes, (Set)otherIndexes);
        return allIndexes.stream().filter(i -> !commonIndexes.contains(i) || !((VariableOrGroundTerm)argumentMap.get(i)).equals(otherArgumentMap.get(i))).noneMatch(arg_0 -> ((ImmutableMap)argumentMap).containsKey(arg_0));
    }
}

