/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.lens.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.lens.LensUnfolder;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.impl.ExtensionalDataNodeImpl;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;

public class LensUnfolderImpl
implements LensUnfolder {
    protected final CoreSingletons coreSingletons;
    protected final IntermediateQueryFactory iqFactory;

    @Inject
    protected LensUnfolderImpl(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        int maxLevel = this.extractMaxLevel(initialTree);
        if (maxLevel < 1) {
            return query;
        }
        IQTree newTree = this.transformTree(initialTree, query.getVariableGenerator(), maxLevel);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected IQTree transformTree(IQTree tree, VariableGenerator variableGenerator, int maxLevel) {
        return new MaxLevelLensUnfoldingTransformer(maxLevel, variableGenerator, this.coreSingletons).transform(tree);
    }

    private int extractMaxLevel(IQTree tree) {
        if (tree.getRootNode() instanceof ExtensionalDataNode) {
            RelationDefinition relationDefinition = ((ExtensionalDataNode)tree.getRootNode()).getRelationDefinition();
            return relationDefinition instanceof Lens ? ((Lens)relationDefinition).getLevel() : 0;
        }
        return tree.getChildren().stream().reduce(0, (l, c) -> Math.max(l, this.extractMaxLevel((IQTree)c)), Math::max);
    }

    protected static class MaxLevelLensUnfoldingTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        protected final int maxLevel;
        protected final VariableGenerator variableGenerator;
        protected final SubstitutionFactory substitutionFactory;
        protected final QueryTransformerFactory transformerFactory;

        protected MaxLevelLensUnfoldingTransformer(int maxLevel, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
            super(coreSingletons);
            this.maxLevel = maxLevel;
            this.variableGenerator = variableGenerator;
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
            this.transformerFactory = coreSingletons.getQueryTransformerFactory();
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            RelationDefinition relationDefinition = dataNode.getRelationDefinition();
            if (relationDefinition instanceof Lens) {
                Lens lens = (Lens)relationDefinition;
                return lens.getLevel() < this.maxLevel ? dataNode : this.merge(dataNode, lens.getIQ());
            }
            return dataNode;
        }

        protected IQTree merge(ExtensionalDataNode dataNode, IQ definition) {
            return ExtensionalDataNodeImpl.merge((ExtensionalDataNode)dataNode, (IQ)definition, (VariableGenerator)this.variableGenerator, (SubstitutionFactory)this.substitutionFactory, (QueryTransformerFactory)this.transformerFactory, (IntermediateQueryFactory)this.iqFactory);
        }
    }
}

