/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clusterproxy;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.http.DefaultRequestFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;

public class EmbeddedProxyUriRouter
extends DefaultRequestFilter {
    private static final EmbeddedProxyUriRouter INSTANCE = new EmbeddedProxyUriRouter();
    public static final String PROXY_ENABLED = "graphdb.cluster.proxy.enabled";
    private static final Set<String> IDEMPOTENT_REQUESTS = Set.of("TRACE", "OPTIONS", "HEAD");
    private static final int REST_REPO_LENGTH = "/rest/repositories".length();
    private Boolean proxyDisabled;

    public static EmbeddedProxyUriRouter getInstance() {
        return INSTANCE;
    }

    public boolean canHandleByFollower(HttpServletRequest servletRequest) {
        if (super.canHandleByFollower(servletRequest)) {
            return true;
        }
        if (this.isProxyDisabled()) {
            return true;
        }
        if (IDEMPOTENT_REQUESTS.contains(servletRequest.getMethod())) {
            return true;
        }
        if (this.isTransactionRequest(servletRequest)) {
            return false;
        }
        return this.sendToFollower(servletRequest);
    }

    private boolean isTransactionRequest(HttpServletRequest servletRequest) {
        return servletRequest.getMethod().equalsIgnoreCase("POST") && servletRequest.getRequestURI().startsWith("/repositories/") && servletRequest.getRequestURI().endsWith("/transactions");
    }

    private boolean sendToFollower(HttpServletRequest servletRequest) {
        String requestURI = servletRequest.getRequestURI();
        String method = servletRequest.getMethod();
        return !(requestURI.startsWith("/repositories") && !this.isHealthEndpoint(requestURI) || this.isRepositoryRequestForLeader(requestURI, method) || requestURI.startsWith("/rest/cluster/config/node") || "PATCH".equalsIgnoreCase(method) && requestURI.startsWith("/rest/cluster/httpConfig") || requestURI.startsWith("/rest/data/import/") || requestURI.startsWith("/rest/autocomplete") || requestURI.startsWith("/rest/recovery") || requestURI.startsWith("/rest/rdfrank") || requestURI.startsWith("/rest/sql-views") || requestURI.startsWith("/rest/cluster/truncate-log") || requestURI.endsWith("/acl") || requestURI.startsWith("/rest/monitor/backup") || requestURI.endsWith("/health") || requestURI.startsWith("/rest/cluster/config/secondary-mode") || requestURI.startsWith("/rest/similarity") || requestURI.startsWith("/rest/cluster/config/tag") || requestURI.startsWith("/rest/security") && !"GET".equalsIgnoreCase(method) || requestURI.startsWith("/rest/explore-graph") && !"GET".equalsIgnoreCase(method) || requestURI.startsWith("/rest/sparql/saved-queries") && !"GET".equalsIgnoreCase(method) || requestURI.startsWith("/rest/monitor") && requestURI.endsWith("/operations") || !"GET".equalsIgnoreCase(method) && requestURI.startsWith("/rest/locations") || requestURI.startsWith("/rest/chat")) && !requestURI.startsWith("/rest/ttyg");
    }

    private boolean isRepositoryRequestForLeader(String requestURI, String method) {
        boolean sendToLeaderIfNotGet;
        if (requestURI.length() < REST_REPO_LENGTH || !requestURI.startsWith("/rest/repositories")) {
            return false;
        }
        boolean sendToLeader = true;
        boolean sendToFollower = false;
        boolean bl = sendToLeaderIfNotGet = !"GET".equalsIgnoreCase(method);
        if (requestURI.length() == REST_REPO_LENGTH) {
            return sendToLeaderIfNotGet;
        }
        String remainder = requestURI.substring(REST_REPO_LENGTH);
        if (remainder.equals("/ruleset/upload")) {
            return true;
        }
        if (remainder.startsWith("/ontop/")) {
            return true;
        }
        if (remainder.startsWith("/file")) {
            return true;
        }
        if (remainder.startsWith("/default-config/")) {
            return false;
        }
        if (remainder.equals("/all")) {
            return false;
        }
        if (remainder.startsWith("/graphql/manage")) {
            return false;
        }
        int slashIndex = requestURI.indexOf(47, REST_REPO_LENGTH + 1);
        if (slashIndex > 0) {
            String subPath = requestURI.substring(slashIndex);
            if (subPath.startsWith("/sparql-templates")) {
                return sendToLeaderIfNotGet;
            }
            if (subPath.equals("/size")) {
                return false;
            }
            if (subPath.equals("/graphql/endpoints")) {
                return false;
            }
            if (subPath.endsWith("/validate")) {
                return false;
            }
            if (subPath.startsWith("/graphql/manage")) {
                return sendToLeaderIfNotGet;
            }
            if (subPath.startsWith("/graphql")) {
                return true;
            }
            if (subPath.equals("/restart")) {
                return true;
            }
            if (subPath.equals("/prefix")) {
                return true;
            }
            if (subPath.startsWith("/import")) {
                if (subPath.startsWith("/import/server")) {
                    return true;
                }
                return true;
            }
            if (subPath.startsWith("/download")) {
                return false;
            }
        } else {
            return sendToLeaderIfNotGet;
        }
        return sendToLeaderIfNotGet;
    }

    private boolean isHealthEndpoint(String requestURI) {
        return requestURI.length() >= "/repositories/x/health".length() && requestURI.endsWith("/health");
    }

    private boolean isProxyDisabled() {
        if (this.proxyDisabled == null) {
            this.proxyDisabled = !Config.getPropertyAsBoolean((String)PROXY_ENABLED, (boolean)true);
        }
        return this.proxyDisabled;
    }

    @VisibleForTesting
    void reset() {
        this.proxyDisabled = null;
    }
}

