/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clustermanagement;

import com.ontotext.forest.clustermanagement.ClusterService;
import com.ontotext.forest.clustermanagement.ClusterStateException;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.raft.NodeStatus;
import com.ontotext.raft.config.ClusterConfig;
import com.ontotext.raft.config.ClusterGroupNodes;
import com.ontotext.raft.config.ClusterGroupProperties;
import com.ontotext.raft.config.ClusterGroupReplaceNodes;
import com.ontotext.raft.config.ClusterRequest;
import com.ontotext.raft.config.ClusterResponse;
import com.ontotext.raft.config.ClusterSecondaryConfig;
import com.ontotext.raft.config.TagRequest;
import com.ontotext.trree.util.HttpClientUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/rest/cluster"})
@Controller
@Tag(name="Cluster Group Management", description="Manage and monitor GraphDB cluster configurations")
public class ClusterGroupController {
    public static final String MAPPING = "/rest/cluster";
    public static final String REST_RPC_ADDRESS = "/rest/info/rpc-address";
    public static final String CANNOT_OBTAIN_RPC_ADDRESS_MSG = "Cannot obtain rpc address for %s. Failed with: %s\" ";
    private final ClusterService clusterService;

    @Autowired
    public ClusterGroupController(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Operation(summary="Get the GraphDB cluster configuration", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClusterRequest.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(value={"/config"}, produces={"application/json"})
    public ResponseEntity<ClusterResponse> getCluster() {
        ClusterConfig clusterGroup = this.clusterService.getClusterConfig();
        if (clusterGroup == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new ClusterResponse(clusterGroup), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Create a GraphDB cluster", responses={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(value={"/config"}, produces={"application/json"})
    public ResponseEntity<?> createCluster(@RequestBody ClusterRequest clusterConfig) {
        if (this.clusterService.isClusterEnabled()) {
            return new ResponseEntity((Object)"Cluster already exists.", (HttpStatusCode)HttpStatus.CONFLICT);
        }
        try {
            List<String> invalidClusterMessages = this.clusterService.validateConfig(clusterConfig);
            if (invalidClusterMessages != null && !invalidClusterMessages.isEmpty()) {
                return new ResponseEntity(invalidClusterMessages, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            Map<String, String> createMessage = this.clusterService.createCluster(new ClusterConfig(clusterConfig), true);
            return new ResponseEntity(createMessage, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (ClusterStateException cce) {
            return new ResponseEntity(cce.getMessages(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @Hidden
    @Operation(summary="Create a GraphDB cluster", responses={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(value={"/httpConfig"}, produces={"application/json"})
    public ResponseEntity<?> createClusterHttp(@RequestBody ClusterRequest clusterConfig, @RequestHeader(name="Authorization", required=false) String authorizationHeader) {
        if (this.clusterService.isClusterEnabled()) {
            return new ResponseEntity((Object)"Cluster already exists.", (HttpStatusCode)HttpStatus.CONFLICT);
        }
        LinkedList<String> nodesRpcAddresses = new LinkedList<String>();
        for (String node : clusterConfig.getNodes()) {
            try {
                nodesRpcAddresses.add(this.getRPCAddress(node, authorizationHeader));
            }
            catch (Exception e) {
                return new ResponseEntity((Object)String.format(CANNOT_OBTAIN_RPC_ADDRESS_MSG, node, e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        clusterConfig.setNodes(nodesRpcAddresses);
        return this.createCluster(clusterConfig);
    }

    private String getRPCAddress(String nodeHttpAddress, @Nullable String authorizationHeader) throws IOException, URISyntaxException {
        String currentNodeUrl = Config.getExternalUrl(null);
        if (nodeHttpAddress.equals(currentNodeUrl)) {
            return Config.getRPCAddress();
        }
        try (CloseableHttpClient httpClient = HttpClientUtil.createClusterSigningHttpClientWithShortTimeout();){
            URIBuilder builder = new URIBuilder(nodeHttpAddress + REST_RPC_ADDRESS);
            HttpGet get = new HttpGet(builder.build());
            if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
                get.setHeader("Authorization", authorizationHeader);
            }
            try (CloseableHttpResponse rcpAddressResponse = httpClient.execute((HttpUriRequest)get);){
                int status = rcpAddressResponse.getStatusLine().getStatusCode();
                if (status == 200) {
                    String string = EntityUtils.toString((HttpEntity)rcpAddressResponse.getEntity()).replaceAll("^\"|\"$", "");
                    return string;
                }
                throw new IllegalArgumentException(String.format("Request for rpc address for %s returned status code %s", nodeHttpAddress, status));
            }
        }
    }

    @Operation(summary="Delete the GraphDB cluster", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @DeleteMapping(value={"/config"}, produces={"application/json"})
    public ResponseEntity<?> deleteCluster(@RequestParam(defaultValue="false") boolean force) {
        Map<String, String> deleteStatus;
        try {
            deleteStatus = this.clusterService.deleteCluster(true, force);
        }
        catch (ClusterStateException e) {
            return new ResponseEntity(e.getMessages(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity(deleteStatus, (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Get the status of the GraphDB cluster", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=NodeStatus.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=NodeStatus.class)))})})
    @GetMapping(value={"/group/status"}, produces={"application/json"})
    public ResponseEntity<?> getClusterStatus() {
        try {
            List<NodeStatus> groupStatus = this.clusterService.getGroupStatus();
            HttpStatus httpStatus = HttpStatus.OK;
            if (groupStatus.stream().noneMatch(NodeStatus::isClusterEnabled)) {
                httpStatus = HttpStatus.NOT_FOUND;
            }
            return new ResponseEntity(groupStatus, (HttpStatusCode)httpStatus);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(summary="Truncate the GraphDB cluster log", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/truncate-log"}, produces={"application/json"})
    public ResponseEntity<?> truncateClusterLog() {
        try {
            this.clusterService.truncateClusterLog();
            return new ResponseEntity((Object)"Cluster log successfully truncated", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(summary="Add nodes to the GraphDB cluster", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(value={"/config/node"}, produces={"application/json"})
    public ResponseEntity<?> addNodes(@RequestBody ClusterGroupNodes addNodesClusterConfig) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        try {
            ClusterConfig newConfig = this.clusterService.generateNewConfigByAddingNodes(addNodesClusterConfig.getNodes(), currentConfig);
            List<String> invalidClusterMessages = this.clusterService.validateConfigGroupMembershipUpdate(newConfig);
            if (invalidClusterMessages != null && !invalidClusterMessages.isEmpty()) {
                return new ResponseEntity(invalidClusterMessages, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            Map<String, String> addNodesMessages = this.clusterService.addNodes(addNodesClusterConfig.getNodes(), currentConfig, newConfig);
            return new ResponseEntity(addNodesMessages, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ClusterStateException e) {
            return new ResponseEntity(e.getMessages(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        catch (UpdateExecutionException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Hidden
    @Operation(summary="Replace node in the GraphDB cluster", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PatchMapping(value={"/httpConfig"})
    public ResponseEntity<?> replaceNodesHttp(@RequestBody ClusterGroupReplaceNodes replaceNodesClusterConfig, @RequestHeader(name="Authorization", required=false) String authorizationHeader) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        LinkedList<String> addNodesRpc = new LinkedList<String>();
        for (String addNodeHttp : replaceNodesClusterConfig.getAddNodes()) {
            try {
                addNodesRpc.add(this.getRPCAddress(addNodeHttp, authorizationHeader));
            }
            catch (Exception e) {
                return new ResponseEntity((Object)String.format(CANNOT_OBTAIN_RPC_ADDRESS_MSG, addNodeHttp, e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        LinkedList<String> removeNodesRpc = new LinkedList<String>();
        for (String removeNodeHttp : replaceNodesClusterConfig.getRemoveNodes()) {
            try {
                removeNodesRpc.add(this.getRPCAddress(removeNodeHttp, authorizationHeader));
            }
            catch (Exception e) {
                return new ResponseEntity((Object)String.format(CANNOT_OBTAIN_RPC_ADDRESS_MSG, removeNodeHttp, e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        replaceNodesClusterConfig.setAddNodes(addNodesRpc);
        replaceNodesClusterConfig.setRemoveNodes(removeNodesRpc);
        return this.replaceNodes(replaceNodesClusterConfig);
    }

    @Operation(summary="Replace node in the GraphDB cluster", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PatchMapping(value={"/config/node"})
    public ResponseEntity<?> replaceNodes(@RequestBody ClusterGroupReplaceNodes replaceNodesClusterConfig) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        try {
            ClusterConfig newConfig = this.clusterService.generateNewConfigByReplacingNodes(replaceNodesClusterConfig.getAddNodes(), replaceNodesClusterConfig.getRemoveNodes(), currentConfig);
            List<String> invalidClusterMessages = this.clusterService.validateReplaceNodesConfigGroupMembershipUpdate(currentConfig, newConfig, replaceNodesClusterConfig.getRemoveNodes(), replaceNodesClusterConfig.getAddNodes());
            if (invalidClusterMessages != null && !invalidClusterMessages.isEmpty()) {
                return new ResponseEntity(invalidClusterMessages, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            Map<String, String> replacedNodesMessages = this.clusterService.replaceNodes(replaceNodesClusterConfig.getAddNodes(), this.clusterService.getOldNodesAddressesOnReplace(replaceNodesClusterConfig.getAddNodes(), replaceNodesClusterConfig.getRemoveNodes()), currentConfig, newConfig);
            return new ResponseEntity(replacedNodesMessages, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ClusterStateException e) {
            return new ResponseEntity(e.getMessages(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Operation(summary="Remove nodes from the GraphDB cluster", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @DeleteMapping(value={"/config/node"}, produces={"application/json"})
    public ResponseEntity<?> deleteNodes(@RequestBody ClusterGroupNodes removeNodesClusterConfig) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        List<String> errorMessages = this.clusterService.validateRemovedNodesExistInGroup(removeNodesClusterConfig.getNodes(), currentConfig.streamRpcNodes().collect(Collectors.toList()));
        if (errorMessages != null && !errorMessages.isEmpty()) {
            return new ResponseEntity(errorMessages, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        ClusterConfig newConfig = this.clusterService.generateNewConfigByRemovingNodes(removeNodesClusterConfig.getNodes(), currentConfig);
        try {
            List<String> invalidClusterMessages = this.clusterService.validateConfigGroupMembershipUpdate(newConfig);
            if (invalidClusterMessages != null && !invalidClusterMessages.isEmpty()) {
                return new ResponseEntity(invalidClusterMessages, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            Map<String, String> removeNodesMessages = this.clusterService.removeNodes(removeNodesClusterConfig.getNodes(), currentConfig, newConfig);
            return new ResponseEntity(removeNodesMessages, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RaftException | IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (ClusterStateException e) {
            return new ResponseEntity(e.getMessages(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        catch (UpdateExecutionException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @Operation(summary="Enable cluster secondary mode", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(value={"/config/secondary-mode"}, produces={"application/json"})
    public ResponseEntity<?> enableSecondaryMode(@RequestBody ClusterSecondaryConfig config) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        try {
            this.clusterService.enableSecondaryClusterMode(config);
            return new ResponseEntity((Object)"Cluster secondary mode is enabled", (HttpStatusCode)HttpStatus.OK);
        }
        catch (RaftException | IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (UpdateExecutionException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @Operation(summary="Disable cluster secondary mode", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @DeleteMapping(value={"/config/secondary-mode"}, produces={"application/json"})
    public ResponseEntity<?> stopSecondaryMode() {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        try {
            this.clusterService.disableSecondaryClusterMode();
            return new ResponseEntity((Object)"Cluster secondary mode is disabled", (HttpStatusCode)HttpStatus.OK);
        }
        catch (RaftException | IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (UpdateExecutionException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @Operation(summary="Add primary cluster tag", responses={@ApiResponse(responseCode="200", description="\u041e\u041a", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(value={"/config/tag"}, produces={"application/json"})
    public ResponseEntity<?> enableSecondaryMode(@RequestBody TagRequest tag) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        try {
            boolean added = this.clusterService.addSecondaryTag(tag.getTag());
            if (added) {
                return new ResponseEntity((Object)("Successfully added to cluster primary tag: " + tag.getTag()), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)("Tag '" + tag.getTag() + "' already exists"), (HttpStatusCode)HttpStatus.OK);
        }
        catch (RaftException | IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (UpdateExecutionException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @Operation(summary="Remove primary cluster tag", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @DeleteMapping(value={"/config/tag"}, produces={"application/json"})
    public ResponseEntity<?> removeTag(@RequestBody TagRequest tag) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        try {
            boolean removed = this.clusterService.removeSecondaryTag(tag.getTag());
            if (removed) {
                return new ResponseEntity((Object)("Removed primary tag '" + tag.getTag() + "' from cluster"), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)("Tag '" + tag.getTag() + "' does not exist"), (HttpStatusCode)HttpStatus.OK);
        }
        catch (RaftException | IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (UpdateExecutionException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @Operation(summary="Update the GraphDB cluster configuration", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClusterRequest.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PatchMapping(value={"/config"}, produces={"application/json"})
    public ResponseEntity<?> updateProperties(@RequestBody ClusterGroupProperties updatePropertiesConfig) {
        ClusterConfig currentConfig = this.clusterService.getClusterConfig();
        if (currentConfig == null) {
            return new ResponseEntity((Object)"Cluster does not exist.", (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        ClusterConfig newConfig = this.clusterService.generateNewConfig(updatePropertiesConfig, currentConfig);
        try {
            List<String> invalidClusterMessages = this.clusterService.validateGroupProperties(newConfig.getHeartbeatInterval(), newConfig.getElectionMinTimeout(), newConfig.getElectionRangeTimeout(), newConfig.getMessageSizeKB(), newConfig.getVerificationTimeout(), newConfig.getTransactionLogMaximumSizeGB(), newConfig.getBatchUpdateInterval());
            if (invalidClusterMessages != null && !invalidClusterMessages.isEmpty()) {
                return new ResponseEntity(invalidClusterMessages, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            this.clusterService.updateProperties(newConfig);
            return new ResponseEntity((Object)new ClusterResponse(newConfig), (HttpStatusCode)HttpStatus.OK);
        }
        catch (RaftException | IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (ClusterStateException e) {
            return new ResponseEntity(e.getMessages(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        catch (UpdateExecutionException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @Operation(summary="Get the status of this GraphDB cluster node", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=NodeStatus.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=NodeStatus.class))})})
    @GetMapping(value={"/node/status"}, produces={"application/json"})
    public ResponseEntity<?> getNodeStatus() {
        try {
            NodeStatus nodeStatus = this.clusterService.getNodeStatus();
            return new ResponseEntity((Object)nodeStatus, (HttpStatusCode)(nodeStatus.isClusterEnabled() || this.clusterService.isNodeNotInCurrentClusterConfig() ? HttpStatus.OK : HttpStatus.NOT_FOUND));
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Hidden
    @GetMapping(produces={"application/json"})
    public ResponseEntity<?> isClusterEnabled() {
        try {
            ClusterService.ClusterState clusterState = this.clusterService.getClusterState();
            return new ResponseEntity((HttpStatusCode)(switch (clusterState) {
                default -> throw new MatchException(null, null);
                case ClusterService.ClusterState.ENABLED -> HttpStatus.OK;
                case ClusterService.ClusterState.DISABLED -> HttpStatus.NOT_ACCEPTABLE;
                case ClusterService.ClusterState.UNKNOWN -> HttpStatus.TOO_EARLY;
            }));
        }
        catch (RuntimeException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }
}

