/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sandbox.quota;

import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.graphdb.gpt.quota.GraphDBTokenQuotaManager;
import com.ontotext.graphdb.gpt.quota.QuotaUtils;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuotaService {
    public static final String GPT_TOKEN_QUOTA = "gptTokenQuota";
    private PersistedConfig persistedConfig;

    @Autowired
    public QuotaService(PersistedConfig persistedConfig) {
        this.persistedConfig = persistedConfig;
    }

    @PostConstruct
    public void init() {
        Map tokenQuotaPersisted = this.persistedConfig.getMap(GPT_TOKEN_QUOTA, GraphDBTokenQuotaManager.class);
        if (MapUtils.isNotEmpty((Map)tokenQuotaPersisted)) {
            GraphDBTokenQuotaManager tokenQuotaManager = GraphDBTokenQuotaManager.getInstance();
            for (Map.Entry tokenQuota : tokenQuotaPersisted.entrySet()) {
                tokenQuotaManager.setQuotaLimit(((GraphDBTokenQuotaManager)tokenQuota.getValue()).getQuotaLimit());
                tokenQuotaManager.consumeTokens(((GraphDBTokenQuotaManager)tokenQuota.getValue()).getPromptTokensUsed(), ((GraphDBTokenQuotaManager)tokenQuota.getValue()).getCompletionTokensUsed());
            }
        }
        QuotaUtils.setTokenConsumer(this::consumeTokens);
    }

    public void setQuotaLimit(long limit) {
        GraphDBTokenQuotaManager.getInstance().setQuotaLimit(limit);
        this.persistGptTokenData();
    }

    public void consumeTokens(long promptTokensUsed, long completionTokensUsed) {
        GraphDBTokenQuotaManager.getInstance().consumeTokens(promptTokensUsed, completionTokensUsed);
        if (GraphDBTokenQuotaManager.getInstance().getQuotaLimit() > 0L) {
            this.persistGptTokenData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistGptTokenData() {
        QuotaService quotaService = this;
        synchronized (quotaService) {
            this.persistedConfig.updateMapEntry(GPT_TOKEN_QUOTA, GraphDBTokenQuotaManager.class, "quota", (Object)GraphDBTokenQuotaManager.getInstance());
        }
    }
}

