/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sandbox.quota;

import com.ontotext.forest.gpt.conversations.Usage;
import com.ontotext.forest.sandbox.quota.QuotaService;
import com.ontotext.graphdb.gpt.quota.GraphDBTokenQuotaManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/sandbox/manage/quota"})
public class GraphDBSandboxQuotaController {
    private QuotaService quotaService;

    @Autowired
    public GraphDBSandboxQuotaController(QuotaService quotaService) {
        this.quotaService = quotaService;
    }

    @GetMapping
    public ResponseEntity<?> getQuota() {
        Map<String, Long> response = Map.of("quotaLimit", GraphDBTokenQuotaManager.getInstance().getQuotaLimit());
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<?> setQuota(@RequestParam long limit) {
        this.quotaService.setQuotaLimit(limit);
        return ResponseEntity.ok((Object)"Quota updated successfully");
    }

    @GetMapping(value={"/usage"}, produces={"application/json"})
    public ResponseEntity<?> getUsage() {
        GraphDBTokenQuotaManager quotaManager = GraphDBTokenQuotaManager.getInstance();
        return ResponseEntity.ok((Object)new Usage(quotaManager.getCompletionTokensUsed(), quotaManager.getPromptTokensUsed(), quotaManager.getTotalUsage()));
    }
}

