/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.mcp.server;

import io.modelcontextprotocol.json.TypeRef;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public final class GraphDBMcpServerSession {
    private final McpServerSession delegate;
    private final AtomicReference<Instant> lastActivity = new AtomicReference<Instant>(Instant.now());
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private boolean isDelegateInitialized;

    public GraphDBMcpServerSession(McpServerSession delegate) {
        this.delegate = delegate;
    }

    private void touch() {
        this.lastActivity.lazySet(Instant.now());
    }

    public boolean isIdle(Duration idleTimeout) {
        return Duration.between(this.lastActivity.get(), Instant.now()).compareTo(idleTimeout) > 0;
    }

    public Instant lastActivity() {
        return this.lastActivity.get();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public Mono<Void> handle(McpSchema.JSONRPCMessage message) {
        McpSchema.JSONRPCNotification notification;
        this.touch();
        if (message instanceof McpSchema.JSONRPCNotification && "notifications/initialized".equals((notification = (McpSchema.JSONRPCNotification)message).method())) {
            this.isDelegateInitialized = true;
        }
        return this.delegate.handle(message);
    }

    public <T> Mono<T> sendRequest(String method, Object params, TypeRef<T> typeRef) {
        this.touch();
        return this.delegate.sendRequest(method, params, typeRef);
    }

    public Mono<Void> sendNotification(String method, Object params) {
        this.touch();
        return this.delegate.sendNotification(method, params);
    }

    public Mono<Void> closeGracefully() {
        return this.delegate.closeGracefully();
    }

    public void close() {
        this.delegate.close();
    }

    public McpServerSession unwrap() {
        return this.delegate;
    }

    public boolean isDelegateInitialized() {
        return this.isDelegateInitialized;
    }

    public boolean tryEvict() {
        return this.closing.compareAndSet(false, true);
    }

    public boolean isClosing() {
        return this.closing.get();
    }
}

