/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.BaseTool;
import com.ontotext.forest.gpt.ttyg.tools.ParameterDefinition;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.SystemConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class SimilaritySearchTool
extends BaseTool {
    public static final String SIMILARITY_QUERY_TEMPLATE_PROPERTY = "graphdb.ttyg.similarity.query.template";
    public static final String ELASTICSEARCH_VECTOR_QUERY_TEMPLATE_PROPERTY = "graphdb.ttyg.similarity.elasticsearch.vector.query.template";
    public static final String OPENSEARCH_VECTOR_QUERY_TEMPLATE_PROPERTY = "graphdb.ttyg.similarity.opensearch.vector.query.template";
    private static final double DEFAULT_THRESHOLD = 0.4;
    private static final String SIMILARITY_QUERY_TEMPLATE = Config.getProperty((String)"graphdb.ttyg.similarity.query.template", (String)"PREFIX sim: <http://www.ontotext.com/graphdb/similarity/>\nPREFIX sim-index: <http://www.ontotext.com/graphdb/similarity/instance/>\nDESCRIBE ?documentID WHERE {\n    ?search a sim-index:%s ;\n        sim:searchTerm %s ;\n        sim:documentResult ?result .\n    ?result sim:value ?documentID ;\n        sim:score ?score.\n    FILTER(?score >= %f)\n}");
    private static final String GRAPHDB_SIMILARITY_INDEX_VALIDATION_QUERY = "PREFIX sim: <http://www.ontotext.com/graphdb/similarity/>\nPREFIX sim-index:<http://www.ontotext.com/graphdb/similarity/instance/>\nASK {\n    sim-index:%s sim:status ?status\n}";
    private static final String ELASTICSEARCH_DEFAULT_VECTOR_QUERY_TEMPLATE = "PREFIX conn:<http://www.ontotext.com/connectors/elasticsearch#>\nPREFIX inst:<http://www.ontotext.com/connectors/elasticsearch/instance#>\nDESCRIBE ?entity WHERE {\n    {\n        SELECT DISTINCT ?entity WHERE {\n            ?search a inst:%s ;\n                    conn:similarity \"%s:%s\" ;\n                    conn:entities ?entity .\n            OPTIONAL { ?entity conn:score ?score . }\n            FILTER(!BOUND(?score) || ?score >= %f)\n        }\n    }\n}";
    private static final String OPENSEARCH_DEFAULT_VECTOR_QUERY_TEMPLATE = "PREFIX conn:<http://www.ontotext.com/connectors/opensearch#>\nPREFIX inst:<http://www.ontotext.com/connectors/opensearch/instance#>\nDESCRIBE ?entity WHERE {\n    {\n        SELECT DISTINCT ?entity WHERE {\n            ?search a inst:%s ;\n                    conn:similarity \"%s:%s\" ;\n                    conn:entities ?entity .\n            OPTIONAL { ?entity conn:score ?score . }\n            FILTER(!BOUND(?score) || ?score >= %f)\n        }\n    }\n}";
    public static final String SIMILARITY_TOOL_DESCRIPTION = "Query GraphDB by similarity search and return a subgraph of RDF triples.";
    private String similarityIndex;
    private double resultThreshold = 0.4;
    private int limit;
    private String connectorType = "similarity";
    private List<String> connectorFields = null;

    public SimilaritySearchTool() {
        super(ToolType.SIMILARITY_SEARCH);
    }

    @VisibleForTesting
    public SimilaritySearchTool(String similarityIndex, double resultThreshold, int limit, String connectorType, List<String> connectorFields) {
        this();
        this.setEnabled(true);
        this.setSimilarityIndex(similarityIndex);
        this.setResultThreshold(resultThreshold);
        this.setLimit(limit);
        this.setConnectorType(connectorType);
        this.setConnectorFields(connectorFields);
    }

    @Override
    public void setFromLegacyUiObject(JsonNode node) {
        this.setEnabled(true);
        this.setSimilarityIndex(node.path("similarityIndex").asText());
        this.setResultThreshold(node.path("similarityIndexThreshold").asDouble(0.4));
        this.setLimit(node.path("maxNumberOfTriplesPerCall").asInt(0));
        this.setConnectorType(node.path("connectorType").asText("similarity"));
        if (node.has("connectorFields") && node.get("connectorFields").isArray()) {
            this.connectorFields = StreamSupport.stream(node.get("connectorFields").spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
        }
    }

    @Override
    public void writeToLegacyUiObject(JsonGenerator gen) throws IOException {
        gen.writeStringField("method", this.getType().getLegacyUiMethodKey());
        gen.writeStringField("similarityIndex", this.getSimilarityIndex());
        gen.writeNumberField("similarityIndexThreshold", this.getResultThreshold());
        gen.writeNumberField("maxNumberOfTriplesPerCall", this.getLimit());
        gen.writeStringField("connectorType", this.getConnectorType());
        if (this.connectorFields != null && !this.connectorFields.isEmpty()) {
            gen.writeArrayFieldStart("connectorFields");
            for (String f : this.connectorFields) {
                gen.writeString(f);
            }
            gen.writeEndArray();
        }
    }

    public String getSimilarityIndex() {
        return this.similarityIndex;
    }

    public void setSimilarityIndex(String similarityIndex) {
        this.similarityIndex = similarityIndex;
    }

    public double getResultThreshold() {
        return this.resultThreshold;
    }

    public void setResultThreshold(double resultThreshold) {
        this.resultThreshold = resultThreshold;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public void setConnectorType(String connectorType) {
        this.connectorType = connectorType;
    }

    public List<String> getConnectorFields() {
        return this.connectorFields;
    }

    public void setConnectorFields(List<String> connectorFields) {
        this.connectorFields = connectorFields;
    }

    @Override
    public void validate(ToolCallContext agentRepository) {
        if (StringUtils.isBlank((CharSequence)this.similarityIndex)) {
            throw new ToolConfigException("Similarity method requires a similarity index value.");
        }
        if ("similarity".equals(this.connectorType)) {
            if (!TurtleUtil.isValidPrefixedName((String)this.similarityIndex)) {
                throw new ToolConfigException("Similarity method index must be a valid local name: " + this.similarityIndex);
            }
            if (!agentRepository.connectionInstance().prepareBooleanQuery(SystemConfig.localeIndependentFormat((String)GRAPHDB_SIMILARITY_INDEX_VALIDATION_QUERY, (Object[])new Object[]{this.similarityIndex})).evaluate()) {
                throw new ToolConfigException("Similarity method requires a valid similarity index.");
            }
        } else {
            ConnectorDescriptor descriptor = ConnectorDescriptor.fromType(this.connectorType);
            if (this.connectorFields == null || this.connectorFields.isEmpty()) {
                throw new ToolConfigException(descriptor.getType() + " connector requires one vector field.");
            }
        }
    }

    @Override
    public String getDescription() {
        return SIMILARITY_TOOL_DESCRIPTION;
    }

    @Override
    public ParameterDefinition getParameterSchema() {
        return ParameterDefinition.singleParameter("query", "Similarity search query");
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        ConnectorDescriptor descriptor;
        String rawQuery = this.getRawQuery((Map)parameters);
        if ("similarity".equalsIgnoreCase(this.connectorType)) {
            return SystemConfig.localeIndependentFormat((String)SIMILARITY_QUERY_TEMPLATE, (Object[])new Object[]{this.similarityIndex, this.toSparqlLiteral(rawQuery), this.resultThreshold});
        }
        try {
            descriptor = ConnectorDescriptor.fromType(this.connectorType);
        }
        catch (ToolConfigException e) {
            throw new ToolConfigException("Unsupported connector type: " + this.connectorType);
        }
        return TtygSimilarityQueryBuilder.buildSimilarityQuery(descriptor, this.similarityIndex, rawQuery, this.resultThreshold, this.getConnectorFields());
    }

    @Override
    public ToolResponse call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        RepositoryConnection connection = agentRepository.connectionInstance();
        return new ToolResponse(this.evaluateParsedQuery((Query)connection.prepareGraphQuery(this.getNativeQuery(parameters)), connection, this.limit));
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimilaritySearchTool)) {
            return false;
        }
        SimilaritySearchTool tool = (SimilaritySearchTool)o;
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.resultThreshold, tool.resultThreshold) == 0 && this.limit == tool.limit && Objects.equals(this.similarityIndex, tool.similarityIndex) && Objects.equals(this.connectorType, tool.connectorType) && Objects.equals(this.connectorFields, tool.connectorFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.similarityIndex, this.resultThreshold, this.limit, this.connectorType, this.connectorFields);
    }

    public static enum ConnectorDescriptor {
        ELASTICSEARCH("elasticsearch", List.of(), "graphdb.ttyg.similarity.elasticsearch.vector.query.template", "PREFIX conn:<http://www.ontotext.com/connectors/elasticsearch#>\nPREFIX inst:<http://www.ontotext.com/connectors/elasticsearch/instance#>\nDESCRIBE ?entity WHERE {\n    {\n        SELECT DISTINCT ?entity WHERE {\n            ?search a inst:%s ;\n                    conn:similarity \"%s:%s\" ;\n                    conn:entities ?entity .\n            OPTIONAL { ?entity conn:score ?score . }\n            FILTER(!BOUND(?score) || ?score >= %f)\n        }\n    }\n}"),
        OPENSEARCH("opensearch", List.of(), "graphdb.ttyg.similarity.opensearch.vector.query.template", "PREFIX conn:<http://www.ontotext.com/connectors/opensearch#>\nPREFIX inst:<http://www.ontotext.com/connectors/opensearch/instance#>\nDESCRIBE ?entity WHERE {\n    {\n        SELECT DISTINCT ?entity WHERE {\n            ?search a inst:%s ;\n                    conn:similarity \"%s:%s\" ;\n                    conn:entities ?entity .\n            OPTIONAL { ?entity conn:score ?score . }\n            FILTER(!BOUND(?score) || ?score >= %f)\n        }\n    }\n}");

        private final String type;
        private final List<String> fields;
        private final String templateProperty;
        private final String defaultTemplate;

        private ConnectorDescriptor(String type, List<String> fields, String templateProperty, String defaultTemplate) {
            this.type = type;
            this.fields = fields;
            this.templateProperty = templateProperty;
            this.defaultTemplate = defaultTemplate;
        }

        public String getType() {
            return this.type;
        }

        public List<String> fields() {
            return this.fields;
        }

        public String getVectorQueryTemplateProperty() {
            return Config.getProperty((String)this.templateProperty, (String)this.defaultTemplate);
        }

        public static ConnectorDescriptor fromType(String connectorType) {
            return Arrays.stream(ConnectorDescriptor.values()).filter(c -> c.type.equalsIgnoreCase(connectorType)).findFirst().orElseThrow(() -> new ToolConfigException("Unknown connector type: " + connectorType));
        }
    }

    public static class TtygSimilarityQueryBuilder {
        public static String buildSimilarityQuery(ConnectorDescriptor connector, String similarityIndex, String rawQuery, double threshold, List<String> runtimeFields) {
            List<String> fields = runtimeFields != null && !runtimeFields.isEmpty() ? runtimeFields : connector.fields();
            return SystemConfig.localeIndependentFormat((String)connector.getVectorQueryTemplateProperty(), (Object[])new Object[]{similarityIndex, fields.getFirst(), rawQuery, threshold});
        }
    }
}

