/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.RDFUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.RetrievalSearchTool;
import com.ontotext.graphdb.configs.SystemConfig;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.StringEntity;

class RetrievalSearchDirectService
implements RetrievalSearchTool.RetrievalSearchService {
    private static final String NULL_VALUE_KEYS_REGEX = "\"[^\"\\\\]+\"\\s* : \\s* null (?=\\W)";
    private static final Pattern NULL_VALUE_KEYS_PATTERN = Pattern.compile("((?<= \\{ )\"[^\"\\\\]+\"\\s* : \\s* null (?=\\W)(\\s* ,)?) | ((, \\s*)?\"[^\"\\\\]+\"\\s* : \\s* null (?=\\W))", 4);
    private final RetrievalSearchTool tool;

    RetrievalSearchDirectService(RetrievalSearchTool tool) {
        this.tool = tool;
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        return JSONUtil.prettyPrintJSON(this.tool.sanitizeParameters(parameters));
    }

    @Override
    public String call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        Object object;
        Pair<String, String> connectorSettings = this.getConnectorSettings(agentRepository);
        String url = (String)connectorSettings.getKey();
        String token = (String)connectorSettings.getValue();
        String callJson = this.getNativeQuery(parameters);
        int maxSizeBeforeTrimmingNulls = 384000;
        HttpResponse response = Request.Post((String)(url + "query")).userAgent(SystemConfig.getHttpUserAgent()).connectTimeout(SystemConfig.getHttpConnectTimeout()).socketTimeout(SystemConfig.getHttpSocketTimeout()).setHeader("Accept", "application/json").setHeader("Content-Type", "application/json").setHeader("Authorization", "Bearer " + token).body((HttpEntity)new StringEntity(callJson)).execute().returnResponse();
        int statusCode = response.getStatusLine().getStatusCode();
        CharBuffer charBuf = CharBuffer.allocate(maxSizeBeforeTrimmingNulls);
        InputStreamReader reader = new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8);
        try {
            while (reader.read(charBuf) > 0) {
            }
            charBuf.flip();
            Object result = charBuf.toString();
            result = this.removeNullsFromJson((String)result);
            if (statusCode != 200) {
                result = "Error: HTTP status " + statusCode + "\n\n" + (String)result;
            }
            if (((String)result).length() > 256000) {
                result = ((String)result).substring(0, 256000);
            }
            object = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "Error: Could not connect to ChatGPT Retrieval plugin due to " + e.getClass().getCanonicalName();
            }
        }
        reader.close();
        return object;
    }

    @VisibleForTesting
    String removeNullsFromJson(String json) {
        return NULL_VALUE_KEYS_PATTERN.matcher(json).replaceAll("");
    }

    private Pair<String, String> getConnectorSettings(ToolCallContext agentRepository) {
        Map config;
        String connectorInstance = this.tool.getConnectorInstance();
        Path connectorConfigFile = RDFUtil.getRepositoryDataDir(agentRepository.connectionInstance()).toPath().resolve("storage/chatgpt-retrieval-connector/config.json");
        if (Files.exists(connectorConfigFile, new LinkOption[0]) && (config = (Map)JSONUtil.parseJSON(connectorConfigFile).get(connectorInstance)) != null) {
            Object url = config.get("retrievalUrl");
            Object token = config.get("retrievalBearerToken");
            if (url instanceof String && token instanceof String) {
                Object normalizedUrl = (String)url;
                if (!((String)normalizedUrl).endsWith("/")) {
                    normalizedUrl = (String)normalizedUrl + "/";
                }
                return Pair.of((Object)normalizedUrl, (Object)((String)token));
            }
        }
        throw new ToolConfigException("No such connector instance: " + connectorInstance);
    }
}

