/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg;

import com.ontotext.forest.gpt.ttyg.SmartTurtleStarWriter;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericClientException;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.config.OWLIMSailSchema;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.text.tsv.SPARQLResultsTSVWriter;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.StackableSail;

public class RDFUtil {
    public static String serializeRdf(RepositoryResult<Statement> statements, Iterable<Namespace> namespaces, boolean onlyUsedNamespaces, int numStatementsLimit, int serializedSizeLimit) {
        try (RepositoryResult<Statement> repositoryResult = statements;){
            String string = RDFUtil.serializeRdf(statements.stream(), namespaces, onlyUsedNamespaces, numStatementsLimit, serializedSizeLimit);
            return string;
        }
    }

    public static String serializeRdf(QueryResult<Statement> statements, Iterable<Namespace> namespaces, boolean onlyUsedNamespaces, int numStatementsLimit, int serializedSizeLimit) {
        try (QueryResult<Statement> queryResult = statements;){
            String string = RDFUtil.serializeRdf(statements.stream(), namespaces, onlyUsedNamespaces, numStatementsLimit, serializedSizeLimit);
            return string;
        }
    }

    public static String serializeRdf(Stream<Statement> statementsStream, Iterable<Namespace> namespaces, boolean onlyUsedNamespaces, int numStatementsLimit, int serializedSizeLimit) {
        try {
            String string;
            SmartTurtleStarWriter rdfWriter = new SmartTurtleStarWriter(serializedSizeLimit, onlyUsedNamespaces);
            try {
                rdfWriter.startRDF();
                namespaces.forEach(ns -> rdfWriter.handleNamespace(ns.getPrefix(), ns.getName()));
                if (numStatementsLimit > 0) {
                    statementsStream = statementsStream.limit(numStatementsLimit);
                }
                try {
                    statementsStream.forEach(rdfWriter::handleStatement);
                }
                catch (ResultOverLimitException resultOverLimitException) {
                    // empty catch block
                }
                rdfWriter.endRDF();
                string = rdfWriter.getSerialized();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdfWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            rdfWriter.close();
            return string;
        }
        finally {
            statementsStream.close();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeTupleResult(TupleQueryResult result, int numBindingSetsLimit, int serializedSizeLimit) {
        try (StringWriter writer = new StringWriter();){
            String string;
            block16: {
                TupleQueryResult tupleQueryResult = result;
                try {
                    SPARQLResultsTSVWriter tupleWriter = new SPARQLResultsTSVWriter(writer){

                        public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
                            this.handleSolutionImpl(bindingSet);
                        }
                    };
                    tupleWriter.startQueryResult(result.getBindingNames());
                    Stream<BindingSet> stream = result.stream();
                    if (numBindingSetsLimit > 0) {
                        stream = stream.limit(numBindingSetsLimit);
                    }
                    try {
                        stream.forEach(bs -> {
                            tupleWriter.handleSolution(bs);
                            int serializedSize = writer.getBuffer().length();
                            if (serializedSizeLimit > 0 && serializedSize > serializedSizeLimit) {
                                writer.getBuffer().setLength(serializedSize - (serializedSize - serializedSizeLimit));
                                throw new ResultOverLimitException();
                            }
                        });
                    }
                    catch (ResultOverLimitException resultOverLimitException) {
                        // empty catch block
                    }
                    tupleWriter.endQueryResult();
                    string = writer.toString().trim();
                    if (tupleQueryResult == null) break block16;
                }
                catch (Throwable throwable) {
                    if (tupleQueryResult != null) {
                        try {
                            tupleQueryResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tupleQueryResult.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OwlimSchemaRepository getOwlim(RepositoryConnection connection) {
        Repository repository = connection.getRepository();
        if (repository instanceof SailRepository) {
            SailRepository sailRepository = (SailRepository)repository;
            Sail sail = sailRepository.getSail();
            while (!(sail instanceof OwlimSchemaRepository) && sail instanceof StackableSail) {
                sail = ((StackableSail)sail).getBaseSail();
            }
            if (sail instanceof OwlimSchemaRepository) {
                return (OwlimSchemaRepository)sail;
            }
        }
        throw new GenericClientException("The repository is not a GraphDB repository");
    }

    public static String getRepositoryId(RepositoryConnection connection) {
        return RDFUtil.getOwlim(connection).getRepositoryId();
    }

    public static File getRepositoryDataDir(RepositoryConnection connection) {
        return RDFUtil.getOwlim(connection).getDataDir();
    }

    public static String getRepositoryFingerprint(RepositoryConnection connection) {
        return RDFUtil.getOwlim(connection).getFingerprint();
    }

    public static boolean isFtsIndexEnabled(RepositoryConnection connection) {
        return RDFUtil.getOwlimSetting(connection, OWLIMSailSchema.enableFtsIndex.getLocalName(), "false").equals("true");
    }

    public static String escapeFtsQuery(String query) {
        return query.replaceAll("(\\p{Punct})", "\\\\$1");
    }

    private static String getOwlimSetting(RepositoryConnection connection, String key, String defaultValue) {
        return RDFUtil.getOwlim(connection).getParams().getOrDefault(key, defaultValue);
    }

    static class ResultOverLimitException
    extends RuntimeException {
        ResultOverLimitException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

