/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.conversations;

import com.azure.ai.openai.assistants.AssistantsClient;
import com.azure.ai.openai.assistants.models.AssistantThread;
import com.azure.ai.openai.assistants.models.AssistantThreadCreationOptions;
import com.azure.ai.openai.assistants.models.ListSortOrder;
import com.azure.ai.openai.assistants.models.MessageContent;
import com.azure.ai.openai.assistants.models.MessageRole;
import com.azure.ai.openai.assistants.models.MessageTextContent;
import com.azure.ai.openai.assistants.models.PageableList;
import com.azure.ai.openai.assistants.models.RunCompletionUsage;
import com.azure.ai.openai.assistants.models.RunStatus;
import com.azure.ai.openai.assistants.models.ThreadMessage;
import com.azure.ai.openai.assistants.models.ThreadRun;
import com.azure.ai.openai.assistants.models.UpdateAssistantThreadOptions;
import com.ontotext.forest.gpt.chat.GptChatMessage;
import com.ontotext.forest.gpt.chat.TerminalStatus;
import com.ontotext.forest.gpt.conversations.ConversationResponse;
import com.ontotext.forest.gpt.conversations.Usage;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.configs.SystemConfig;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationGptClient {
    public static final String NEW_CHAT_NAME = "New chat";
    public static final String METADATA_NAME = "name";
    public static final String METADATA_INSTALLATION_ID = "graphdb.installationId";
    public static final String METADATA_USERNAME = "graphdb.username";
    public static final String METADATA_UPDATED_AT = "graphdb.updatedAt";
    public static final String METADATA_USAGE = "graphdb.usage";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    AssistantsClient assistantsOpenAIClient;

    public ConversationGptClient(AssistantsClient assistantsOpenAIClient) {
        this.assistantsOpenAIClient = assistantsOpenAIClient;
    }

    public AssistantThread createConversation() {
        AssistantThreadCreationOptions options = new AssistantThreadCreationOptions();
        options.setMetadata(Map.of(METADATA_NAME, NEW_CHAT_NAME, METADATA_INSTALLATION_ID, SystemConfig.getInstallationId(), METADATA_USERNAME, GraphDBHTTPContext.getAuthenticatedUser().getUsername()));
        return this.assistantsOpenAIClient.createThread(options);
    }

    public ConversationResponse renameConversation(String conversationId, String name) {
        ConversationResponse conversation = this.getConversationWithoutMessages(conversationId);
        conversation.setName(name);
        this.assistantsOpenAIClient.updateThread(conversationId, new UpdateAssistantThreadOptions().setMetadata(Map.of(METADATA_NAME, name)));
        return conversation;
    }

    public ConversationResponse getConversationWithoutMessages(String threadId) {
        AssistantThread thread = this.getThreadWithSecurity(threadId);
        ConversationResponse response = new ConversationResponse();
        response.setId(thread.getId());
        response.setName((String)thread.getMetadata().get(METADATA_NAME));
        long timestamp = thread.getCreatedAt().toEpochSecond();
        String metadataTimestamp = (String)thread.getMetadata().get(METADATA_UPDATED_AT);
        if (metadataTimestamp != null) {
            try {
                timestamp = Long.parseLong(metadataTimestamp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        response.setTimestamp(timestamp);
        return response;
    }

    public AssistantThread getThreadWithSecurity(String threadId) {
        AssistantThread thread = this.assistantsOpenAIClient.getThread(threadId);
        Map metadata = thread.getMetadata();
        if (!SystemConfig.matchesInstallationId((String)((String)metadata.get(METADATA_INSTALLATION_ID)))) {
            throw new NonExistentResourceRequested("Chat not matching this GraphDB instance");
        }
        if (!GraphDBHTTPContext.getAuthenticatedUser().getUsername().equals(metadata.get(METADATA_USERNAME))) {
            throw new NonExistentResourceRequested("Chat not matching the requesting user");
        }
        return thread;
    }

    public ConversationResponse addAllConversationMessages(ConversationResponse conversation, @Nullable Integer limit) {
        PageableList threadMessages = this.assistantsOpenAIClient.listMessages(conversation.getId(), limit, ListSortOrder.ASCENDING, null, null);
        return this.addConversationMessages(conversation, threadMessages.getData(), limit);
    }

    public ConversationResponse addConversationMessages(ConversationResponse conversation, List<ThreadMessage> threadMessages, @Nullable Integer limit) {
        long latestTimestamp = this.populateConversationMessages(conversation, threadMessages, limit);
        if (latestTimestamp != -1L && latestTimestamp > conversation.getTimestamp()) {
            conversation.setTimestamp(latestTimestamp);
            this.assistantsOpenAIClient.updateThread(conversation.getId(), new UpdateAssistantThreadOptions().setMetadata(Map.of(METADATA_UPDATED_AT, Long.toString(latestTimestamp))));
        }
        return conversation;
    }

    private long populateConversationMessages(ConversationResponse conversation, List<ThreadMessage> threadMessages, @Nullable Integer limit) {
        long latestTimestamp = -1L;
        List<GptChatMessage> messages = this.populateMissingThreadMessagesWithRuns(conversation.getId(), threadMessages, limit);
        for (ThreadMessage threadMessage : threadMessages) {
            List attachementList;
            MessageContent firstMessage;
            List contentList;
            ThreadRun threadRun;
            GptChatMessage messageResponse = new GptChatMessage();
            messageResponse.setAgentId(threadMessage.getAssistantId());
            messageResponse.setRole(threadMessage.getRole().toString());
            messageResponse.setConversationId(threadMessage.getThreadId());
            messageResponse.setTimestamp(threadMessage.getCreatedAt().toEpochSecond());
            messageResponse.setId(threadMessage.getId());
            messageResponse.setUsage(threadMessage.getMetadata().get(METADATA_USAGE) != null ? JSONUtil.parseJSON((String)threadMessage.getMetadata().get(METADATA_USAGE), Usage.class) : null);
            if (threadMessage.getRunId() != null && this.setCustomMessageContentBasedOnStatus(messages, threadRun = this.assistantsOpenAIClient.getRun(conversation.getId(), threadMessage.getRunId()), messageResponse) || (contentList = threadMessage.getContent()) == null || contentList.isEmpty()) continue;
            long timestamp = threadMessage.getCreatedAt().toEpochSecond();
            if (timestamp > latestTimestamp) {
                latestTimestamp = timestamp;
            }
            if ((firstMessage = (MessageContent)contentList.getFirst()) instanceof MessageTextContent) {
                MessageTextContent messageTextContent = (MessageTextContent)firstMessage;
                messageResponse.setMessage(messageTextContent.getText().getValue());
                List annotationsList = messageTextContent.getText().getAnnotations();
                if (!annotationsList.isEmpty()) {
                    this.logger.warn("Message contains annotations in {}///{}, ignoring {} annotations", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), annotationsList.size()});
                }
            } else {
                this.logger.warn("Unsupported message type in {}///{}: {}", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), firstMessage});
                messageResponse.setMessage("[Unsupported message type: " + firstMessage.getType() + "]");
            }
            if (contentList.size() > 1) {
                this.logger.warn("More than one content item in {}///{}, ignoring {} remaining items", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), contentList.size() - 1});
            }
            if (!(attachementList = threadMessage.getAttachments()).isEmpty()) {
                this.logger.warn("Message contains attachments in {}///{}, ignoring {} attachments", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), attachementList.size()});
            }
            messages.add(messageResponse);
        }
        messages.sort(Comparator.comparingLong(GptChatMessage::getTimestamp).thenComparing(GptChatMessage::getRole, Comparator.reverseOrder()));
        conversation.setMessages(messages);
        return latestTimestamp;
    }

    public ThreadMessage getMessage(AssistantThread thread, String messageId) {
        return this.assistantsOpenAIClient.getMessage(thread.getId(), messageId);
    }

    private List<GptChatMessage> populateMissingThreadMessagesWithRuns(String id, List<ThreadMessage> threadMessages, @Nullable Integer limit) {
        ArrayList<GptChatMessage> messages = new ArrayList<GptChatMessage>();
        PageableList threadRunsPageableList = this.assistantsOpenAIClient.listRuns(id, limit, ListSortOrder.ASCENDING, null, null);
        List threadRuns = threadRunsPageableList != null ? threadRunsPageableList.getData() : Collections.emptyList();
        for (int i = 0; i < threadMessages.size(); ++i) {
            ThreadMessage message = threadMessages.get(i);
            if (!"user".equals(message.getRole().getValue())) continue;
            if (i + 1 < threadMessages.size()) {
                ThreadMessage nextMessage = threadMessages.get(i + 1);
                if ("assistant".equals(nextMessage.getRole().getValue())) continue;
                this.extractRunInfoInsteadOfMessage(messages, threadRuns, message);
                continue;
            }
            if (i != threadMessages.size() - 1) continue;
            this.extractRunInfoInsteadOfMessage(messages, threadRuns, message);
        }
        return messages;
    }

    private void extractRunInfoInsteadOfMessage(List<GptChatMessage> messages, List<ThreadRun> threadRuns, ThreadMessage message) {
        OffsetDateTime messageCreatedAt = message.getCreatedAt();
        ThreadRun firstAfter = null;
        GptChatMessage messageResponse = new GptChatMessage();
        for (ThreadRun threadRun : threadRuns) {
            OffsetDateTime runCreatedAt = threadRun.getCreatedAt();
            if (!runCreatedAt.isAfter(messageCreatedAt) && !runCreatedAt.isEqual(messageCreatedAt) || firstAfter != null && !runCreatedAt.isBefore(firstAfter.getCreatedAt())) continue;
            firstAfter = threadRun;
        }
        if (firstAfter != null) {
            messageResponse.setAgentId(firstAfter.getAssistantId());
            messageResponse.setRole(MessageRole.ASSISTANT.toString());
            messageResponse.setConversationId(firstAfter.getThreadId());
            messageResponse.setTimestamp(firstAfter.getCreatedAt().toEpochSecond());
            RunCompletionUsage runCompletionUsage = firstAfter.getUsage();
            Usage usage = new Usage();
            if (runCompletionUsage != null) {
                usage = new Usage(runCompletionUsage.getCompletionTokens(), runCompletionUsage.getPromptTokens(), runCompletionUsage.getTotalTokens());
            }
            messageResponse.setUsage(usage);
        }
        if (this.setCustomMessageContentBasedOnStatus(messages, firstAfter, messageResponse)) {
            return;
        }
        messages.add(messageResponse);
    }

    public boolean setCustomMessageContentBasedOnStatus(List<GptChatMessage> messages, ThreadRun threadRun, GptChatMessage messageResponse) {
        if (threadRun != null && threadRun.getStatus() == RunStatus.CANCELLED) {
            messageResponse.setMessage("Request cancelled by the user.");
            messageResponse.setTerminalState(true);
            messageResponse.setTerminalStatusCode(TerminalStatus.CANCELLED);
            messages.add(messageResponse);
            return true;
        }
        if (threadRun != null && threadRun.getStatus() == RunStatus.EXPIRED) {
            messageResponse.setMessage("Request expired before completion.");
            messageResponse.setTerminalState(true);
            messageResponse.setTerminalStatusCode(TerminalStatus.EXPIRED);
            messages.add(messageResponse);
            return true;
        }
        if (threadRun != null && threadRun.getStatus() == RunStatus.FAILED) {
            messageResponse.setMessage("Request failed due to an error.");
            messageResponse.setTerminalState(true);
            messageResponse.setTerminalStatusCode(TerminalStatus.FAILED);
            messages.add(messageResponse);
            return true;
        }
        if (threadRun != null && threadRun.getStatus() == RunStatus.CANCELLING) {
            messageResponse.setMessage("Request in process of termination.");
            messageResponse.setTerminalState(true);
            messageResponse.setTerminalStatusCode(TerminalStatus.CANCELLING);
            messages.add(messageResponse);
            return true;
        }
        return false;
    }
}

