/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.gpt.chat.GptChat;
import com.ontotext.forest.gpt.chat.completions.GptChatInstanceHolder;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.forest.gpt.ttyg.AgentInstructions;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericClientException;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericServerException;
import com.ontotext.forest.gpt.ttyg.tools.SPARQLQueryTool;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.forest.gpt.ttyg.tools.openapi.OpenApiToolConfig;
import com.ontotext.forest.gpt.ttyg.tools.openapi.OpenApiToolDefinition;
import com.ontotext.forest.gpt.ttyg.tools.openapi.OpenApiTools;
import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.graphdb.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LLMService {
    private final SemanticDataManagement dataManagement;
    private final GptChatInstanceHolder gptChatInstanceHolder;
    private final ObjectMapper yamlReader;
    private final Path configPath;
    private Map<String, OpenApiToolConfig> staticToolConfigs;
    private long staticToolConfigsTimestamp;

    @Autowired
    public LLMService(SemanticDataManagement dataManagement, GptChatInstanceHolder gptChatInstanceHolder) {
        this.dataManagement = dataManagement;
        this.gptChatInstanceHolder = gptChatInstanceHolder;
        this.yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.configPath = Paths.get(Config.getConfDirectory(), "llm-tools.yaml");
    }

    public GptChat getGptChatInstance() {
        return this.gptChatInstanceHolder.getGPTChatInstance();
    }

    public String callTool(String configId, String configType, ToolType toolType, String arguments) {
        OpenApiToolConfig config = this.getOpenApiToolConfig(configId, configType);
        SecurityUtils.checkRepositoryAccess((String)config.getRepositoryId(), (boolean)false);
        try (RepositoryConnection connection = this.getRepositoryConnection(config.getRepositoryId());){
            Tool tool = config.getTools().get((Object)toolType);
            if (tool == null || !tool.isEnabled()) {
                throw new GenericClientException("Tool is not enabled for ID " + configId);
            }
            String string = this.getGptChatInstance().callTool(tool, arguments, null, connection);
            return string;
        }
    }

    public String getOntology(String configId, String configType) {
        OpenApiToolConfig config = this.getOpenApiToolConfig(configId, configType);
        SecurityUtils.checkRepositoryAccess((String)config.getRepositoryId(), (boolean)false);
        try (RepositoryConnection connection = this.getRepositoryConnection(config.getRepositoryId());){
            Tool tool = config.getTools().get((Object)ToolType.SPARQL_QUERY);
            if (tool == null || !tool.isEnabled()) {
                throw new GenericClientException("Could not load ontology for config '" + configId + "', because 'sparql_query' tool is not enabled");
            }
            String string = ((SPARQLQueryTool)tool).extractOntology(connection);
            return string;
        }
    }

    public String getSparqlInstructions(String configId, String configType) {
        OpenApiToolConfig config = this.getOpenApiToolConfig(configId, configType);
        SecurityUtils.checkRepositoryAccess((String)config.getRepositoryId(), (boolean)false);
        try (RepositoryConnection connection = this.getRepositoryConnection(config.getRepositoryId());){
            Tool tool = config.getTools().get((Object)ToolType.SPARQL_QUERY);
            if (tool == null || !tool.isEnabled()) {
                throw new GenericClientException("Could not load sparql instructions for config '" + configId + "', because 'sparql_query' tool is not enabled");
            }
            AgentInstructions instr = new AgentInstructions();
            instr.setBaseInstructions("");
            instr.setAdditionalInstructions("");
            ((SPARQLQueryTool)tool).applyOntologyInstructions(instr, connection);
            String string = instr.assemble();
            return string;
        }
    }

    public OpenApiTools getOpenApiTools(String configId, String configType, String url) {
        OpenApiToolConfig config = this.getOpenApiToolConfig(configId, configType);
        List<OpenApiToolDefinition> toolDefs = config.getTools().values().stream().filter(Tool::isEnabled).map(OpenApiToolDefinition::new).toList();
        return new OpenApiTools(configId, url, toolDefs);
    }

    private Map<String, OpenApiToolConfig> getStaticToolConfigs() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            try {
                long fileUpdatedAt = Files.getLastModifiedTime(this.configPath, new LinkOption[0]).toMillis();
                if (this.staticToolConfigs == null || fileUpdatedAt != this.staticToolConfigsTimestamp) {
                    this.staticToolConfigs = (Map)this.yamlReader.readValue(this.configPath.toFile(), (TypeReference)new TypeReference<Map<String, OpenApiToolConfig>>(this){});
                    this.staticToolConfigsTimestamp = fileUpdatedAt;
                }
            }
            catch (IOException e) {
                throw new GenericServerException("Could not load static tool configs", e);
            }
            return this.staticToolConfigs;
        }
        return Map.of();
    }

    private OpenApiToolConfig getStaticToolConfig(String configId) {
        OpenApiToolConfig config = this.getStaticToolConfigs().get(configId);
        if (config == null) {
            throw new GenericClientException("No config found for ID " + configId);
        }
        return config;
    }

    private RepositoryConnection getRepositoryConnection(String repositoryId) {
        return this.dataManagement.getCurrentLocationOrThrow().getRepository(repositoryId).getRepository().getConnection();
    }

    private OpenApiToolConfig getAgentOpenApiToolConfig(String agentId) {
        AgentConfig agent = this.getGptChatInstance().getAgentConfig(agentId);
        OpenApiToolConfig config = new OpenApiToolConfig();
        config.setRepositoryId(agent.getRepositoryId());
        config.setTools(new AgentConfig.ToolMap(agent.getTools()));
        return config;
    }

    @VisibleForTesting
    @NotNull
    OpenApiToolConfig getOpenApiToolConfig(String configId, String configType) {
        return switch (configType) {
            case "ttyg" -> this.getAgentOpenApiToolConfig(configId);
            case "yaml" -> this.getStaticToolConfig(configId);
            default -> throw new IllegalArgumentException("Unsupported config type: " + configType + ". The supported types are: ttyg, yaml");
        };
    }
}

