/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.mongodb;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.ontotext.trree.plugin.mongodb.MongoDBPlugin;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;

public class IdFinder {
    private MongoDBPlugin plugin;
    private static final int MAX_DEPTH = 3;

    public IdFinder(MongoDBPlugin plugin) {
        this.plugin = plugin;
    }

    private static String getStringValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JsonString) {
            JsonString jsonString = (JsonString)obj;
            return jsonString.getString();
        }
        return obj.toString();
    }

    public String extractRootUri(Map<String, ? extends Object> doc) {
        Object item;
        String uri = null;
        if (doc.containsKey("@graph") && (item = doc.get("@graph")) != null) {
            if (item instanceof List) {
                List listItem = (List)item;
                if (!listItem.isEmpty() && listItem.getFirst() instanceof Map) {
                    Map graphDoc = (Map)listItem.getFirst();
                    uri = IdFinder.getStringValue(graphDoc.get("@id"));
                    if (listItem.size() > 1) {
                        this.plugin.getLogger().warn("Multiple graphs in mongo document. Selecting the first one for entity: " + uri);
                    }
                } else {
                    this.plugin.getLogger().warn("Value of @graph must be a valid document in mongo document.");
                }
            } else if (item instanceof Map) {
                Map graphDoc = (Map)item;
                uri = IdFinder.getStringValue(graphDoc.get("@id"));
            } else {
                this.plugin.getLogger().warn("@graph must be a document or list of documents in mongo document.");
            }
        }
        if (uri == null) {
            uri = IdFinder.getStringValue(doc.get("@id"));
        }
        return uri;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String extractRootUri(String json) {
        try (StringReader reader = new StringReader(json);){
            String string;
            block21: {
                JsonArray expanded;
                JsonParser parser;
                block19: {
                    String string2;
                    block20: {
                        block17: {
                            String string3;
                            block18: {
                                parser = Json.createParser((Reader)reader);
                                try {
                                    if (parser.hasNext()) break block17;
                                    string3 = null;
                                    if (parser == null) break block18;
                                }
                                catch (Throwable throwable) {
                                    if (parser != null) {
                                        try {
                                            parser.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                parser.close();
                            }
                            return string3;
                        }
                        parser.next();
                        JsonObject root = parser.getObject();
                        JsonObject prunedRoot = (JsonObject)this.pruneTree((JsonValue)root, 0);
                        expanded = JsonLd.expand((Document)JsonDocument.of((JsonStructure)prunedRoot)).get();
                        if (!expanded.isEmpty()) break block19;
                        string2 = null;
                        if (parser == null) break block20;
                        parser.close();
                    }
                    return string2;
                }
                JsonObject mainNode = expanded.getJsonObject(0);
                string = this.extractRootUri((Map<String, ? extends Object>)mainNode);
                if (parser == null) break block21;
                parser.close();
            }
            return string;
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Exception while trying to find root ID by expanding the JSON-LD document", (Throwable)e);
            return null;
        }
    }

    private JsonValue pruneTree(JsonValue value, int currentDepth) {
        if (value == null) {
            return JsonValue.NULL;
        }
        if (IdFinder.isPrimitive(value)) {
            return value;
        }
        if (currentDepth >= 3) {
            return JsonValue.NULL;
        }
        if (value.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject obj = value.asJsonObject();
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry entry : obj.entrySet()) {
                if (((String)entry.getKey()).equals("@context")) {
                    builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
                    continue;
                }
                JsonValue child = this.pruneTree((JsonValue)entry.getValue(), currentDepth + 1);
                if (child == JsonValue.NULL) continue;
                builder.add((String)entry.getKey(), child);
            }
            return builder.build();
        }
        if (value.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonValue child;
            JsonArray arr = value.asJsonArray();
            JsonArrayBuilder builder = Json.createArrayBuilder();
            if (!arr.isEmpty() && (child = this.pruneTree((JsonValue)arr.get(0), currentDepth + 1)) != JsonValue.NULL) {
                builder.add(child);
            }
            return builder.build();
        }
        return JsonValue.NULL;
    }

    private static boolean isPrimitive(JsonValue value) {
        JsonValue.ValueType type = value.getValueType();
        return type == JsonValue.ValueType.STRING || type == JsonValue.ValueType.NUMBER || type == JsonValue.ValueType.TRUE || type == JsonValue.ValueType.FALSE;
    }
}

