/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.mongodb;

import com.ontotext.trree.sdk.PluginException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class EncoderWrapper
implements Encoder<Document> {
    private Encoder<Document> encoder;

    public EncoderWrapper(Encoder<Document> encoder) {
        this.encoder = encoder;
    }

    public void encode(BsonWriter writer, Document value, EncoderContext encoderContext) {
        this.encoder.encode((BsonWriter)new BsonWriterWrapper(this, writer), (Object)value, encoderContext);
    }

    public Class<Document> getEncoderClass() {
        return this.encoder.getEncoderClass();
    }

    private class BsonWriterWrapper
    implements BsonWriter {
        private BsonWriter writer;

        public BsonWriterWrapper(EncoderWrapper encoderWrapper, BsonWriter writer) {
            this.writer = writer;
        }

        public void flush() {
            this.writer.flush();
        }

        public void writeBinaryData(BsonBinary binary) {
            this.writer.writeBinaryData(binary);
        }

        public void writeBinaryData(String name, BsonBinary binary) {
            this.writer.writeBinaryData(name, binary);
        }

        public void writeBoolean(boolean value) {
            this.writer.writeBoolean(value);
        }

        public void writeBoolean(String name, boolean value) {
            this.writer.writeBoolean(name, value);
        }

        public void writeDateTime(long value) {
            this.writer.writeDateTime(value);
        }

        public void writeDateTime(String name, long value) {
            this.writer.writeDateTime(name, value);
        }

        public void writeDBPointer(BsonDbPointer value) {
            this.writer.writeDBPointer(value);
        }

        public void writeDBPointer(String name, BsonDbPointer value) {
            this.writer.writeDBPointer(name, value);
        }

        public void writeDouble(double value) {
            this.writer.writeDouble(value);
        }

        public void writeDouble(String name, double value) {
            this.writer.writeDouble(name, value);
        }

        public void writeEndArray() {
            this.writer.writeEndArray();
        }

        public void writeEndDocument() {
            this.writer.writeEndDocument();
        }

        public void writeInt32(int value) {
            this.writer.writeInt32(value);
        }

        public void writeInt32(String name, int value) {
            this.writer.writeInt32(name, value);
        }

        public void writeInt64(long value) {
            this.writer.writeInt64(value);
        }

        public void writeInt64(String name, long value) {
            this.writer.writeInt64(name, value);
        }

        public void writeDecimal128(Decimal128 value) {
            this.writer.writeDecimal128(value);
        }

        public void writeDecimal128(String name, Decimal128 value) {
            this.writer.writeDecimal128(name, value);
        }

        public void writeJavaScript(String code) {
            this.writer.writeJavaScript(code);
        }

        public void writeJavaScript(String name, String code) {
            this.writer.writeJavaScript(name, code);
        }

        public void writeJavaScriptWithScope(String code) {
            this.writer.writeJavaScriptWithScope(code);
        }

        public void writeJavaScriptWithScope(String name, String code) {
            this.writer.writeJavaScriptWithScope(name, code);
        }

        public void writeMaxKey() {
            this.writer.writeMaxKey();
        }

        public void writeMaxKey(String name) {
            this.writer.writeMaxKey(name);
        }

        public void writeMinKey() {
            this.writer.writeMinKey();
        }

        public void writeMinKey(String name) {
            this.writer.writeMinKey(name);
        }

        public void writeName(String name) {
            try {
                this.writer.writeName(URLDecoder.decode(name, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new PluginException("Could not decode JSON key: " + name, (Throwable)e);
            }
        }

        public void writeNull() {
            this.writer.writeNull();
        }

        public void writeNull(String name) {
            this.writer.writeNull(name);
        }

        public void writeObjectId(ObjectId objectId) {
            this.writer.writeObjectId(objectId);
        }

        public void writeObjectId(String name, ObjectId objectId) {
            this.writer.writeObjectId(name, objectId);
        }

        public void writeRegularExpression(BsonRegularExpression regularExpression) {
            this.writer.writeRegularExpression(regularExpression);
        }

        public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
            this.writer.writeRegularExpression(name, regularExpression);
        }

        public void writeStartArray() {
            this.writer.writeStartArray();
        }

        public void writeStartArray(String name) {
            this.writer.writeStartArray(name);
        }

        public void writeStartDocument() {
            this.writer.writeStartDocument();
        }

        public void writeStartDocument(String name) {
            this.writer.writeStartDocument(name);
        }

        public void writeString(String value) {
            this.writer.writeString(value);
        }

        public void writeString(String name, String value) {
            this.writer.writeString(name, value);
        }

        public void writeSymbol(String value) {
            this.writer.writeSymbol(value);
        }

        public void writeSymbol(String name, String value) {
            this.writer.writeSymbol(name, value);
        }

        public void writeTimestamp(BsonTimestamp value) {
            this.writer.writeTimestamp(value);
        }

        public void writeTimestamp(String name, BsonTimestamp value) {
            this.writer.writeTimestamp(name, value);
        }

        public void writeUndefined() {
            this.writer.writeUndefined();
        }

        public void writeUndefined(String name) {
            this.writer.writeUndefined(name);
        }

        public void pipe(BsonReader reader) {
            this.writer.pipe(reader);
        }
    }
}

