/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.mongodb;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.SchemeRouter;
import java.io.Closeable;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class CachingDocumentLoader
implements DocumentLoader,
Closeable {
    private static final String DISALLOW_REMOTE_CONTEXT_LOADING = "graphdb.disallow.remote.context.loading";
    private static final DocumentLoader DEFAULT_LOADER = SchemeRouter.defaultInstance();
    private final Map<URI, Document> documentCache = new LinkedHashMap<URI, Document>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<URI, Document> eldest) {
            return CachingDocumentLoader.this.documentCache.size() > 1000;
        }
    };

    public Document loadDocument(URI uri, DocumentLoaderOptions options) throws JsonLdError {
        if (this.documentCache.containsKey(uri)) {
            try {
                return this.documentCache.get(uri);
            }
            catch (Exception e) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, String.valueOf(uri) + " " + e.getMessage());
            }
        }
        String disallowRemote = System.getProperty(DISALLOW_REMOTE_CONTEXT_LOADING);
        if ("true".equalsIgnoreCase(disallowRemote)) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Remote context loading has been disallowed (uri was " + String.valueOf(uri) + ")");
        }
        try {
            Document remoteDocument = DEFAULT_LOADER.loadDocument(uri, options);
            this.documentCache.put(uri, remoteDocument);
            return remoteDocument;
        }
        catch (Exception e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, String.valueOf(uri) + " " + e.getMessage());
        }
    }

    @Override
    public void close() {
        this.documentCache.clear();
    }
}

