/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.persistence.properties;

import com.ontotext.forest.core.properties.AskablePropertyPlaceholderConfigurer;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.graphdb.ServerMaintenanceListener;
import jakarta.inject.Named;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

@Named
public class PersistentPropertyPlaceholderConfigurer
extends AskablePropertyPlaceholderConfigurer
implements ServerMaintenanceListener {
    public static final String PERSISTENCE_PROPERTIES = "properties";
    private PersistedConfig persistedConfig;
    private BeanFactory beanFactory;
    private static final String NAME = "persisted properties";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, String> properties = new HashMap<String, String>();

    public void unlockAfterMaintenance() {
        this.persistedConfig = null;
    }

    public int getOrderIndex() {
        return 200;
    }

    public int getOrder() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.persistedConfig == null) {
            PersistentPropertyPlaceholderConfigurer persistentPropertyPlaceholderConfigurer = this;
            synchronized (persistentPropertyPlaceholderConfigurer) {
                if (this.persistedConfig == null) {
                    try {
                        this.persistedConfig = (PersistedConfig)this.beanFactory.getBean("persistedConfig", PersistedConfig.class);
                        this.properties = this.persistedConfig.getMap(PERSISTENCE_PROPERTIES, String.class);
                    }
                    catch (BeanCurrentlyInCreationException e) {
                        logger.debug("Skipping initialization of PersistentPropertyPlaceholderConfigurer while configuring beans.");
                    }
                }
            }
        }
    }

    public void setProperty(String key, String value) {
        this.lazyInit();
        this.properties.put(key, value);
        this.persistedConfig.updateMapEntry(PERSISTENCE_PROPERTIES, String.class, key, value);
    }

    public Object getProperty(String key) {
        this.lazyInit();
        return this.properties.get(key);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Map<String, Object> getProperties() {
        this.lazyInit();
        return this.properties;
    }

    public String getPropertySource(String key) {
        return NAME;
    }
}

