/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.persistence;

import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.persistence.JsonDB;
import com.ontotext.graphdb.ServerMaintenanceListener;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class PersistedConfig
implements ServerMaintenanceListener {
    @Autowired
    private ResourceUtils resourceUtils;
    protected File storageDirectory;
    protected static final String fileName = "settings.js";
    protected final Lock lock = new ReentrantLock();
    protected JsonDB db;
    public Map<String, Object> properties;

    PersistedConfig() {
    }

    public static PersistedConfig fromDirectory(File directory) {
        PersistedConfig persistedConfig = new PersistedConfig();
        persistedConfig.init(directory);
        return persistedConfig;
    }

    @PostConstruct
    public void init() {
        this.init(this.resourceUtils.getApplicationDataDir());
    }

    protected void init(File storageDirectory) {
        this.storageDirectory = storageDirectory;
        this.db = new JsonDB(PersistedConfig.getDBFile(storageDirectory, fileName).toPath());
    }

    protected static File getDBFile(File applicationDir, String fileName) {
        return new File(applicationDir, fileName);
    }

    public <T> Map<String, T> getMap(String key, Class<T> type) {
        this.lock.lock();
        try {
            Map<String, T> map = this.db.getMap(key, type);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load persisted data.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> Map<String, T> getMapMap(String outerKey, String innerKey, Class<T> type) {
        this.lock.lock();
        try {
            Map<String, T> map = this.db.getMapMap(outerKey, innerKey, type);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load persisted data.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> Map<String, Map<String, T>> getMapOfMaps(String outerKey, Class<T> type) {
        this.lock.lock();
        try {
            Map<String, Map<String, T>> map = this.db.getMapOfMaps(outerKey, type);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load persisted data.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateMapEntry(String key, Class<T> type, String entryKey, T entry) {
        this.lock.lock();
        try {
            this.updateMapEntry(key, type, entryKey, entry, (oldValue, newValue) -> {});
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateMapEntry(String key, Class<T> type, String entryKey, T entry, ValueMapper<T> updater) {
        this.lock.lock();
        try {
            Map<String, T> map = this.getMap(key, type);
            T oldEntry = map.get(entryKey);
            updater.mapOldToNew(oldEntry, entry);
            map.put(entryKey, entry);
            this.db.saveMap(key, map, type);
            this.db.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateMapEntries(String key, Class<T> type, Map<String, T> updateEntries) {
        this.lock.lock();
        try {
            Map<String, T> map = this.getMap(key, type);
            for (String entryKey : updateEntries.keySet()) {
                map.put(entryKey, updateEntries.get(entryKey));
            }
            this.db.saveMap(key, map, type);
            this.db.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateMapMapEntries(String outerKey, String innerKey, Class<T> type, Map<String, T> updateEntries) throws IOException {
        this.lock.lock();
        try {
            Map<String, T> map = this.getMapMap(outerKey, innerKey, type);
            for (String entryKey : updateEntries.keySet()) {
                map.put(entryKey, updateEntries.get(entryKey));
            }
            this.db.saveMapMap(outerKey, innerKey, map, type);
            this.db.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deleteMapEntry(String key, Class<T> type, String entryKey) {
        this.lock.lock();
        try {
            Map<String, T> map = this.getMap(key, type);
            T object = map.remove(entryKey);
            this.db.saveMap(key, map, type);
            this.db.commit();
            T t = object;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deleteMapEntries(String key) {
        this.lock.lock();
        try {
            this.db.deleteMap(key);
            this.db.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deleteMapMapEntry(String outerKey, String innerKey, Class<T> type, String entryKey) throws IOException {
        this.lock.lock();
        try {
            Map<String, T> map = this.getMapMap(outerKey, innerKey, type);
            T object = map.remove(entryKey);
            this.db.saveMapMap(outerKey, innerKey, map, type);
            this.db.commit();
            T t = object;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initMap(String key) {
        this.lock.lock();
        try {
            this.db.saveMap(key, Collections.emptyMap(), String.class);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void backupConfig() {
        this.lock.lock();
        try {
            this.db.backup(PersistedConfig.getDBFile(this.storageDirectory, "backup_settings.js"));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lockForMaintenance() {
        try {
            this.lock.tryLock(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void unlockAfterMaintenance() {
        this.lock.unlock();
        this.init();
    }

    public int getOrderIndex() {
        return 30;
    }

    public static interface ValueMapper<T> {
        public void mapOldToNew(T var1, T var2);
    }
}

