/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.persistence;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.ontotext.forest.core.serialization.UriJsonDeserializer;
import com.ontotext.forest.core.serialization.UriJsonSerializer;
import com.ontotext.graphdb.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonDB {
    private static Logger LOG = LoggerFactory.getLogger(JsonDB.class);
    private ObjectMapper objectMapper;
    private ObjectWriter objectWriter;
    private Path persistencePath;
    ObjectNode root;

    public JsonDB(Path persistencePath) {
        block10: {
            this.persistencePath = persistencePath;
            this.objectMapper = new ObjectMapper();
            this.objectMapper.configure(MapperFeature.USE_STATIC_TYPING, true);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SimpleModule module = new SimpleModule("Forest JsonDB Jackson");
            module.addSerializer(IRI.class, (JsonSerializer)new UriJsonSerializer());
            module.addDeserializer(IRI.class, (JsonDeserializer)new UriJsonDeserializer());
            this.objectMapper.registerModule((Module)module);
            this.objectWriter = this.objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            if (!Files.exists(persistencePath, new LinkOption[0]) && persistencePath.endsWith("settings.js")) {
                this.moveLegacySettings(persistencePath);
            }
            try {
                if (!Files.exists(persistencePath, new LinkOption[0])) break block10;
                try (FileInputStream is = new FileInputStream(persistencePath.toFile());){
                    this.root = (ObjectNode)this.objectMapper.readTree((InputStream)is);
                }
            }
            catch (Exception e) {
                LOG.error("Error loading Workbench settings, using the defaults.", (Throwable)e);
                this.backup(new File(String.valueOf(persistencePath) + ".broken"));
            }
        }
        if (this.root != null) {
            this.commit();
        } else {
            this.root = JsonNodeFactory.instance.objectNode();
        }
    }

    <T> Map<String, T> getMap(String key, Class<T> type) throws IOException {
        JsonNode node = this.root.get(key);
        if (node == null) {
            return new HashMap();
        }
        return (Map)this.objectMapper.readerFor((JavaType)this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, type)).readValue(node);
    }

    <T> Map<String, Map<String, T>> getMapOfMaps(String outerKey, Class<T> type) throws IOException {
        JsonNode node = this.root.get(outerKey);
        if (node == null) {
            return new HashMap<String, Map<String, T>>();
        }
        return (Map)this.objectMapper.readerFor(this.createMapMapType(type)).readValue(node);
    }

    <T> Map<String, T> getMapMap(String outerKey, String innerKey, Class<T> type) throws IOException {
        JsonNode node = this.root.get(outerKey);
        if (node == null) {
            return new HashMap();
        }
        Map outerMap = (Map)this.objectMapper.readerFor(this.createMapMapType(type)).readValue(node);
        Map innerMap = (Map)outerMap.get(innerKey);
        if (innerMap == null) {
            return new HashMap();
        }
        return innerMap;
    }

    void saveMap(String key, Map<String, ?> map, Class<?> type) {
        JsonNode node = this.valueToTree(map, (JavaType)this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, type));
        this.root.set(key, node);
    }

    void deleteMap(String key) {
        this.root.remove(key);
    }

    <T> void saveMapMap(String outerKey, String innerKey, Map<String, T> map, Class<T> type) throws IOException {
        JavaType mapMapType = this.createMapMapType(type);
        JsonNode node = this.root.get(outerKey);
        Map<String, Map<String, Object>> outerMap = node != null ? (Map)this.objectMapper.readerFor(mapMapType).readValue(node) : new HashMap<String, Map<String, T>>();
        outerMap.put(innerKey, map);
        this.root.set(outerKey, this.valueToTree(outerMap, mapMapType));
    }

    private JsonNode valueToTree(Object value, JavaType type) throws IllegalArgumentException {
        JsonNode result;
        TokenBuffer buf = new TokenBuffer((ObjectCodec)this.objectMapper, false);
        try {
            this.objectMapper.writerFor(type).writeValue((JsonGenerator)buf, value);
            JsonParser jp = buf.asParser();
            result = (JsonNode)this.objectMapper.readTree(jp);
            jp.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return result;
    }

    public synchronized void commit() {
        try (FileOutputStream os = new FileOutputStream(this.persistencePath.toFile());){
            this.objectWriter.writeValue((OutputStream)os, (Object)this.root);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to persist changes.", e);
        }
    }

    public synchronized void backup(File backupFile) {
        try {
            FileUtils.copyFile((File)this.persistencePath.toFile(), (File)backupFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate backup.", e);
        }
    }

    private JavaType createMapMapType(Class<?> type) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        return typeFactory.constructMapType(Map.class, typeFactory.constructType(String.class), (JavaType)typeFactory.constructMapType(Map.class, String.class, type));
    }

    private void moveLegacySettings(Path persistencePath) {
        String defaultValue = Paths.get(Config.getWorkDirectory(), "workbench").toString();
        String dataDir = Config.getProperty((String)"graphdb.workbench.datadir", (String)System.getProperty("app.datadir", defaultValue));
        File oldSettings = new File(dataDir, "settings.js");
        if (oldSettings.exists()) {
            try {
                Files.move(oldSettings.toPath(), persistencePath, new CopyOption[0]);
            }
            catch (IOException e) {
                LOG.error("Legacy settings discovered but were unable to be loaded, using the defaults.", (Throwable)e);
            }
        }
    }
}

