/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.query.resultset.OntopBinding;
import it.unibz.inf.ontop.query.resultset.OntopBindingSet;
import it.unibz.inf.ontop.rdf4j.utils.RDF4JHelper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

public class OntopRDF4JBindingSet
extends AbstractBindingSet
implements BindingSet {
    private final OntopBindingSet ontopBindingSet;

    public OntopRDF4JBindingSet(OntopBindingSet ontopBindingSet) {
        this.ontopBindingSet = ontopBindingSet;
    }

    public @Nullable Binding getBinding(String bindingName) {
        OntopBinding ontopBinding = this.ontopBindingSet.getBinding(bindingName);
        return ontopBinding == null ? null : this.convertBinding(ontopBinding);
    }

    public Set<String> getBindingNames() {
        return Arrays.stream(this.ontopBindingSet.getBindingNames()).collect(Collectors.toSet());
    }

    public @Nullable Value getValue(String variableName) {
        try {
            RDFConstant constant = this.ontopBindingSet.getConstant(variableName);
            return constant == null ? null : RDF4JHelper.getValue(constant);
        }
        catch (OntopResultConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasBinding(String bindingName) {
        return this.ontopBindingSet.hasBinding(bindingName);
    }

    public @Nonnull Iterator<Binding> iterator() {
        return Arrays.stream(this.ontopBindingSet.getBindings()).map(this::convertBinding).iterator();
    }

    private Binding convertBinding(OntopBinding ontopBinding) {
        return new SimpleBinding(ontopBinding.getName(), RDF4JHelper.getValue(ontopBinding.getValue()));
    }

    public int size() {
        return this.ontopBindingSet.getBindingNames().length;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }
}

