/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.predefined.impl;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.utils.JsonUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import it.unibz.inf.ontop.answering.OntopQueryEngine;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.query.ConstructTemplate;
import it.unibz.inf.ontop.query.KGQuery;
import it.unibz.inf.ontop.query.RDF4JQuery;
import it.unibz.inf.ontop.rdf4j.jsonld.EmptyResultException;
import it.unibz.inf.ontop.rdf4j.jsonld.FramedJSONLDWriterFactory;
import it.unibz.inf.ontop.rdf4j.predefined.InvalidBindingSetException;
import it.unibz.inf.ontop.rdf4j.predefined.LateEvaluationOrConversionException;
import it.unibz.inf.ontop.rdf4j.predefined.OntopRDF4JPredefinedQueryEngine;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedGraphQuery;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedQueries;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedQuery;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedTupleQuery;
import it.unibz.inf.ontop.rdf4j.predefined.impl.ReferenceValueReplacer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.JSONLDMode;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopRDF4JPredefinedQueryEngineImpl
implements OntopRDF4JPredefinedQueryEngine {
    private final OntopQueryEngine ontopEngine;
    private final ImmutableMap<String, PredefinedGraphQuery> graphQueries;
    private final ImmutableMap<String, PredefinedTupleQuery> tupleQueries;
    private final QueryReformulator queryReformulator;
    private final QueryLogger.Factory queryLoggerFactory;
    private final QueryContext.Factory queryContextFactory;
    private final Cache<ImmutableMap<String, String>, IQ> referenceQueryCache;
    private final ReferenceValueReplacer valueReplacer;
    private final DocumentLoader documentLoader;
    private static final Logger LOGGER = LoggerFactory.getLogger(OntopRDF4JPredefinedQueryEngineImpl.class);
    private final SecureRandom random;

    public OntopRDF4JPredefinedQueryEngineImpl(OntopQueryEngine ontopEngine, PredefinedQueries predefinedQueries, OntopSystemConfiguration configuration) {
        this.ontopEngine = ontopEngine;
        this.graphQueries = predefinedQueries.getGraphQueries();
        this.tupleQueries = predefinedQueries.getTupleQueries();
        this.queryReformulator = ontopEngine.getQueryReformulator();
        Injector injector = configuration.getInjector();
        this.queryLoggerFactory = this.queryReformulator.getQueryLoggerFactory();
        this.queryContextFactory = this.queryReformulator.getQueryContextFactory();
        this.valueReplacer = (ReferenceValueReplacer)injector.getInstance(ReferenceValueReplacer.class);
        this.referenceQueryCache = CacheBuilder.newBuilder().build();
        this.documentLoader = new DocumentLoader();
        predefinedQueries.getContextMap().forEach((k, m) -> {
            try {
                this.documentLoader.addInjectedDoc(k, JsonUtils.toString((Object)m));
            }
            catch (IOException e) {
                throw new MinorOntopInternalBugException("Unexpected issue when serialize a parsed JSON element");
            }
        });
        this.random = new SecureRandom();
    }

    @Override
    public void evaluate(String queryId, ImmutableMap<String, String> bindings, ImmutableList<String> acceptMediaTypes, ImmutableMap<String, String> httpHeaders, Consumer<Integer> httpStatusSetter, BiConsumer<String, String> httpHeaderSetter, OutputStream outputStream) throws LateEvaluationOrConversionException {
        Optional<Query.QueryType> optionalQueryType = this.getQueryType(queryId);
        if (!optionalQueryType.isPresent()) {
            httpStatusSetter.accept(404);
            return;
        }
        switch (optionalQueryType.get()) {
            case BOOLEAN: {
                throw new RuntimeException("TODO: support ask queries");
            }
            case GRAPH: {
                this.evaluateGraphWithHandler((PredefinedGraphQuery)this.graphQueries.get((Object)queryId), bindings, acceptMediaTypes, httpHeaders, httpHeaderSetter, httpStatusSetter, outputStream);
                break;
            }
            case TUPLE: {
                this.evaluateTupleWithHandler(queryId, bindings, acceptMediaTypes, httpHeaders, httpHeaderSetter, httpStatusSetter, outputStream);
                break;
            }
            default: {
                throw new MinorOntopInternalBugException("Unexpected query type");
            }
        }
    }

    @Override
    public String evaluate(String queryId, ImmutableMap<String, String> bindings, ImmutableList<String> acceptMediaTypes, ImmutableMap<String, String> httpHeaders, Consumer<Integer> httpStatusSetter, BiConsumer<String, String> httpHeaderSetter) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.evaluate(queryId, bindings, acceptMediaTypes, httpHeaders, httpStatusSetter, httpHeaderSetter, outputStream);
            return outputStream.toString(StandardCharsets.UTF_8);
        }
        catch (LateEvaluationOrConversionException e) {
            httpStatusSetter.accept(500);
            return e.getMessage();
        }
    }

    @Override
    public boolean shouldStream(String queryId) {
        if (this.graphQueries.containsKey((Object)queryId)) {
            return ((PredefinedGraphQuery)this.graphQueries.get((Object)queryId)).isResultStreamingEnabled();
        }
        if (this.tupleQueries.containsKey((Object)queryId)) {
            return ((PredefinedTupleQuery)this.tupleQueries.get((Object)queryId)).isResultStreamingEnabled();
        }
        return false;
    }

    private void evaluateGraphWithHandler(PredefinedGraphQuery predefinedQuery, ImmutableMap<String, String> bindings, ImmutableList<String> acceptMediaTypes, ImmutableMap<String, String> httpHeaders, BiConsumer<String, String> httpHeaderSetter, Consumer<Integer> httpStatusSetter, OutputStream outputStream) throws LateEvaluationOrConversionException {
        RDFWriterRegistry registry = RDFWriterRegistry.getInstance();
        Stream<String> mediaTypes = acceptMediaTypes.stream().filter(s -> !s.equals("application/xml"));
        Optional<RDFFormat> optionalFormat = this.extractFormat(mediaTypes, (FileFormatServiceRegistry)registry, (FileFormat)RDFFormat.JSONLD, m -> Optional.of(m).filter(a -> a.contains("json")).map(a -> RDFFormat.JSONLD));
        if (!optionalFormat.isPresent()) {
            httpStatusSetter.accept(406);
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.println("Not acceptable. Suggested format: application/ld+json .");
            printWriter.flush();
            return;
        }
        RDFFormat rdfFormat = optionalFormat.get();
        RDFWriterFactory rdfWriterFactory = predefinedQuery.getJsonLdFrame().filter(f -> rdfFormat.equals((Object)RDFFormat.JSONLD)).map(jsonLdFrame -> this.createJSONLDFrameWriterFactory((Map<String, Object>)jsonLdFrame, predefinedQuery.shouldReturn404IfEmpty())).orElseGet(() -> (RDFWriterFactory)registry.get((Object)rdfFormat).orElseThrow(() -> new MinorOntopInternalBugException("The selected RDF format should have a writer factory")));
        QueryLogger queryLogger = this.createQueryLogger(predefinedQuery, bindings, httpHeaders);
        try {
            IQ executableQuery = this.createExecutableQuery(predefinedQuery, bindings, queryLogger);
            httpHeaderSetter.accept("Content-Type", rdfFormat.getDefaultMIMEType() + ";charset=UTF-8");
            RDFWriter handler = rdfWriterFactory.getWriter(outputStream);
            if (rdfFormat.equals((Object)RDFFormat.JSONLD)) {
                handler.set((RioSetting)JSONLDSettings.USE_NATIVE_TYPES, (Object)true);
                handler.set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.COMPACT);
            }
            try (GraphQueryResult result = this.executeConstructQuery(predefinedQuery.getConstructTemplate(), executableQuery, queryLogger);){
                handler.startRDF();
                while (result.hasNext()) {
                    handler.handleStatement((Statement)result.next());
                }
                handler.endRDF();
            }
        }
        catch (InvalidBindingSetException e) {
            httpStatusSetter.accept(400);
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.println(e.getMessage());
            printWriter.flush();
        }
        catch (OntopReformulationException e) {
            httpStatusSetter.accept(500);
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.println("Problem reformulating the underlying SPARQL query: \n" + e.getMessage());
            printWriter.flush();
        }
        catch (EmptyResultException e) {
            httpStatusSetter.accept(404);
            httpHeaderSetter.accept("Content-Type", "text/plain");
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.println(String.format("No result for %s with the parameters %s", predefinedQuery.getId(), bindings));
            printWriter.flush();
        }
        catch (QueryEvaluationException | RDFHandlerException e) {
            throw new LateEvaluationOrConversionException(e);
        }
    }

    private RDFWriterFactory createJSONLDFrameWriterFactory(Map<String, Object> jsonLdFrame, boolean throwExceptionIfEmpty) {
        return new FramedJSONLDWriterFactory(jsonLdFrame, this.documentLoader, throwExceptionIfEmpty);
    }

    private <FF extends FileFormat, S> Optional<FF> extractFormat(Stream<String> acceptMediaTypes, FileFormatServiceRegistry<FF, S> registry, FF defaultFormat, Function<String, Optional<FF>> otherFormatFct) {
        return acceptMediaTypes.map(m -> m.startsWith("*/*") ? Optional.of(defaultFormat) : registry.getFileFormatForMIMEType(m).or(() -> (Optional)otherFormatFct.apply((String)m))).filter(Optional::isPresent).map(Optional::get).filter(f -> registry.get(f).isPresent()).findFirst();
    }

    private Optional<Query.QueryType> getQueryType(String queryId) {
        if (this.graphQueries.containsKey((Object)queryId)) {
            return Optional.of(Query.QueryType.GRAPH);
        }
        if (this.tupleQueries.containsKey((Object)queryId)) {
            return Optional.of(Query.QueryType.TUPLE);
        }
        return Optional.empty();
    }

    @Override
    public GraphQueryResult evaluateGraph(String queryId, ImmutableMap<String, String> bindings) throws QueryEvaluationException {
        PredefinedGraphQuery predefinedQuery = Optional.ofNullable((PredefinedGraphQuery)this.graphQueries.get((Object)queryId)).orElseThrow(() -> new IllegalArgumentException("The query" + queryId + " is not defined as a graph query"));
        ConstructTemplate constructTemplate = predefinedQuery.getConstructTemplate();
        QueryLogger queryLogger = this.createQueryLogger(predefinedQuery, bindings, (ImmutableMap<String, String>)ImmutableMap.of());
        try {
            IQ executableQuery = this.createExecutableQuery(predefinedQuery, bindings, queryLogger);
            return this.executeConstructQuery(constructTemplate, executableQuery, queryLogger);
        }
        catch (OntopReformulationException | InvalidBindingSetException e) {
            throw new QueryEvaluationException(e);
        }
    }

    private IQ createExecutableQuery(PredefinedQuery<?> predefinedQuery, ImmutableMap<String, String> bindings, QueryLogger queryLogger) throws OntopReformulationException, InvalidBindingSetException {
        IQ referenceIQ;
        predefinedQuery.validate(bindings);
        ImmutableMap<String, String> bindingWithReferences = predefinedQuery.replaceWithReferenceValues(bindings);
        IQ existingReferenceIQ = (IQ)this.referenceQueryCache.getIfPresent(bindingWithReferences);
        IQ iQ = referenceIQ = existingReferenceIQ == null ? this.generateReferenceQuery(predefinedQuery, bindingWithReferences) : existingReferenceIQ;
        if (existingReferenceIQ == null) {
            this.referenceQueryCache.put(bindingWithReferences, (Object)referenceIQ);
        }
        IQ newIQ = this.valueReplacer.replaceReferenceValues(referenceIQ, bindings, bindingWithReferences);
        queryLogger.declareReformulationFinishedAndSerialize(newIQ, referenceIQ == existingReferenceIQ);
        return newIQ;
    }

    private IQ generateReferenceQuery(PredefinedQuery<?> predefinedQuery, ImmutableMap<String, String> bindingWithReferences) throws OntopReformulationException {
        BindingSet bindingSet = predefinedQuery.convertBindings(bindingWithReferences);
        RDF4JQuery newQuery = predefinedQuery.getInputQuery().newBindings(bindingSet);
        QueryLogger tmpQueryLogger = this.queryLoggerFactory.create(ImmutableMap.of());
        QueryContext emptyQueryContext = this.queryContextFactory.create(ImmutableMap.of());
        LOGGER.debug("Generating the reference query for {} with ref parameters {}", (Object)predefinedQuery.getId(), (Object)bindingSet);
        return this.queryReformulator.reformulateIntoNativeQuery((KGQuery)newQuery, emptyQueryContext, tmpQueryLogger);
    }

    private QueryLogger createQueryLogger(PredefinedQuery<?> predefinedQuery, ImmutableMap<String, String> bindings, ImmutableMap<String, String> httpHeaders) {
        QueryLogger queryLogger = this.queryLoggerFactory.create(httpHeaders);
        queryLogger.setPredefinedQuery(predefinedQuery.getId(), bindings);
        return queryLogger;
    }

    /*
     * Exception decompiling
     */
    private GraphQueryResult executeConstructQuery(ConstructTemplate constructTemplate, IQ executableQuery, QueryLogger queryLogger) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void evaluateTupleWithHandler(String queryId, ImmutableMap<String, String> bindings, ImmutableList<String> acceptMediaTypes, ImmutableMap<String, String> httpHeaders, BiConsumer<String, String> httpHeaderSetter, Consumer<Integer> httpStatusSetter, OutputStream outputStream) {
        throw new RuntimeException("TODO: support SELECT queries");
    }
}

